/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParameterModelImpl;
import de.datomino.peppergis.dto.area.DeliveryRoundRelationFullDto;
import de.datomino.peppergis.dto.area.DeliveryRoundRelationProxyDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.dto.wage.WageParameterDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.ktde.util.cache.ChangeSet;

public class DeliveryRoundRelationModelImpl
extends AbstractModel<DeliveryRoundRelationFullDto, DeliveryRoundRelationProxyDto>
implements DeliveryRoundRelationModel {
    private DeliveryRoundModel deliveryRound;
    private WageParameterModel parameter;

    public DeliveryRoundRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DeliveryRoundRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public DeliveryRoundModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundModel deliveryRound, boolean setDirty) {
        DeliveryRoundModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DeliveryRoundRelationModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DeliveryRoundRelationModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
    }

    @Override
    public WageParameterModel getParameter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.parameter;
    }

    @Override
    public void setParameter(WageParameterModel parameter) {
        this.setParameter(parameter, true);
    }

    private void setParameter(WageParameterModel parameter, boolean setDirty) {
        WageParameterModel oldParameter = this.getParameter();
        if (oldParameter == parameter) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DeliveryRoundRelationModelEnum.PARAMETER.getPropertyName());
        }
        this.parameter = parameter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DeliveryRoundRelationModelEnum.PARAMETER, parameter, oldParameter);
    }

    @Override
    protected void updateByDto(DeliveryRoundRelationFullDto deliveryRoundRelationDto) {
        this.deliveryRound = (DeliveryRoundModel)this.getModelCache().getModel(deliveryRoundRelationDto.getDeliveryRound());
        this.parameter = (WageParameterModel)this.getModelCache().getModel(deliveryRoundRelationDto.getParameter());
    }

    @Override
    protected void updateMasterRelationsByDto(DeliveryRoundRelationFullDto deliveryRoundRelationDto) {
    }

    @Override
    protected void checkStaleByDto(DeliveryRoundRelationFullDto deliveryRoundRelationDto) throws StaleStateException {
        WageParameterModelImpl parameterModel;
        WageParameterDto parameterDto;
        DeliveryRoundModelImpl deliveryRoundModel;
        DeliveryRoundDto deliveryRoundDto = deliveryRoundRelationDto.getDeliveryRound();
        if (deliveryRoundDto != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundModelImpl)this.getModelCache().getModel(DeliveryRoundModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
        if ((parameterDto = deliveryRoundRelationDto.getParameter()) != null && parameterDto.getId() != null && (parameterModel = (WageParameterModelImpl)this.getModelCache().getModel(WageParameterModel.class, parameterDto.getId())) != null) {
            parameterModel.checkStaleState(parameterDto);
        }
    }

    @Override
    public DeliveryRoundRelationFullDto createDto() {
        WageParameterModelImpl parameter;
        Long id = this.getId();
        DeliveryRoundRelationFullDto deliveryRoundRelationDto = id == null ? new DeliveryRoundRelationFullDto(this.getTempUUID()) : new DeliveryRoundRelationFullDto(id, this.getVersion());
        DeliveryRoundModelImpl deliveryRound = (DeliveryRoundModelImpl)this.getDeliveryRound();
        if (deliveryRound != null) {
            deliveryRoundRelationDto.setDeliveryRound(deliveryRound.createProxy());
        }
        if ((parameter = (WageParameterModelImpl)this.getParameter()) != null) {
            deliveryRoundRelationDto.setParameter(parameter.createProxy());
        }
        return deliveryRoundRelationDto;
    }

    @Override
    public DeliveryRoundRelationProxyDto createProxy() {
        Long id = this.getId();
        DeliveryRoundRelationProxyDto deliveryRoundRelationDto = id == null ? new DeliveryRoundRelationProxyDto(this.getTempUUID()) : new DeliveryRoundRelationProxyDto(id, this.getVersion());
        return deliveryRoundRelationDto;
    }

    public static enum DeliveryRoundRelationModelEnum {
        DELIVERY_ROUND("deliveryRound"),
        PARAMETER("parameter");

        private String propertyName;

        private DeliveryRoundRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

