/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectGenInfoDto;
import de.datomino.peppergis.dto.area.AreaObjectGenSegmentFullDto;
import de.datomino.peppergis.dto.area.AreaObjectGenSegmentProxyDto;
import de.datomino.peppergis.dto.area.AreaObjectGenSegmentRelDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaObjectGenSegmentModelImpl
extends AbstractModel<AreaObjectGenSegmentFullDto, AreaObjectGenSegmentProxyDto>
implements AreaObjectGenSegmentModel {
    private Set<AreaObjectGenSegmentRelModel> segments = null;
    private AreaObjectGenInfoModel genInfo;

    public AreaObjectGenSegmentModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaObjectGenSegmentModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public int countSegments() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return this.segments.size();
    }

    @Override
    public Iterator<AreaObjectGenSegmentRelModel> iterateSegments() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return new ImmutableIterator<AreaObjectGenSegmentRelModel>(this.segments);
    }

    @Override
    public Iterable<AreaObjectGenSegmentRelModel> iterableSegments() {
        return new IteratorIterable<AreaObjectGenSegmentRelModel>(this.iterateSegments());
    }

    @Override
    public void addSegment(AreaObjectGenSegmentRelModel segment) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        if (this.segments.contains(segment)) {
            return;
        }
        this.segments.add(segment);
        this.fireValueChanged(AreaObjectGenSegmentModelEnum.SEGMENTS, segment, null);
        if (segment != null) {
            segment.setGenInfoSegment(this);
        }
    }

    @Override
    public void removeSegment(AreaObjectGenSegmentRelModel segment) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        if (!this.segments.contains(segment)) {
            return;
        }
        this.segments.remove(segment);
        this.fireValueChanged(AreaObjectGenSegmentModelEnum.SEGMENTS, segment, null);
        if (segment != null) {
            segment.setGenInfoSegment(null);
        }
    }

    @Override
    public void clearSegments() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        ArrayList<AreaObjectGenSegmentRelModel> oldSegments = new ArrayList<AreaObjectGenSegmentRelModel>(this.segments);
        this.segments.clear();
        this.fireValueChanged(AreaObjectGenSegmentModelEnum.SEGMENTS, null, null);
        for (AreaObjectGenSegmentRelModel oldSegment : oldSegments) {
            if (oldSegment == null) continue;
            oldSegment.setGenInfoSegment(null);
        }
    }

    @Override
    public boolean isSegmentsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return this.segments.isEmpty();
    }

    @Override
    public boolean containsSegment(AreaObjectGenSegmentRelModel segment) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.segments == null) {
            this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            if (this.getId() != null) {
                Collection segmentsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenSegmentModelEnum.SEGMENTS.getPropertyName());
                this.segments.addAll(segmentsCollection);
            }
        }
        return this.segments.contains(segment);
    }

    @Override
    public boolean isSegmentsInitialized() {
        return this.segments != null;
    }

    @Override
    public AreaObjectGenInfoModel getGenInfo() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.genInfo;
    }

    @Override
    public void setGenInfo(AreaObjectGenInfoModel genInfo) {
        this.setGenInfo(genInfo, true);
    }

    private void setGenInfo(AreaObjectGenInfoModel genInfo, boolean setDirty) {
        AreaObjectGenInfoModel oldGenInfo = this.getGenInfo();
        if (oldGenInfo == genInfo) {
            return;
        }
        if (oldGenInfo != null) {
            oldGenInfo.setAreaObjectGenSegment(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectGenSegmentModelEnum.GEN_INFO.getPropertyName());
        }
        this.genInfo = genInfo;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectGenSegmentModelEnum.GEN_INFO, genInfo, oldGenInfo);
        if (this.genInfo != null) {
            this.genInfo.setAreaObjectGenSegment(this);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.segments = null;
        }
    }

    @Override
    protected void updateByDto(AreaObjectGenSegmentFullDto areaObjectGenSegmentDto) {
        AreaObjectGenSegmentRelDto[] segments = areaObjectGenSegmentDto.getSegments();
        if (segments != null) {
            if (this.segments == null) {
                this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            } else {
                this.segments.clear();
            }
        }
        this.genInfo = (AreaObjectGenInfoModel)this.getModelCache().getModel(areaObjectGenSegmentDto.getGenInfo());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaObjectGenSegmentFullDto areaObjectGenSegmentDto) {
        AreaObjectGenSegmentRelDto[] segments = areaObjectGenSegmentDto.getSegments();
        if (segments != null) {
            if (this.segments == null) {
                this.segments = new LinkedHashSet<AreaObjectGenSegmentRelModel>();
            } else {
                this.segments.clear();
            }
            for (AreaObjectGenSegmentRelDto segmentDto : segments) {
                AreaObjectGenSegmentRelModel segmentModel = (AreaObjectGenSegmentRelModel)this.getModelCache().getModel(segmentDto);
                this.segments.add(segmentModel);
            }
        } else {
            this.segments = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaObjectGenSegmentFullDto areaObjectGenSegmentDto) throws StaleStateException {
        AreaObjectGenInfoModelImpl genInfoModel;
        AreaObjectGenInfoDto genInfoDto;
        AreaObjectGenSegmentRelDto[] segmentDtos = areaObjectGenSegmentDto.getSegments();
        if (segmentDtos != null) {
            for (AreaObjectGenSegmentRelDto segmentDto : segmentDtos) {
                AreaObjectGenSegmentRelModelImpl segmentModel = (AreaObjectGenSegmentRelModelImpl)this.getModelCache().getModel(AreaObjectGenSegmentRelModel.class, segmentDto.getId());
                if (segmentModel == null) continue;
                segmentModel.checkStaleState(segmentDto);
            }
        }
        if ((genInfoDto = areaObjectGenSegmentDto.getGenInfo()) != null && genInfoDto.getId() != null && (genInfoModel = (AreaObjectGenInfoModelImpl)this.getModelCache().getModel(AreaObjectGenInfoModel.class, genInfoDto.getId())) != null) {
            genInfoModel.checkStaleState(genInfoDto);
        }
    }

    @Override
    public AreaObjectGenSegmentFullDto createDto() {
        Long id = this.getId();
        AreaObjectGenSegmentFullDto areaObjectGenSegmentDto = id == null ? new AreaObjectGenSegmentFullDto(this.getTempUUID()) : new AreaObjectGenSegmentFullDto(id, this.getVersion());
        AreaObjectGenInfoModelImpl genInfo = (AreaObjectGenInfoModelImpl)this.getGenInfo();
        if (genInfo != null) {
            areaObjectGenSegmentDto.setGenInfo(genInfo.createProxy());
        }
        return areaObjectGenSegmentDto;
    }

    @Override
    public AreaObjectGenSegmentProxyDto createProxy() {
        Long id = this.getId();
        AreaObjectGenSegmentProxyDto areaObjectGenSegmentDto = id == null ? new AreaObjectGenSegmentProxyDto(this.getTempUUID()) : new AreaObjectGenSegmentProxyDto(id, this.getVersion());
        return areaObjectGenSegmentDto;
    }

    public static enum AreaObjectGenSegmentModelEnum {
        SEGMENTS("segments"),
        GEN_INFO("genInfo");

        private String propertyName;

        private AreaObjectGenSegmentModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

