/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectGenAreaObjectFullDto;
import de.datomino.peppergis.dto.area.AreaObjectGenAreaObjectProxyDto;
import de.datomino.peppergis.dto.area.AreaObjectGenAreaObjectRelDto;
import de.datomino.peppergis.dto.area.AreaObjectGenInfoDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaObjectGenAreaObjectModelImpl
extends AbstractModel<AreaObjectGenAreaObjectFullDto, AreaObjectGenAreaObjectProxyDto>
implements AreaObjectGenAreaObjectModel {
    private Set<AreaObjectGenAreaObjectRelModel> areaObjects = null;
    private AreaObjectGenInfoModel genInfo;

    public AreaObjectGenAreaObjectModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaObjectGenAreaObjectModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public int countAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.size();
    }

    @Override
    public Iterator<AreaObjectGenAreaObjectRelModel> iterateAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return new ImmutableIterator<AreaObjectGenAreaObjectRelModel>(this.areaObjects);
    }

    @Override
    public Iterable<AreaObjectGenAreaObjectRelModel> iterableAreaObjects() {
        return new IteratorIterable<AreaObjectGenAreaObjectRelModel>(this.iterateAreaObjects());
    }

    @Override
    public void addAreaObject(AreaObjectGenAreaObjectRelModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        if (this.areaObjects.contains(areaObject)) {
            return;
        }
        this.areaObjects.add(areaObject);
        this.fireValueChanged(AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS, areaObject, null);
        if (areaObject != null) {
            areaObject.setGenInfoAreaObject(this);
        }
    }

    @Override
    public void removeAreaObject(AreaObjectGenAreaObjectRelModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        if (!this.areaObjects.contains(areaObject)) {
            return;
        }
        this.areaObjects.remove(areaObject);
        this.fireValueChanged(AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS, areaObject, null);
        if (areaObject != null) {
            areaObject.setGenInfoAreaObject(null);
        }
    }

    @Override
    public void clearAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        ArrayList<AreaObjectGenAreaObjectRelModel> oldAreaObjects = new ArrayList<AreaObjectGenAreaObjectRelModel>(this.areaObjects);
        this.areaObjects.clear();
        this.fireValueChanged(AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS, null, null);
        for (AreaObjectGenAreaObjectRelModel oldAreaObject : oldAreaObjects) {
            if (oldAreaObject == null) continue;
            oldAreaObject.setGenInfoAreaObject(null);
        }
    }

    @Override
    public boolean isAreaObjectsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.isEmpty();
    }

    @Override
    public boolean containsAreaObject(AreaObjectGenAreaObjectRelModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, AreaObjectGenAreaObjectModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.contains(areaObject);
    }

    @Override
    public boolean isAreaObjectsInitialized() {
        return this.areaObjects != null;
    }

    @Override
    public AreaObjectGenInfoModel getGenInfo() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.genInfo;
    }

    @Override
    public void setGenInfo(AreaObjectGenInfoModel genInfo) {
        this.setGenInfo(genInfo, true);
    }

    private void setGenInfo(AreaObjectGenInfoModel genInfo, boolean setDirty) {
        AreaObjectGenInfoModel oldGenInfo = this.getGenInfo();
        if (oldGenInfo == genInfo) {
            return;
        }
        if (oldGenInfo != null) {
            oldGenInfo.setAreaObjectGenAreaObject(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaObjectGenAreaObjectModelEnum.GEN_INFO.getPropertyName());
        }
        this.genInfo = genInfo;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaObjectGenAreaObjectModelEnum.GEN_INFO, genInfo, oldGenInfo);
        if (this.genInfo != null) {
            this.genInfo.setAreaObjectGenAreaObject(this);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.areaObjects = null;
        }
    }

    @Override
    protected void updateByDto(AreaObjectGenAreaObjectFullDto areaObjectGenAreaObjectDto) {
        AreaObjectGenAreaObjectRelDto[] areaObjects = areaObjectGenAreaObjectDto.getAreaObjects();
        if (areaObjects != null) {
            if (this.areaObjects == null) {
                this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            } else {
                this.areaObjects.clear();
            }
        }
        this.genInfo = (AreaObjectGenInfoModel)this.getModelCache().getModel(areaObjectGenAreaObjectDto.getGenInfo());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaObjectGenAreaObjectFullDto areaObjectGenAreaObjectDto) {
        AreaObjectGenAreaObjectRelDto[] areaObjects = areaObjectGenAreaObjectDto.getAreaObjects();
        if (areaObjects != null) {
            if (this.areaObjects == null) {
                this.areaObjects = new LinkedHashSet<AreaObjectGenAreaObjectRelModel>();
            } else {
                this.areaObjects.clear();
            }
            for (AreaObjectGenAreaObjectRelDto areaObjectDto : areaObjects) {
                AreaObjectGenAreaObjectRelModel areaObjectModel = (AreaObjectGenAreaObjectRelModel)this.getModelCache().getModel(areaObjectDto);
                this.areaObjects.add(areaObjectModel);
            }
        } else {
            this.areaObjects = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaObjectGenAreaObjectFullDto areaObjectGenAreaObjectDto) throws StaleStateException {
        AreaObjectGenInfoModelImpl genInfoModel;
        AreaObjectGenInfoDto genInfoDto;
        AreaObjectGenAreaObjectRelDto[] areaObjectDtos = areaObjectGenAreaObjectDto.getAreaObjects();
        if (areaObjectDtos != null) {
            for (AreaObjectGenAreaObjectRelDto areaObjectDto : areaObjectDtos) {
                AreaObjectGenAreaObjectRelModelImpl areaObjectModel = (AreaObjectGenAreaObjectRelModelImpl)this.getModelCache().getModel(AreaObjectGenAreaObjectRelModel.class, areaObjectDto.getId());
                if (areaObjectModel == null) continue;
                areaObjectModel.checkStaleState(areaObjectDto);
            }
        }
        if ((genInfoDto = areaObjectGenAreaObjectDto.getGenInfo()) != null && genInfoDto.getId() != null && (genInfoModel = (AreaObjectGenInfoModelImpl)this.getModelCache().getModel(AreaObjectGenInfoModel.class, genInfoDto.getId())) != null) {
            genInfoModel.checkStaleState(genInfoDto);
        }
    }

    @Override
    public AreaObjectGenAreaObjectFullDto createDto() {
        Long id = this.getId();
        AreaObjectGenAreaObjectFullDto areaObjectGenAreaObjectDto = id == null ? new AreaObjectGenAreaObjectFullDto(this.getTempUUID()) : new AreaObjectGenAreaObjectFullDto(id, this.getVersion());
        AreaObjectGenInfoModelImpl genInfo = (AreaObjectGenInfoModelImpl)this.getGenInfo();
        if (genInfo != null) {
            areaObjectGenAreaObjectDto.setGenInfo(genInfo.createProxy());
        }
        return areaObjectGenAreaObjectDto;
    }

    @Override
    public AreaObjectGenAreaObjectProxyDto createProxy() {
        Long id = this.getId();
        AreaObjectGenAreaObjectProxyDto areaObjectGenAreaObjectDto = id == null ? new AreaObjectGenAreaObjectProxyDto(this.getTempUUID()) : new AreaObjectGenAreaObjectProxyDto(id, this.getVersion());
        return areaObjectGenAreaObjectDto;
    }

    public static enum AreaObjectGenAreaObjectModelEnum {
        AREA_OBJECTS("areaObjects"),
        GEN_INFO("genInfo");

        private String propertyName;

        private AreaObjectGenAreaObjectModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

