/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModelImpl;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundReplacementModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundDto;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundReplacementFullDto;
import de.datomino.peppergis.dto.area.AreaDeliveryRoundReplacementProxyDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaDeliveryRoundReplacementModelImpl
extends AbstractModel<AreaDeliveryRoundReplacementFullDto, AreaDeliveryRoundReplacementProxyDto>
implements AreaDeliveryRoundReplacementModel {
    private DeliveryRoundModel deliveryRound;
    private Date startTime;
    private Date endTime;
    private AreaObjectModel replacementAreaObject;
    private AreaDeliveryRoundModel areaDeliveryRound;

    public AreaDeliveryRoundReplacementModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaDeliveryRoundReplacementModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public DeliveryRoundModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundModel deliveryRound, boolean setDirty) {
        DeliveryRoundModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundReplacementModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundReplacementModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
    }

    @Override
    public Date getStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.setStartTime(startTime, true);
    }

    private void setStartTime(Date startTime, boolean setDirty) {
        Date oldStartTime = this.getStartTime();
        if (new EqualsBuilder().append(oldStartTime, startTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundReplacementModelEnum.START_TIME.getPropertyName());
        }
        this.startTime = startTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundReplacementModelEnum.START_TIME, startTime, oldStartTime);
    }

    @Override
    public Date getEndTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.setEndTime(endTime, true);
    }

    private void setEndTime(Date endTime, boolean setDirty) {
        Date oldEndTime = this.getEndTime();
        if (new EqualsBuilder().append(oldEndTime, endTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundReplacementModelEnum.END_TIME.getPropertyName());
        }
        this.endTime = endTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundReplacementModelEnum.END_TIME, endTime, oldEndTime);
    }

    @Override
    public AreaObjectModel getReplacementAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.replacementAreaObject;
    }

    @Override
    public void setReplacementAreaObject(AreaObjectModel replacementAreaObject) {
        this.setReplacementAreaObject(replacementAreaObject, true);
    }

    private void setReplacementAreaObject(AreaObjectModel replacementAreaObject, boolean setDirty) {
        AreaObjectModel oldReplacementAreaObject = this.getReplacementAreaObject();
        if (oldReplacementAreaObject == replacementAreaObject) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundReplacementModelEnum.REPLACEMENT_AREA_OBJECT.getPropertyName());
        }
        this.replacementAreaObject = replacementAreaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundReplacementModelEnum.REPLACEMENT_AREA_OBJECT, replacementAreaObject, oldReplacementAreaObject);
    }

    @Override
    public AreaDeliveryRoundModel getAreaDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaDeliveryRound;
    }

    @Override
    public void setAreaDeliveryRound(AreaDeliveryRoundModel areaDeliveryRound) {
        this.setAreaDeliveryRound(areaDeliveryRound, true);
    }

    private void setAreaDeliveryRound(AreaDeliveryRoundModel areaDeliveryRound, boolean setDirty) {
        AreaDeliveryRoundModel oldAreaDeliveryRound = this.getAreaDeliveryRound();
        if (oldAreaDeliveryRound == areaDeliveryRound) {
            return;
        }
        if (oldAreaDeliveryRound != null) {
            oldAreaDeliveryRound.removeReplacement(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDeliveryRoundReplacementModelEnum.AREA_DELIVERY_ROUND.getPropertyName());
        }
        this.areaDeliveryRound = areaDeliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDeliveryRoundReplacementModelEnum.AREA_DELIVERY_ROUND, areaDeliveryRound, oldAreaDeliveryRound);
        if (this.areaDeliveryRound != null) {
            this.areaDeliveryRound.addReplacement(this);
        }
    }

    @Override
    protected void updateByDto(AreaDeliveryRoundReplacementFullDto areaDeliveryRoundReplacementDto) {
        this.deliveryRound = (DeliveryRoundModel)this.getModelCache().getModel(areaDeliveryRoundReplacementDto.getDeliveryRound());
        this.startTime = areaDeliveryRoundReplacementDto.getStartTime();
        this.endTime = areaDeliveryRoundReplacementDto.getEndTime();
        this.replacementAreaObject = (AreaObjectModel)this.getModelCache().getModel(areaDeliveryRoundReplacementDto.getReplacementAreaObject());
        this.areaDeliveryRound = (AreaDeliveryRoundModel)this.getModelCache().getModel(areaDeliveryRoundReplacementDto.getAreaDeliveryRound());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaDeliveryRoundReplacementFullDto areaDeliveryRoundReplacementDto) {
    }

    @Override
    protected void checkStaleByDto(AreaDeliveryRoundReplacementFullDto areaDeliveryRoundReplacementDto) throws StaleStateException {
        AreaDeliveryRoundModelImpl areaDeliveryRoundModel;
        AreaDeliveryRoundDto areaDeliveryRoundDto;
        AreaObjectModelImpl replacementAreaObjectModel;
        AreaObjectDto replacementAreaObjectDto;
        DeliveryRoundModelImpl deliveryRoundModel;
        DeliveryRoundDto deliveryRoundDto = areaDeliveryRoundReplacementDto.getDeliveryRound();
        if (deliveryRoundDto != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundModelImpl)this.getModelCache().getModel(DeliveryRoundModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
        if ((replacementAreaObjectDto = areaDeliveryRoundReplacementDto.getReplacementAreaObject()) != null && replacementAreaObjectDto.getId() != null && (replacementAreaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, replacementAreaObjectDto.getId())) != null) {
            replacementAreaObjectModel.checkStaleState(replacementAreaObjectDto);
        }
        if ((areaDeliveryRoundDto = areaDeliveryRoundReplacementDto.getAreaDeliveryRound()) != null && areaDeliveryRoundDto.getId() != null && (areaDeliveryRoundModel = (AreaDeliveryRoundModelImpl)this.getModelCache().getModel(AreaDeliveryRoundModel.class, areaDeliveryRoundDto.getId())) != null) {
            areaDeliveryRoundModel.checkStaleState(areaDeliveryRoundDto);
        }
    }

    @Override
    public AreaDeliveryRoundReplacementFullDto createDto() {
        AreaDeliveryRoundModelImpl areaDeliveryRound;
        Long id = this.getId();
        AreaDeliveryRoundReplacementFullDto areaDeliveryRoundReplacementDto = id == null ? new AreaDeliveryRoundReplacementFullDto(this.getTempUUID()) : new AreaDeliveryRoundReplacementFullDto(id, this.getVersion());
        DeliveryRoundModelImpl deliveryRound = (DeliveryRoundModelImpl)this.getDeliveryRound();
        if (deliveryRound != null) {
            areaDeliveryRoundReplacementDto.setDeliveryRound(deliveryRound.createProxy());
        }
        areaDeliveryRoundReplacementDto.setStartTime(this.getStartTime());
        areaDeliveryRoundReplacementDto.setEndTime(this.getEndTime());
        AreaObjectModelImpl replacementAreaObject = (AreaObjectModelImpl)this.getReplacementAreaObject();
        if (replacementAreaObject != null) {
            areaDeliveryRoundReplacementDto.setReplacementAreaObject(replacementAreaObject.createProxy());
        }
        if ((areaDeliveryRound = (AreaDeliveryRoundModelImpl)this.getAreaDeliveryRound()) != null) {
            areaDeliveryRoundReplacementDto.setAreaDeliveryRound(areaDeliveryRound.createProxy());
        }
        return areaDeliveryRoundReplacementDto;
    }

    @Override
    public AreaDeliveryRoundReplacementProxyDto createProxy() {
        Long id = this.getId();
        AreaDeliveryRoundReplacementProxyDto areaDeliveryRoundReplacementDto = id == null ? new AreaDeliveryRoundReplacementProxyDto(this.getTempUUID()) : new AreaDeliveryRoundReplacementProxyDto(id, this.getVersion());
        return areaDeliveryRoundReplacementDto;
    }

    public static enum AreaDeliveryRoundReplacementModelEnum {
        DELIVERY_ROUND("deliveryRound"),
        START_TIME("startTime"),
        END_TIME("endTime"),
        REPLACEMENT_AREA_OBJECT("replacementAreaObject"),
        AREA_DELIVERY_ROUND("areaDeliveryRound");

        private String propertyName;

        private AreaDeliveryRoundReplacementModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

