/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.admin;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.SubSessionModel;
import de.datomino.peppergis.client.model.admin.SubSessionModelImpl;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.admin.UserSessionModel;
import de.datomino.peppergis.dto.admin.SubSessionDto;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.admin.UserSessionFullDto;
import de.datomino.peppergis.dto.admin.UserSessionProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class UserSessionModelImpl
extends AbstractModel<UserSessionFullDto, UserSessionProxyDto>
implements UserSessionModel {
    private UserModel user;
    private Date loginTime;
    private Date heartBeatTime;
    private Set<SubSessionModel> subSessions = null;

    public UserSessionModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public UserSessionModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public UserModel getUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.user;
    }

    @Override
    public void setUser(UserModel user) {
        this.setUser(user, true);
    }

    private void setUser(UserModel user, boolean setDirty) {
        UserModel oldUser = this.getUser();
        if (oldUser == user) {
            return;
        }
        if (oldUser != null) {
            oldUser.removeUserSession(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserSessionModelEnum.USER.getPropertyName());
        }
        this.user = user;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserSessionModelEnum.USER, user, oldUser);
        if (this.user != null) {
            this.user.addUserSession(this);
        }
    }

    @Override
    public Date getLoginTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.loginTime;
    }

    @Override
    public void setLoginTime(Date loginTime) {
        this.setLoginTime(loginTime, true);
    }

    private void setLoginTime(Date loginTime, boolean setDirty) {
        Date oldLoginTime = this.getLoginTime();
        if (new EqualsBuilder().append(oldLoginTime, loginTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserSessionModelEnum.LOGIN_TIME.getPropertyName());
        }
        this.loginTime = loginTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserSessionModelEnum.LOGIN_TIME, loginTime, oldLoginTime);
    }

    @Override
    public Date getHeartBeatTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.heartBeatTime;
    }

    @Override
    public void setHeartBeatTime(Date heartBeatTime) {
        this.setHeartBeatTime(heartBeatTime, true);
    }

    private void setHeartBeatTime(Date heartBeatTime, boolean setDirty) {
        Date oldHeartBeatTime = this.getHeartBeatTime();
        if (new EqualsBuilder().append(oldHeartBeatTime, heartBeatTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserSessionModelEnum.HEART_BEAT_TIME.getPropertyName());
        }
        this.heartBeatTime = heartBeatTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserSessionModelEnum.HEART_BEAT_TIME, heartBeatTime, oldHeartBeatTime);
    }

    @Override
    public int countSubSessions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        return this.subSessions.size();
    }

    @Override
    public Iterator<SubSessionModel> iterateSubSessions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        return new ImmutableIterator<SubSessionModel>(this.subSessions);
    }

    @Override
    public Iterable<SubSessionModel> iterableSubSessions() {
        return new IteratorIterable<SubSessionModel>(this.iterateSubSessions());
    }

    @Override
    public void addSubSession(SubSessionModel subSession) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        if (this.subSessions.contains(subSession)) {
            return;
        }
        this.subSessions.add(subSession);
        this.fireValueChanged(UserSessionModelEnum.SUB_SESSIONS, subSession, null);
        if (subSession != null) {
            subSession.setUserSession(this);
        }
    }

    @Override
    public void removeSubSession(SubSessionModel subSession) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        if (!this.subSessions.contains(subSession)) {
            return;
        }
        this.subSessions.remove(subSession);
        this.fireValueChanged(UserSessionModelEnum.SUB_SESSIONS, subSession, null);
        if (subSession != null) {
            subSession.setUserSession(null);
        }
    }

    @Override
    public void clearSubSessions() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        ArrayList<SubSessionModel> oldSubSessions = new ArrayList<SubSessionModel>(this.subSessions);
        this.subSessions.clear();
        this.fireValueChanged(UserSessionModelEnum.SUB_SESSIONS, null, null);
        for (SubSessionModel oldSubSession : oldSubSessions) {
            if (oldSubSession == null) continue;
            oldSubSession.setUserSession(null);
        }
    }

    @Override
    public boolean isSubSessionsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        return this.subSessions.isEmpty();
    }

    @Override
    public boolean containsSubSession(SubSessionModel subSession) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subSessions == null) {
            this.subSessions = new LinkedHashSet<SubSessionModel>();
            if (this.getId() != null) {
                Collection subSessionsCollection = this.commonCaller.fetchChildren(this, UserSessionModelEnum.SUB_SESSIONS.getPropertyName());
                this.subSessions.addAll(subSessionsCollection);
            }
        }
        return this.subSessions.contains(subSession);
    }

    @Override
    public boolean isSubSessionsInitialized() {
        return this.subSessions != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.subSessions = null;
        }
    }

    @Override
    protected void updateByDto(UserSessionFullDto userSessionDto) {
        this.user = (UserModel)this.getModelCache().getModel(userSessionDto.getUser());
        this.loginTime = userSessionDto.getLoginTime();
        this.heartBeatTime = userSessionDto.getHeartBeatTime();
        SubSessionDto[] subSessions = userSessionDto.getSubSessions();
        if (subSessions != null) {
            if (this.subSessions == null) {
                this.subSessions = new LinkedHashSet<SubSessionModel>();
            } else {
                this.subSessions.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(UserSessionFullDto userSessionDto) {
        SubSessionDto[] subSessions = userSessionDto.getSubSessions();
        if (subSessions != null) {
            if (this.subSessions == null) {
                this.subSessions = new LinkedHashSet<SubSessionModel>();
            } else {
                this.subSessions.clear();
            }
            for (SubSessionDto subSessionDto : subSessions) {
                SubSessionModel subSessionModel = (SubSessionModel)this.getModelCache().getModel(subSessionDto);
                this.subSessions.add(subSessionModel);
            }
        } else {
            this.subSessions = null;
        }
    }

    @Override
    protected void checkStaleByDto(UserSessionFullDto userSessionDto) throws StaleStateException {
        SubSessionDto[] subSessionDtos;
        UserModelImpl userModel;
        UserDto userDto = userSessionDto.getUser();
        if (userDto != null && userDto.getId() != null && (userModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, userDto.getId())) != null) {
            userModel.checkStaleState(userDto);
        }
        if ((subSessionDtos = userSessionDto.getSubSessions()) != null) {
            for (SubSessionDto subSessionDto : subSessionDtos) {
                SubSessionModelImpl subSessionModel = (SubSessionModelImpl)this.getModelCache().getModel(SubSessionModel.class, subSessionDto.getId());
                if (subSessionModel == null) continue;
                subSessionModel.checkStaleState(subSessionDto);
            }
        }
    }

    @Override
    public UserSessionFullDto createDto() {
        Long id = this.getId();
        UserSessionFullDto userSessionDto = id == null ? new UserSessionFullDto(this.getTempUUID()) : new UserSessionFullDto(id, this.getVersion());
        UserModelImpl user = (UserModelImpl)this.getUser();
        if (user != null) {
            userSessionDto.setUser(user.createProxy());
        }
        userSessionDto.setLoginTime(this.getLoginTime());
        userSessionDto.setHeartBeatTime(this.getHeartBeatTime());
        return userSessionDto;
    }

    @Override
    public UserSessionProxyDto createProxy() {
        Long id = this.getId();
        UserSessionProxyDto userSessionDto = id == null ? new UserSessionProxyDto(this.getTempUUID()) : new UserSessionProxyDto(id, this.getVersion());
        return userSessionDto;
    }

    public static enum UserSessionModelEnum {
        USER("user"),
        LOGIN_TIME("loginTime"),
        HEART_BEAT_TIME("heartBeatTime"),
        SUB_SESSIONS("subSessions");

        private String propertyName;

        private UserSessionModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

