/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.admin;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModel;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.admin.UserRoleObjectFullDto;
import de.datomino.peppergis.dto.admin.UserRoleObjectProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.UserRole;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class UserRoleObjectModelImpl
extends AbstractModel<UserRoleObjectFullDto, UserRoleObjectProxyDto>
implements UserRoleObjectModel {
    private UserModel user;
    private UserRole userRole;
    private Long attachedId;

    public UserRoleObjectModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public UserRoleObjectModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public UserModel getUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.user;
    }

    @Override
    public void setUser(UserModel user) {
        this.setUser(user, true);
    }

    private void setUser(UserModel user, boolean setDirty) {
        UserModel oldUser = this.getUser();
        if (oldUser == user) {
            return;
        }
        if (oldUser != null) {
            oldUser.removeUserRoleObject(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserRoleObjectModelEnum.USER.getPropertyName());
        }
        this.user = user;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserRoleObjectModelEnum.USER, user, oldUser);
        if (this.user != null) {
            this.user.addUserRoleObject(this);
        }
    }

    @Override
    public UserRole getUserRole() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.userRole;
    }

    @Override
    public void setUserRole(UserRole userRole) {
        this.setUserRole(userRole, true);
    }

    private void setUserRole(UserRole userRole, boolean setDirty) {
        UserRole oldUserRole = this.getUserRole();
        if (new EqualsBuilder().append((Object)oldUserRole, (Object)userRole).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserRoleObjectModelEnum.USER_ROLE.getPropertyName());
        }
        this.userRole = userRole;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserRoleObjectModelEnum.USER_ROLE, (Object)userRole, (Object)oldUserRole);
    }

    @Override
    public Long getAttachedId() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.attachedId;
    }

    @Override
    public void setAttachedId(Long attachedId) {
        this.setAttachedId(attachedId, true);
    }

    private void setAttachedId(Long attachedId, boolean setDirty) {
        Long oldAttachedId = this.getAttachedId();
        if (new EqualsBuilder().append(oldAttachedId, attachedId).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, UserRoleObjectModelEnum.ATTACHED_ID.getPropertyName());
        }
        this.attachedId = attachedId;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(UserRoleObjectModelEnum.ATTACHED_ID, attachedId, oldAttachedId);
    }

    @Override
    protected void updateByDto(UserRoleObjectFullDto userRoleObjectDto) {
        this.user = (UserModel)this.getModelCache().getModel(userRoleObjectDto.getUser());
        this.userRole = userRoleObjectDto.getUserRole();
        this.attachedId = userRoleObjectDto.getAttachedId();
    }

    @Override
    protected void updateMasterRelationsByDto(UserRoleObjectFullDto userRoleObjectDto) {
    }

    @Override
    protected void checkStaleByDto(UserRoleObjectFullDto userRoleObjectDto) throws StaleStateException {
        UserModelImpl userModel;
        UserDto userDto = userRoleObjectDto.getUser();
        if (userDto != null && userDto.getId() != null && (userModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, userDto.getId())) != null) {
            userModel.checkStaleState(userDto);
        }
    }

    @Override
    public UserRoleObjectFullDto createDto() {
        Long id = this.getId();
        UserRoleObjectFullDto userRoleObjectDto = id == null ? new UserRoleObjectFullDto(this.getTempUUID()) : new UserRoleObjectFullDto(id, this.getVersion());
        UserModelImpl user = (UserModelImpl)this.getUser();
        if (user != null) {
            userRoleObjectDto.setUser(user.createProxy());
        }
        userRoleObjectDto.setUserRole(this.getUserRole());
        userRoleObjectDto.setAttachedId(this.getAttachedId());
        return userRoleObjectDto;
    }

    @Override
    public UserRoleObjectProxyDto createProxy() {
        Long id = this.getId();
        UserRoleObjectProxyDto userRoleObjectDto = id == null ? new UserRoleObjectProxyDto(this.getTempUUID()) : new UserRoleObjectProxyDto(id, this.getVersion());
        return userRoleObjectDto;
    }

    public static enum UserRoleObjectModelEnum {
        USER("user"),
        USER_ROLE("userRole"),
        ATTACHED_ID("attachedId");

        private String propertyName;

        private UserRoleObjectModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

