/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model;

import de.datomino.peppergis.client.communication.CommonCallerImpl;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.CustomUndoEditable;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.MovingUndoEditable;
import de.datomino.peppergis.client.model.UndoManagerListener;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.i18n.MessageDto;
import de.datomino.peppergis.exception.ValidateException;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import org.ktde.model.AbstractSaveModelsAction;
import org.ktde.util.ContextLocal;
import org.ktde.util.LogUtil;
import org.ktde.util.StringUtil;
import org.ktde.util.cache.ChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoManager
extends org.ktde.swing.UndoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoManager.class);
    private List<UndoManagerListener> listeners = new ArrayList<UndoManagerListener>();
    private final CommonCallerImpl commonCaller;
    private static ContextLocal<UndoManager> currentUndoManager = new ContextLocal();
    private Component parent;
    private boolean showUndoRedoNames;

    public UndoManager(ModelCache modelCache, Component parent, boolean showUndoRedoNames) {
        super(null);
        this.commonCaller = (CommonCallerImpl)modelCache.getCommonCaller();
        this.parent = parent;
        this.showUndoRedoNames = showUndoRedoNames;
        this.setSaveAction(new AbstractSaveModelsAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = 7521401106154326421L;

            @Override
            public boolean performSave() {
                try {
                    UndoManager.this.storeTransactions();
                }
                catch (ValidateException e) {
                    UndoManager.this.handleValidateException(e);
                }
                return true;
            }
        });
    }

    public void handleValidateException(ValidateException ex) {
        if (this.parent != null) {
            Map<Dto, List<MessageDto>> errormessages = ex.getErrormessages();
            LinkedList<String> sList = new LinkedList<String>();
            for (List<MessageDto> messageDtos : errormessages.values()) {
                for (MessageDto messageDto : messageDtos) {
                    sList.add(ModelEnviroment.getMessageResolver().resolveMessage(messageDto.getMessageKey(), messageDto.getArgs()));
                }
            }
            JOptionPane.showMessageDialog(this.parent, StringUtil.implode(sList, "\n"), "Fehler", 0);
        } else {
            LOGGER.warn(ex.getMessage(), ex);
        }
    }

    public void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.listeners.add(undoManagerListener);
    }

    @Override
    public void joinTransaction() {
        ChangeSet.currentChangeTransaction.setContextObject(this);
        currentUndoManager.setContextObject(this);
        currentUndoManager.set(this);
    }

    @Override
    public void startTransaction() {
        this.joinTransaction();
        if (ChangeSet.currentChangeTransaction.get() == null) {
            LOGGER.debug("BEGIN ");
            ChangeSet.currentChangeTransaction.set(new ArrayList());
        }
    }

    @Override
    public synchronized void finishTransaction(String name) {
        this.finishTransaction(name, null);
    }

    public synchronized void finishTransaction(String name, List<? extends CustomUndoEditable> customUndos) {
        this.joinTransaction();
        LOGGER.debug("FINISH " + name);
        List<ChangeSet> transaction = ChangeSet.currentChangeTransaction.get();
        ChangeSet.currentChangeTransaction.remove();
        if (transaction != null && !transaction.isEmpty()) {
            UndoableEditEvent e = new UndoableEditEvent(this, new MovingUndoEditable(name, transaction, this.listeners, customUndos));
            this.pushUndoEvent(e);
        }
    }

    public synchronized boolean hasCurrentTransactionChanges() {
        ContextLocal<List<ChangeSet>> currentChangeTransaction = ChangeSet.currentChangeTransaction;
        if (currentChangeTransaction != null) {
            List<ChangeSet> list = currentChangeTransaction.get();
            return list != null && !list.isEmpty();
        }
        return false;
    }

    @Override
    public synchronized void rollbackTransaction() {
        this.rollbackTransaction(null);
    }

    public synchronized void rollbackTransaction(List<? extends CustomUndoEditable> customUndos) {
        this.joinTransaction();
        LOGGER.debug("ROLLBACK ");
        LOGGER.debug(LogUtil.currentStackTrace());
        List<ChangeSet> transaction = ChangeSet.currentChangeTransaction.get();
        ChangeSet.currentChangeTransaction.remove();
        if (transaction != null && !transaction.isEmpty()) {
            MovingUndoEditable editable = new MovingUndoEditable("temp", transaction, this.listeners, customUndos);
            editable.undo();
        }
    }

    public <T> Collection<T> getChangedObjects(Class<T> clazz) {
        HashSet<Object> result = new HashSet<Object>();
        for (UndoableEditEvent event : this.getCurrentUndoEvents()) {
            List<ChangeSet> changeSets = ((MovingUndoEditable)event.getEdit()).getChanges();
            for (ChangeSet changeSet : changeSets) {
                Object o = changeSet.getObject();
                if (!clazz.isAssignableFrom(o.getClass())) continue;
                Object t = o;
                result.add(t);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void storeTransactions() throws ValidateException {
        List<UndoableEditEvent> eventlist = this.getCurrentUndoEvents();
        this.storeTransactions(eventlist);
        this.clear();
    }

    private void storeTransactions(List<UndoableEditEvent> eventlist) throws ValidateException {
        LOGGER.trace("process " + eventlist.size() + " events to store");
        LinkedHashSet<AbstractModel> updates = new LinkedHashSet<AbstractModel>();
        LinkedHashSet<AbstractModel> deletes = new LinkedHashSet<AbstractModel>();
        LinkedHashSet<AbstractModel> inserts = new LinkedHashSet<AbstractModel>();
        for (UndoableEditEvent undoableEditEvent : eventlist) {
            List<ChangeSet> changeSets = ((MovingUndoEditable)undoableEditEvent.getEdit()).getChanges();
            for (ChangeSet changeSet : changeSets) {
                AbstractModel object = (AbstractModel)changeSet.getObject();
                if (changeSet.isCreate()) {
                    inserts.add(object);
                    continue;
                }
                if (changeSet.isDelete()) {
                    deletes.add(object);
                    continue;
                }
                updates.add(object);
            }
        }
        LinkedHashSet<AbstractModel> transientDelete = new LinkedHashSet<AbstractModel>();
        for (AbstractModel object : deletes) {
            updates.remove(object);
            if (!inserts.remove(object)) continue;
            transientDelete.add(object);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashSet todoDelete = new LinkedHashSet();
        for (AbstractModel object : inserts) {
            linkedHashSet.add(object);
        }
        for (AbstractModel object : updates) {
            linkedHashSet.add(object);
        }
        for (AbstractModel object : deletes) {
            if (transientDelete.contains(object)) continue;
            todoDelete.add(object);
        }
        this.commonCaller.saveEventChain(linkedHashSet, todoDelete);
    }

    public static UndoManager getContextUndoManager() {
        return currentUndoManager.get();
    }

    public ModelCache getModelCache() {
        return this.commonCaller.getModelCache();
    }

    public void storeLastTransaction() throws ValidateException {
        List<UndoableEditEvent> eventlist = this.getCurrentUndoEvents();
        if (!eventlist.isEmpty()) {
            this.storeTransactions(eventlist.subList(eventlist.size() - 1, eventlist.size()));
            this.undo();
        }
    }

    public void close() {
        ChangeSet.currentChangeTransaction.removeContextObject(this);
        currentUndoManager.removeContextObject(this);
    }

    @Override
    protected String getRevertActionName() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.revertAll", new Serializable[0]);
    }

    @Override
    protected String getUndoActionName(boolean canUndo) {
        String name;
        StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.undo", new Serializable[0]));
        if (canUndo && this.showUndoRedoNames && !StringUtil.isBlank(name = this.getUndoPresentationName())) {
            sb.append(" - ").append(name);
        }
        return sb.toString();
    }

    @Override
    protected String getRedoActionName(boolean canRedo) {
        String name;
        StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.redo", new Serializable[0]));
        if (canRedo && this.showUndoRedoNames && !StringUtil.isBlank(name = this.getRedoPresentationName())) {
            sb.append(" - ").append(name);
        }
        return sb.toString();
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public void removeFromChangeObjects(Model ... models) {
        for (UndoableEditEvent event : this.getCurrentUndoEvents()) {
            List<ChangeSet> changeSets = ((MovingUndoEditable)event.getEdit()).getChanges();
            this.removeFromChangeSetList(changeSets, models);
        }
        List<ChangeSet> transaction = ChangeSet.currentChangeTransaction.get();
        this.removeFromChangeSetList(transaction, models);
    }

    private void removeFromChangeSetList(List<ChangeSet> changeSets, Model ... models) {
        LinkedList<ChangeSet> toBeRemoved = new LinkedList<ChangeSet>();
        for (ChangeSet changeSet : changeSets) {
            Object o = changeSet.getObject();
            for (Model model : models) {
                if (!o.equals(model)) continue;
                toBeRemoved.add(changeSet);
            }
        }
        changeSets.removeAll(toBeRemoved);
        if (toBeRemoved != null && !toBeRemoved.isEmpty()) {
            MovingUndoEditable editable = new MovingUndoEditable(((Object)toBeRemoved).toString(), toBeRemoved, this.listeners, null);
            editable.undo();
        }
    }

    public synchronized boolean isTransactionOpen() {
        List<ChangeSet> list = ChangeSet.currentChangeTransaction.get();
        return list != null;
    }
}

