/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.LogisticTourDtoUtil;
import de.datomino.peppergis.dto.exporter.AreaTourExportDto;
import de.datomino.peppergis.helper.PointEntityId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AreaTourExportModelsHolder {
    private Set<ParcelModel> parcels = new HashSet<ParcelModel>();
    private Set<ParcelModel> parcelNullGeoms = new HashSet<ParcelModel>();
    private Set<SubscriptionModel> subscriptions = new HashSet<SubscriptionModel>();
    private Set<SubscriptionModel> subscriptionNullGeoms = new HashSet<SubscriptionModel>();
    private Set<LetterModel> letters = new HashSet<LetterModel>();
    private Set<LetterModel> letterNullGeoms = new HashSet<LetterModel>();
    private List<PoiModel> startPois = new ArrayList<PoiModel>();
    private List<PoiModel> endPois = new ArrayList<PoiModel>();
    private List<PoiModel> startPickPoints = new ArrayList<PoiModel>();
    private List<PoiModel> endPickPoints = new ArrayList<PoiModel>();
    private List<PoiModel> pois = new ArrayList<PoiModel>();
    private List<Model> orderedModels;

    public AreaTourExportModelsHolder(ModelEnviroment modelEnviroment, AreaTourExportDto exportDto) {
        ModelCache modelCache = modelEnviroment.getModelCache();
        HashSet<Long> parcelIds = new HashSet<Long>();
        HashSet<Long> subscriptionIds = new HashSet<Long>();
        HashSet<Long> letterIds = new HashSet<Long>();
        HashSet<Long> poiIds = new HashSet<Long>();
        for (LogisticStopDto<PointEntityId> stop : LogisticTourDtoUtil.getAllStops(exportDto.getLogisticTourDto())) {
            this.loadModelsFromCache((PointEntityId)stop.getId(), parcelIds, subscriptionIds, letterIds, poiIds, modelCache);
        }
        HashSet<Long> parcelNullIds = new HashSet<Long>();
        HashSet<Long> subscriptionNullIds = new HashSet<Long>();
        HashSet<Long> letterNullIds = new HashSet<Long>();
        for (PointEntityId id : exportDto.getObjectsWithNullGeom()) {
            this.loadModelsFromCache(id, parcelNullIds, subscriptionNullIds, letterNullIds, poiIds, modelCache);
        }
        AllCaller allCaller = modelEnviroment.getAllCaller();
        this.startPois.addAll(allCaller.getBaseCaller().fetchPoiByIds(exportDto.getStartPois()));
        this.endPois.addAll(allCaller.getBaseCaller().fetchPoiByIds(exportDto.getEndPois()));
        this.startPickPoints.addAll(allCaller.getBaseCaller().fetchPoiByIds(exportDto.getStartPickPoints()));
        this.endPickPoints.addAll(allCaller.getBaseCaller().fetchPoiByIds(exportDto.getEndPickPoints()));
        this.parcels.addAll(allCaller.getStreetNetCaller().fetchParcelsByIds(new ArrayList<Long>(parcelIds)));
        this.parcels.remove(null);
        this.parcelNullGeoms.addAll(allCaller.getStreetNetCaller().fetchParcelsByIds(new ArrayList<Long>(parcelNullIds)));
        this.parcelNullGeoms.remove(null);
        this.subscriptions.addAll(allCaller.getSubscriptionCaller().fetchSubscriptionsByIds(new ArrayList<Long>(subscriptionIds)));
        this.subscriptions.remove(null);
        this.subscriptionNullGeoms.addAll(allCaller.getSubscriptionCaller().fetchSubscriptionsByIds(new ArrayList<Long>(subscriptionNullIds)));
        this.subscriptionNullGeoms.remove(null);
        this.letters.addAll(allCaller.getLetterCaller().fetchLettersByIds(new ArrayList<Long>(letterIds)));
        this.letters.remove(null);
        this.letterNullGeoms.addAll(allCaller.getLetterCaller().fetchLettersByIds(new ArrayList<Long>(letterNullIds)));
        this.letterNullGeoms.remove(null);
        this.pois.addAll(allCaller.getBaseCaller().fetchPoiByIds(poiIds));
        this.orderedModels = new ArrayList<Model>(this.parcels.size() + this.subscriptions.size() + this.letters.size());
        this.orderedModels.addAll(this.parcels);
        this.orderedModels.addAll(this.subscriptions);
        this.orderedModels.addAll(this.letters);
        this.orderedModels.addAll(this.pois);
        this.orderedModels = LogisticTourDtoUtil.updateSortOrderOfModel(this.orderedModels, exportDto.getLogisticTourDto());
    }

    private void loadModelsFromCache(PointEntityId id, Collection<Long> parcelIds, Collection<Long> subscriptionIds, Collection<Long> letterIds, Collection<Long> poiIds, ModelCache modelCache) {
        switch (id.getPointEnityType()) {
            case LETTER: {
                LetterModel letter = modelCache.getModel(LetterModel.class, id.getId());
                if (letter == null) {
                    letterIds.add(id.getId());
                    break;
                }
                this.letters.add(letter);
                break;
            }
            case PARCEL: {
                ParcelModel parcel = modelCache.getModel(ParcelModel.class, id.getId());
                if (parcel == null) {
                    parcelIds.add(id.getId());
                    break;
                }
                this.parcels.add(parcel);
                break;
            }
            case POI: {
                PoiModel poi = modelCache.getModel(PoiModel.class, id.getId());
                if (poi == null) {
                    poiIds.add(id.getId());
                    break;
                }
                this.pois.add(poi);
                break;
            }
            case STOP: {
                break;
            }
            case SUBSCRIPTION: {
                SubscriptionModel subscription = modelCache.getModel(SubscriptionModel.class, id.getId());
                if (subscription == null) {
                    subscriptionIds.add(id.getId());
                    break;
                }
                this.subscriptions.add(subscription);
            }
        }
    }

    public Set<SubscriptionModel> getSubscriptions() {
        return this.subscriptions;
    }

    public List<PoiModel> getStartPois() {
        return this.startPois;
    }

    public List<PoiModel> getEndPois() {
        return this.endPois;
    }

    public List<PoiModel> getStartPickPoints() {
        return this.startPickPoints;
    }

    public List<PoiModel> getEndPickPoints() {
        return this.endPickPoints;
    }

    public List<Model> getOrderedModels() {
        return this.orderedModels;
    }

    public List<Model> getNullGeomModels() {
        ArrayList<Model> ms = new ArrayList<Model>(this.parcelNullGeoms.size() + this.subscriptionNullGeoms.size() + this.letterNullGeoms.size());
        ms.addAll(this.parcelNullGeoms);
        ms.addAll(this.subscriptionNullGeoms);
        ms.addAll(this.letterNullGeoms);
        return ms;
    }

    public void update(LogisticTourDto<PointEntityId> newTour) {
        this.orderedModels = LogisticTourDtoUtil.updateSortOrderOfModel(this.orderedModels, newTour);
    }
}

