/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.communication.CommonCallerImpl;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.dto.AbstractProxyDto;
import de.datomino.peppergis.dto.AbstractSpecificDto;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.Date;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.cache.ChangeSet;

public abstract class AbstractModel<S extends AbstractSpecificDto, T extends AbstractProxyDto>
implements Model {
    public static final String PROP_ID = "id";
    private EventListenerList listenerList = new EventListenerList();
    private boolean dirty = false;
    private Long idtemp;
    private Long id;
    private Long version;
    private Date creationDate;
    private Date lastModifiedDate;
    private boolean proxy;
    private boolean deleted;
    protected final CommonCaller commonCaller;
    private static volatile long idtempseq;

    private static synchronized long createTempUUID() {
        return --idtempseq;
    }

    protected AbstractModel(Long id, CommonCaller commonCaller) {
        this.id = id;
        this.commonCaller = commonCaller;
    }

    protected AbstractModel() {
        ModelCache modelCache = UndoManager.getContextUndoManager().getModelCache();
        if (modelCache != null) {
            modelCache.addModel(this);
        }
        this.commonCaller = modelCache.getCommonCaller();
    }

    @Override
    public final Long getId() {
        return this.id;
    }

    protected void replaceId(Long id) {
        this.id = id;
    }

    @Override
    public Long getTempUUID() {
        if (this.idtemp == null) {
            Long id = this.getId();
            this.idtemp = id == null ? Long.valueOf(AbstractModel.createTempUUID()) : id;
        }
        return this.idtemp;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        if (!ArrayUtils.contains(this.listenerList.getListenerList(), listener)) {
            this.listenerList.add(ValueChangeListener.class, listener);
        }
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listenerList.remove(ValueChangeListener.class, listener);
    }

    protected <U extends Enum<U>> void fireValueChanged(U property, Object newValue, Object oldValue) {
        this.fireModelValueChangeEvent(ValueChangeEvent.createUpdateModelValueChangeEvent(this, property, oldValue, newValue));
    }

    @Override
    public void fireModelValueChangeEvent(ValueChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ValueChangeListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getTempUUID()).toHashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.getClass() + "(" + this.getId() + "/" + this.getTempUUID() + " @" + super.hashCode() + ")";
    }

    @Override
    public boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    @Override
    public void delete() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange(true);
        this.deleted = true;
        this.fireModelValueChangeEvent(ValueChangeEvent.createDeletionModelValueChangeEvent(this));
    }

    @Override
    public void undelete() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange(true);
        this.deleted = false;
        this.fireModelValueChangeEvent(ValueChangeEvent.createUndeletionModelValueChangeEvent(this));
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public String toStringForProxy() {
        return "Proxy for " + this.getClass().getSimpleName() + " (" + this.getId() + ")";
    }

    public abstract S createDto();

    public abstract T createProxy();

    protected abstract void updateByDto(S var1);

    protected abstract void updateMasterRelationsByDto(S var1);

    @Override
    public void updateByDto(Dto dto) {
        Long version = this.getVersion();
        Long dtoVersion = dto.getVersion();
        boolean proxy = dto instanceof AbstractProxyDto;
        boolean selfProxy = this.isProxy();
        if (proxy) {
            if (dtoVersion != null || this.version == null) {
                if (selfProxy) {
                    this.setVersion(dtoVersion);
                } else if (version == null || !version.equals(dtoVersion)) {
                    this.setVersion(dtoVersion);
                    this.setProxy(true);
                    if (this.listenerList.getListenerCount() > 0) {
                        // empty if block
                    }
                }
            }
        } else if (selfProxy || version == null || !version.equals(dtoVersion)) {
            Date creationDate = ((AbstractSpecificDto)dto).getCreationDate();
            Date lastModifiedDate = ((AbstractSpecificDto)dto).getLastModifiedDate();
            this.setCreationDate(creationDate);
            this.setLastModifiedDate(lastModifiedDate);
            this.setProxy(false);
            this.setVersion(dtoVersion);
            this.updateByDto((S)((AbstractSpecificDto)dto));
            this.updateMasterRelationsByDto((AbstractSpecificDto)dto);
        }
    }

    protected abstract void checkStaleByDto(S var1) throws StaleStateException;

    public void checkStaleState(Dto dto) throws StaleStateException {
        Long version = this.getVersion();
        Long dtoVersion = dto.getVersion();
        if ((version == null || dtoVersion != null && !dtoVersion.equals(version)) && this.isDirty()) {
            throw new StaleStateException(this.getModelInterfaceName(), this.getId(), dtoVersion, version);
        }
        if (dto instanceof AbstractSpecificDto) {
            this.checkStaleByDto((AbstractSpecificDto)dto);
        }
    }

    private String getModelInterfaceName() {
        Class<?>[] interfaces;
        Class<?> clazz = this.getClass();
        for (Class<?> iClazz : interfaces = clazz.getInterfaces()) {
            Class<?>[] iInterfaces;
            String sName = iClazz.getSimpleName();
            if (!sName.endsWith("Model") || sName.equals("Model")) continue;
            for (Class<?> iiClazz : iInterfaces = iClazz.getInterfaces()) {
                if (!iiClazz.equals(Model.class)) continue;
                return iClazz.getName();
            }
        }
        return clazz.getName();
    }

    public ModelCache getModelCache() {
        return ((CommonCallerImpl)this.commonCaller).getModelCache();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

