/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public enum WeekdayName {
    D1("monday", "monday.short"),
    D2("tuesday", "tuesday.short"),
    D3("wednesday", "wednesday.short"),
    D4("thursday", "thursday.short"),
    D5("friday", "friday.short"),
    D6("saturday", "saturday.short"),
    D7("sunday", "sunday.short");

    private static final String catalog = "gui.date.";
    private String name;
    private String shortName;

    private WeekdayName(String name, String shortName) {
        this.name = name;
        this.shortName = shortName;
    }

    public String getName() {
        return ModelEnviroment.getMessageResolver().resolveMessage(catalog + this.name, new Serializable[0]);
    }

    public String getShortName() {
        return ModelEnviroment.getMessageResolver().resolveMessage(catalog + this.shortName, new Serializable[0]);
    }

    public static WeekdayName getWeekDayName(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int d = c.get(7);
        switch (d) {
            case 2: {
                return D1;
            }
            case 3: {
                return D2;
            }
            case 4: {
                return D3;
            }
            case 5: {
                return D4;
            }
            case 6: {
                return D5;
            }
            case 7: {
                return D6;
            }
            case 1: {
                return D7;
            }
        }
        return null;
    }
}

