/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.util;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrixWrapper;
import de.datomino.peppergis.type.StopStatus;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagerMapUtil
extends GeoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerMapUtil.class);

    public static boolean isSameCoordinate(Coordinate c1, Coordinate c2) {
        Coordinate newC1 = Wgs84Factory.INSTANCE.createCoordinate(c1);
        Coordinate newC2 = Wgs84Factory.INSTANCE.createCoordinate(c2);
        return newC1.getX() == newC2.getX() && newC1.getY() == newC2.getY();
    }

    public static <M> LinkedHashMap<M, Color> getToursWithColor(Collection<M> tours) {
        Color color = null;
        LinkedHashMap<M, Color> toursWithColor = new LinkedHashMap<M, Color>(tours.size(), 0.75f, true);
        for (M tour : tours) {
            color = GeoUtil.getNextColor(color);
            toursWithColor.put(tour, color);
        }
        return toursWithColor;
    }

    public static void addTours(LinkedHashMap<TourModel, Color> toursWithColor, Collection<TourModel> tours) {
        Color color = null;
        if (!toursWithColor.isEmpty()) {
            Iterator<TourModel> iterator = toursWithColor.keySet().iterator();
            TourModel lastTour = iterator.next();
            while (iterator.hasNext()) {
                lastTour = iterator.next();
            }
            color = GeoUtil.getNextColor(toursWithColor.get(lastTour));
        }
        for (TourModel tour : tours) {
            color = GeoUtil.getNextColor(color);
            toursWithColor.put(tour, color);
        }
    }

    public static List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>> getLineStringOfTour(TourModel tourModel, boolean withPoi, ModelEnviroment modelEnviroment) {
        ArrayList<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>> lineStringOfStops = new ArrayList<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>>();
        Iterator<TourPartModel> tourPartsIter = tourModel.iterateTourParts();
        LocationModel lastLoactionOfPart = null;
        while (tourPartsIter.hasNext()) {
            Iterator<StopModel> stopIter;
            TourPartModel tourPartModel = tourPartsIter.next();
            RouteVehicleType routeVehicleType = tourPartModel.getRouteVehicleType();
            if (routeVehicleType == null) {
                routeVehicleType = RouteVehicleType.MOTORCAR;
            }
            if (!(stopIter = TourModelUtil.getAllStopsInTourPart(tourPartModel, false).iterator()).hasNext()) continue;
            StopModel predStop = stopIter.next();
            LocationModel prev = predStop.getLocation();
            if (lastLoactionOfPart != null) {
                ManagerMapUtil.addLineStringBetweenStops(lineStringOfStops, lastLoactionOfPart, prev, routeVehicleType, AbstractLineRenderer.LineType.DASH, modelEnviroment);
            }
            lastLoactionOfPart = prev;
            while (stopIter.hasNext()) {
                LocationModel next;
                StopModel nextStop = stopIter.next();
                lastLoactionOfPart = next = nextStop.getLocation();
                if (!withPoi && predStop.getPoi() != null || nextStop.getStopStatus() != null && nextStop.getStopStatus() == StopStatus.BAD_TIME_WINDOW) {
                    predStop = nextStop;
                    prev = next;
                    continue;
                }
                ManagerMapUtil.addLineStringBetweenStops(lineStringOfStops, prev, next, routeVehicleType, AbstractLineRenderer.LineType.SOLID, modelEnviroment);
                predStop = nextStop;
                prev = next;
            }
        }
        return lineStringOfStops;
    }

    private static void addLineStringBetweenStops(List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>> lineStringOfStops, LocationModel prev, LocationModel next, RouteVehicleType routeVehicleType, AbstractLineRenderer.LineType lineType, ModelEnviroment modelEnviroment) {
        AbstractImmutableGeoObject lineStringOrPoint;
        if (prev == null || next == null) {
            lineStringOfStops = Collections.emptyList();
        }
        LocationWrapper wrapper1 = LocationWrapperFactory.INSTANCE.createLocationWrapper(prev);
        ImmutablePoint access1 = LocationModelUtil.getAccessGeom(prev, routeVehicleType, modelEnviroment);
        if (access1 == null) {
            access1 = wrapper1.getGeoLocation();
        }
        LocationWrapper wrapper2 = LocationWrapperFactory.INSTANCE.createLocationWrapper(next);
        ImmutablePoint access2 = LocationModelUtil.getAccessGeom(next, routeVehicleType, modelEnviroment);
        if (access2 == null) {
            access2 = wrapper2.getGeoLocation();
        }
        RouteType routeType = RouteType.FASTEST;
        if (routeVehicleType != null && routeVehicleType != RouteVehicleType.MOTORCAR) {
            routeType = RouteType.SHORTEST;
        }
        if ((lineStringOrPoint = ManagerMapUtil.getLinString(modelEnviroment, access1, access2, routeVehicleType, routeType)) != null) {
            lineStringOfStops.add(new Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>(lineStringOrPoint, lineType));
            if (!access1.equals(wrapper1.getGeoLocation())) {
                lineStringOrPoint = GeoUtils.getLineString(access1, wrapper1.getGeoLocation());
                lineStringOfStops.add(new Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>(lineStringOrPoint, lineType));
            }
            if (!access2.equals(wrapper2.getGeoLocation())) {
                lineStringOrPoint = GeoUtils.getLineString(access2, wrapper2.getGeoLocation());
                lineStringOfStops.add(new Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>(lineStringOrPoint, lineType));
            }
        }
    }

    public static AbstractImmutableGeoObject getLinString(ModelEnviroment modelEnviroment, ImmutablePoint point1, ImmutablePoint point2, RouteVehicleType routeVehicleType, RouteType routeType) {
        AbstractImmutableGeoObject lineStringOrPoint = null;
        GeoDistanceMatrixWrapper distanceMatrixModel = null;
        try {
            distanceMatrixModel = modelEnviroment == null ? null : modelEnviroment.getAllCaller().getTourCaller().getGeoDistance(point1, point2, routeVehicleType, routeType);
        }
        catch (LogisticException e) {
            LOGGER.warn(e.getMessage() + "(From " + point1 + " to " + point2 + ")");
        }
        if (distanceMatrixModel == null || distanceMatrixModel.getLineString() == null || distanceMatrixModel.getLineString().getGeoObject() == null) {
            lineStringOrPoint = GeoUtils.getLineString(point1, point2);
            if (lineStringOrPoint == null || !point2.equals(point1)) {
                LOGGER.warn("No street line from " + (point1 == null ? "NULL" : point1.getTransformed(Wgs84Factory.INSTANCE)) + " to " + (point2 == null ? "NULL" : point2.getTransformed(Wgs84Factory.INSTANCE)));
            }
        } else {
            lineStringOrPoint = (AbstractImmutableGeoObject)distanceMatrixModel.getLineString().getGeoObject();
        }
        return lineStringOrPoint;
    }
}

