/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.printer;

import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.common.font.FontResource;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.printer.ManagerPrintOptionSpecialOptions;
import de.datomino.peppergis.client.print.PrintOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ManagerPrintOptionPane
extends PrintOptionPane<ManagerPrintOptionSpecialOptions> {
    private static final long serialVersionUID = -5688997703662382595L;
    private JCheckBox streetGroup;
    private JCheckBox addressGroup;

    public ManagerPrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, FontResource fontResource, String propertyPrefix, boolean showFooterFontSize, boolean showStreetGroup, boolean showAddressGroup) {
        super(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, fontResource, propertyPrefix, showFooterFontSize, new ManagerPrintOptionSpecialOptions(showAddressGroup, showStreetGroup));
    }

    public ManagerPrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, FontResource fontResource, String propertyPrefix, boolean showStreetGroup, boolean showAddressGroup) {
        super(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, fontResource, propertyPrefix, new ManagerPrintOptionSpecialOptions(showAddressGroup, showStreetGroup));
    }

    public ManagerPrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, String propertyPrefix, boolean showFooterFontSize) {
        super(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, propertyPrefix, showFooterFontSize, new ManagerPrintOptionSpecialOptions(false, false));
    }

    public ManagerPrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, String propertyPrefix) {
        super(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, propertyPrefix, new ManagerPrintOptionSpecialOptions(false, false));
    }

    @Override
    protected Component createSpecialComponent(ManagerPrintOptionSpecialOptions t) {
        boolean showStreetGroup = t.isShowStreetGroup();
        boolean showAdressGroup = t.isShowAdressGroup();
        if (showStreetGroup || showAdressGroup) {
            this.streetGroup = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.streetGroup", new Serializable[0]));
            this.addressGroup = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.addressGroup", new Serializable[0]));
            JPanel panel = new JPanel(new BorderLayout());
            JPanel subPanel = new JPanel(new FlowLayout());
            if (showStreetGroup) {
                subPanel.add(this.streetGroup);
                this.streetGroup.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ManagerPrintOptionPane.this.streetGroup.isSelected()) {
                            ManagerPrintOptionPane.this.addressGroup.setSelected(false);
                        }
                    }
                });
            }
            if (showAdressGroup) {
                subPanel.add(this.addressGroup);
                this.addressGroup.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ManagerPrintOptionPane.this.addressGroup.isSelected()) {
                            ManagerPrintOptionPane.this.streetGroup.setSelected(false);
                        }
                    }
                });
            }
            panel.add((Component)subPanel, "West");
            return panel;
        }
        return super.createSpecialComponent(t);
    }

    public JCheckBox getStreetGroup() {
        return this.streetGroup;
    }

    public JCheckBox getAddressGroup() {
        return this.addressGroup;
    }

    public PrinterInformation.LineGroupType getLineGroupType() {
        PrinterInformation.LineGroupType type = PrinterInformation.LineGroupType.NORMAL;
        if (this.streetGroup != null && this.streetGroup.isSelected() && this.streetGroup.isVisible()) {
            type = PrinterInformation.LineGroupType.STREET;
        } else if (this.addressGroup != null && this.addressGroup.isSelected() && this.addressGroup.isVisible()) {
            type = PrinterInformation.LineGroupType.ADDRESS;
        }
        return type;
    }
}

