/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.legend;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.util.FormUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.Date;

public class LegendObject<M> {
    private M m;
    private Color color;
    private Integer streetMileageMetersFromTourStart;
    private Integer estimatedDurationSeconds;
    private Date estimatedTimeOfArrival;
    private Integer sortOrder;
    private String info;

    public LegendObject(M m, Integer sortOrder) {
        this(m, Color.BLACK, sortOrder);
    }

    public LegendObject(M m, Color color, Integer sortOrder) {
        this.m = m;
        this.color = color;
        this.sortOrder = sortOrder;
    }

    public M getM() {
        return this.m;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getRoutingInfomation() {
        String routingInfo = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(this.getEstimatedTimeOfArrival());
        routingInfo = routingInfo + ", " + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.durationOnLocation", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(this.getEstimatedDurationSeconds());
        routingInfo = routingInfo + ", " + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.streetMileage", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(this.getStreetMileageMetersFromTourStart(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
        return " (" + routingInfo + ")";
    }

    public Integer getStreetMileageMetersFromTourStart() {
        return this.streetMileageMetersFromTourStart;
    }

    public Integer getEstimatedDurationSeconds() {
        return this.estimatedDurationSeconds;
    }

    public Date getEstimatedTimeOfArrival() {
        return this.estimatedTimeOfArrival;
    }

    public void setStreetMileageMetersFromTourStart(Integer streetMileageMetersFromTourStart) {
        this.streetMileageMetersFromTourStart = streetMileageMetersFromTourStart;
    }

    public void setEstimatedDurationSeconds(Integer estimatedDurationSeconds) {
        this.estimatedDurationSeconds = estimatedDurationSeconds;
    }

    public void setEstimatedTimeOfArrival(Date estimatedTimeOfArrival) {
        this.estimatedTimeOfArrival = estimatedTimeOfArrival;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

