/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.handler;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.util.ManagerMapUtil;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;

public class ShowParcelAction
extends AbstractAction {
    private static final long serialVersionUID = -1759082207622549910L;
    private AbstractManagerMapGui<?> mapGui;

    public ShowParcelAction(AbstractManagerMapGui<?> mapGui) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.parcel", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(122, 0));
        this.mapGui = mapGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        boolean selected = button.getModel().isSelected();
        if (selected) {
            this.showParcelsOnMap(button);
        } else {
            this.removeParcelsOnMap();
        }
        this.mapGui.getNavigatorPanel().repaint();
    }

    private void removeParcelsOnMap() {
        List<NavigatorRenderer> renderers = this.mapGui.getNavigatorPanel().getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (!(renderer instanceof ParcelLayerRenderer)) continue;
            ((ParcelLayerRenderer)renderer).setActive(false);
            break;
        }
    }

    private void showParcelsOnMap(AbstractButton button) {
        NavigatorPanel navigatorPanel;
        Component pane = this.mapGui.getPane();
        if (pane != null && pane instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)pane;
            if (!tabbedPane.getSelectedComponent().equals(this.mapGui)) {
                JOptionPane.showMessageDialog(tabbedPane.getSelectedComponent(), ModelEnviroment.getMessageResolver().resolveMessage("gui.map.message.mapInactive", new Serializable[0]));
                button.setSelected(false);
                return;
            }
            tabbedPane.setSelectedComponent(this.mapGui);
        }
        if ((navigatorPanel = this.mapGui.getNavigatorPanel()).getUpp() > AbstractManagerMapGui.MAXUPPFORPARCEL) {
            JOptionPane.showMessageDialog(this.mapGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.map.message.mapTooBig", new Serializable[0]));
            button.setSelected(false);
            return;
        }
        Tupel<ImmutablePoint, ImmutablePoint> boundary = ManagerMapUtil.getBoundaryOfNavigatorPanel(navigatorPanel);
        TourCaller tourCaller = this.mapGui.getModelEnviroment().getAllCaller().getTourCaller();
        List<ParcelModel> parcels = tourCaller.fetchParcels(boundary.getElement1(), boundary.getElement2(), true);
        List<NavigatorRenderer> renderers = navigatorPanel.getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (!(renderer instanceof ParcelLayerRenderer)) continue;
            ((ParcelLayerRenderer)renderer).setActive(true);
            ((ParcelLayerRenderer)renderer).setParcels(parcels);
            break;
        }
    }
}

