/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.handler;

import de.datomino.peppergis.client.manager.CalendarGui;
import java.awt.event.ActionEvent;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class CalendarActions {
    private Action monthDownAction;
    private Action monthUpAction;
    private Action dayChangeAction;
    private Action todayAction;
    private int year;
    private int month;
    private int day;
    private CalendarGui calendarGui;

    public CalendarActions(CalendarGui calendarGui) {
        this.calendarGui = calendarGui;
        this.initializeActions();
        this.initializeCalender();
    }

    private void initializeActions() {
        try {
            this.monthDownAction = new AbstractAction("", new ImageIcon(ImageIO.read(CalendarActions.class.getResourceAsStream("/images/icons/westarrow.png")))){
                private static final long serialVersionUID = -7833358131102427569L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarActions.this.monthDown();
                    CalendarActions.this.displayCalendar();
                }
            };
            this.monthUpAction = new AbstractAction("", new ImageIcon(ImageIO.read(CalendarActions.class.getResourceAsStream("/images/icons/eastarrow.png")))){
                private static final long serialVersionUID = 8122376029913998310L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarActions.this.monthUp();
                    CalendarActions.this.displayCalendar();
                }
            };
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dayChangeAction = new AbstractAction(){
            private static final long serialVersionUID = -8054723893685556620L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarActions.this.dayChange(Integer.parseInt(e.getActionCommand()));
                CalendarActions.this.calendarGui.getCalendar().set(CalendarActions.this.year, CalendarActions.this.month, CalendarActions.this.day);
                CalendarActions.this.calendarGui.update();
            }
        };
        this.todayAction = new AbstractAction("Heute"){
            private static final long serialVersionUID = -4853887297405160862L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarActions.this.initializeCalender();
                CalendarActions.this.displayCalendar();
                CalendarActions.this.calendarGui.getCalendar().set(CalendarActions.this.year, CalendarActions.this.month, CalendarActions.this.day);
                CalendarActions.this.calendarGui.update();
            }
        };
    }

    private void initializeCalender() {
        this.calendarGui.setCalendar(new GregorianCalendar(Locale.GERMAN));
        this.year = this.calendarGui.getCalendar().get(1);
        this.month = this.calendarGui.getCalendar().get(2);
        this.day = this.calendarGui.getCalendar().get(5);
    }

    public void displayCalendar() {
        this.calendarGui.getCalendar().set(this.year, this.month, this.day);
        this.calendarGui.displayCalendar(this.calendarGui.getCalendar());
    }

    public void monthUp() {
        ++this.month;
        this.day = 1;
        if (this.month == 12) {
            this.month = 0;
            ++this.year;
        }
    }

    public void monthDown() {
        --this.month;
        this.day = 1;
        if (this.month < 0) {
            this.month = 11;
            --this.year;
        }
    }

    public void dayChange(int day) {
        this.day = day;
    }

    public void setYear(int year) {
        if (this.year == year) {
            return;
        }
        this.year = year;
        this.displayCalendar();
    }

    public void setMonth(int month) {
        if (this.month == month) {
            return;
        }
        this.month = month;
        this.displayCalendar();
    }

    public Action getMonthDownAction() {
        return this.monthDownAction;
    }

    public Action getMonthUpAction() {
        return this.monthUpAction;
    }

    public Action getDayChangeAction() {
        return this.dayChangeAction;
    }

    public Action getTodayAction() {
        return this.todayAction;
    }
}

