/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.filter;

import de.datomino.peppergis.client.gui.area.AreaObjectCompletableTextField;
import de.datomino.peppergis.client.gui.area.AreaTourTypePane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelInclusionExclusionPane;
import de.datomino.peppergis.client.gui.subscription.ObjectCalculationOptionsPane;
import de.datomino.peppergis.client.manager.filter.AbstractObjectFilterSettingActions;
import de.datomino.peppergis.client.manager.filter.ObjectFilterEntity;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObjectFilterSettingDialog
extends JDialog {
    private static final long serialVersionUID = 5442743946084374795L;
    private ObjectFilterEntity objectFilterEntity;
    private AbstractObjectFilterSettingActions objectSettingActions;
    private JTextField nameField;
    private ObjectCalculationOptionsPane optionsPane;
    private JTextField areaLayerTextField;
    private AreaObjectCompletableTextField areaObjectTextField;
    private AreaTourTypePane areaTourTypePane;
    private ParcelInclusionExclusionPane parcelInclusionExclusionPane;
    private boolean preferExclusions = true;
    private JRadioButton inclusionButton;
    private JRadioButton exclusionButton;
    private ModelEnviroment modelEnviroment;

    public ObjectFilterSettingDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public ObjectFilterSettingDialog(ObjectFilterEntity objectFilterEntity, AbstractObjectFilterSettingActions actions2, ModelEnviroment modelEnviroment, Component parent, Collection<ParcelAttributeValueDescriptorModel> blockDescriptors) {
        this((JFrame)null, ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]) + "-" + ModelEnviroment.getMessageResolver().resolveMessage("gui.common.setting", new Serializable[0]), true);
        this.modelEnviroment = modelEnviroment;
        this.objectFilterEntity = objectFilterEntity;
        this.objectSettingActions = actions2;
        this.objectSettingActions.setObjectFilterSettingDialog(this);
        this.initialize(parent.getLocationOnScreen(), blockDescriptors);
    }

    private void initialize(Point locationOfParent, Collection<ParcelAttributeValueDescriptorModel> blockDescriptors) {
        try {
            this.setIconImage(ImageIO.read(ObjectFilterSettingDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.createInputPanel(blockDescriptors);
        this.createButtonPanel();
        this.setLocation(locationOfParent.x + 30, locationOfParent.y + 20);
        this.areaTourTypePane.setAreaTourType(new AreaTourType(AreaObjectType.PARCEL, AreaCalculationType.DEFAULT));
    }

    private void createInputPanel(Collection<ParcelAttributeValueDescriptorModel> blockDescriptors) {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel inputPanel = new JPanel(new SpringLayout());
        this.nameField = new JTextField("");
        JLabel areaLayerLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]));
        inputPanel.add(areaLayerLabel);
        this.areaLayerTextField = new JTextField();
        this.areaLayerTextField.setFont(UIManager.getDefaults().getFont("TextField.font"));
        inputPanel.add(this.areaLayerTextField);
        JLabel areaObjectLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0]));
        inputPanel.add(areaObjectLabel);
        this.areaObjectTextField = new AreaObjectCompletableTextField(this.modelEnviroment.getAllCaller().getAreaCaller(), this){
            private static final long serialVersionUID = -3032085901735151243L;

            @Override
            public void makeSelection() {
                super.makeSelection();
                ObjectFilterSettingDialog.this.objectFilterEntity.setSelectedAreaObjects(CollectionUtil.buildHashSet((AreaObjectModel)super.getSelectedObject()));
            }
        };
        this.areaObjectTextField.setFont(UIManager.getDefaults().getFont("TextField.font"));
        inputPanel.add(this.areaObjectTextField);
        inputPanel.add(new JLabel());
        this.areaTourTypePane = new AreaTourTypePane(AreaObjectType.values(), new AreaCalculationType[]{AreaCalculationType.DEFAULT});
        inputPanel.add(this.areaTourTypePane);
        this.areaTourTypePane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AreaTourType areaTourType = ObjectFilterSettingDialog.this.areaTourTypePane.getAreaTourType();
                boolean subscription = false;
                boolean letter = false;
                boolean parcel = false;
                switch (areaTourType.getAreaObjectType()) {
                    case LETTER: {
                        letter = true;
                        break;
                    }
                    case PARCEL: 
                    case PARCEL_WITHOUT_SUBSCRIPTION: {
                        parcel = true;
                        break;
                    }
                    case SUBSCRIPTION: {
                        subscription = true;
                        break;
                    }
                    case PARCEL_WITH_LETTER: 
                    case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                        parcel = true;
                        letter = true;
                        break;
                    }
                    case SUBSCRIPTION_WITH_LETTER: {
                        subscription = true;
                        letter = true;
                        break;
                    }
                    case PARCEL_SUBSCRIPTION: {
                        parcel = true;
                        parcel = true;
                        break;
                    }
                    case PARCEL_SUBSCRIPTION_LETTER: {
                        parcel = true;
                        parcel = true;
                        letter = true;
                    }
                }
                ObjectFilterSettingDialog.this.optionsPane.setOptionEnabled(subscription, letter);
                ObjectFilterSettingDialog.this.parcelInclusionExclusionPane.setEnabled(parcel);
                ObjectFilterSettingDialog.this.inclusionButton.setEnabled(parcel);
                ObjectFilterSettingDialog.this.exclusionButton.setEnabled(parcel);
            }
        });
        inputPanel.add(new JLabel());
        JPanel subPanel = new JPanel(new BorderLayout());
        JPanel subSubPanel = new JPanel(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.inclusionButton = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.preferInclusion", new Serializable[0]));
        subSubPanel.add(this.inclusionButton);
        buttonGroup.add(this.inclusionButton);
        this.exclusionButton = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.preferExclusion", new Serializable[0]));
        subSubPanel.add(this.exclusionButton);
        buttonGroup.add(this.exclusionButton);
        this.exclusionButton.setSelected(true);
        ActionListener inclusionExclusionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = ObjectFilterSettingDialog.this.exclusionButton.isSelected();
                ObjectFilterSettingDialog.this.preferExclusions = selected;
                ObjectFilterSettingDialog.this.objectFilterEntity.setPreferExclusion(selected);
            }
        };
        this.inclusionButton.addActionListener(inclusionExclusionActionListener);
        this.exclusionButton.addActionListener(inclusionExclusionActionListener);
        subPanel.add((Component)subSubPanel, "West");
        inputPanel.add(subPanel);
        inputPanel.add(new JLabel());
        this.parcelInclusionExclusionPane = new ParcelInclusionExclusionPane(blockDescriptors);
        inputPanel.add(this.parcelInclusionExclusionPane);
        inputPanel.add(new JLabel());
        this.optionsPane = new ObjectCalculationOptionsPane(true, true);
        inputPanel.add(this.optionsPane);
        SpringUtilities.makeCompactGrid(inputPanel, 6, 2, 5, 5, 5, 5);
        this.getContentPane().add((Component)inputPanel, "North");
        if (this.objectFilterEntity != null && this.objectFilterEntity.getKey() != null) {
            AreaObjectModel areaObject = this.objectFilterEntity.getSelectedAreaObjects().iterator().next();
            this.areaLayerTextField.setText(areaObject.getAreaLayer().getDisplayname());
            this.areaObjectTextField.setAreaLayer(areaObject.getAreaLayer());
            this.areaObjectTextField.setSelectedObject(areaObject);
            this.optionsPane.setDate(this.objectFilterEntity.getDate());
            this.optionsPane.setSubscriptionStatus(this.objectFilterEntity.getSubscriptionStatuses());
            this.optionsPane.setSubscriptionType(this.objectFilterEntity.getSubscriptionDeliveryTypes());
            this.optionsPane.setLetterType(this.objectFilterEntity.getLetterDeliveryTypes());
        } else {
            String name = ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]) + "-";
            this.objectFilterEntity = new ObjectFilterEntity(name, LegendType.SUBSCRIPTION, new AreaTourType(AreaObjectType.SUBSCRIPTION, AreaCalculationType.DEFAULT));
            this.objectFilterEntity.setBlockDescriptors(this.parcelInclusionExclusionPane.getBlockDescriptors());
            this.objectFilterEntity.setPreferExclusion(this.preferExclusions);
            this.areaLayerTextField.setText("");
            this.areaObjectTextField.setSelectedObject(null);
        }
        this.nameField.setText(this.objectFilterEntity.getKey());
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton applyFilterButton = new JButton(this.objectSettingActions.getApplyFilterActions());
        buttonPanel.add(applyFilterButton);
        JButton deleteFilterButton = new JButton(this.objectSettingActions.getDeleteFilterAction());
        buttonPanel.add(deleteFilterButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public static void createAndShowDialog(ObjectFilterEntity objectFilterEntity, AbstractObjectFilterSettingActions actions2, ModelEnviroment modelEnviroment, Collection<ParcelAttributeValueDescriptorModel> blockDescriptors, Component parent, AreaLayerModel currentLayer) {
        ObjectFilterSettingDialog filterSettingDialog = new ObjectFilterSettingDialog(objectFilterEntity, actions2, modelEnviroment, parent, blockDescriptors);
        filterSettingDialog.areaLayerTextField.setText(currentLayer == null ? "" : currentLayer.getDisplayname());
        filterSettingDialog.areaLayerTextField.setEnabled(false);
        filterSettingDialog.areaObjectTextField.setAreaLayer(currentLayer);
        filterSettingDialog.pack();
        filterSettingDialog.setVisible(true);
    }

    public AbstractObjectFilterSettingActions getFilterSettingActions() {
        return this.objectSettingActions;
    }

    public JTextField getNameField() {
        return this.nameField;
    }

    public ObjectFilterEntity getObjectFilterEntity() {
        AreaTourType areaTourType = this.areaTourTypePane.getAreaTourType();
        LegendType legendType = null;
        switch (areaTourType.getAreaObjectType()) {
            case LETTER: {
                legendType = LegendType.LETTER;
                break;
            }
            case PARCEL: {
                legendType = LegendType.PARCEL;
                break;
            }
            case PARCEL_WITH_LETTER: {
                legendType = LegendType.MIXED;
                break;
            }
            case PARCEL_WITHOUT_SUBSCRIPTION: {
                legendType = LegendType.PARCEL;
                break;
            }
            case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                legendType = LegendType.MIXED;
                break;
            }
            case SUBSCRIPTION: {
                legendType = LegendType.SUBSCRIPTION;
                break;
            }
            case SUBSCRIPTION_WITH_LETTER: {
                legendType = LegendType.MIXED;
                break;
            }
            case PARCEL_SUBSCRIPTION: {
                legendType = LegendType.MIXED;
                break;
            }
            case PARCEL_SUBSCRIPTION_LETTER: {
                legendType = LegendType.MIXED;
                break;
            }
        }
        if (this.objectFilterEntity == null) {
            this.objectFilterEntity = new ObjectFilterEntity(null, legendType, areaTourType);
        } else {
            this.objectFilterEntity.setType(legendType);
            this.objectFilterEntity.setAreaTourType(areaTourType);
        }
        this.objectFilterEntity.setDate(this.optionsPane.getDate());
        this.objectFilterEntity.setSubscriptionDeliveryTypes(this.optionsPane.getSubscriptionTypes());
        this.objectFilterEntity.setSubscriptionStatuses(this.optionsPane.getSubscriptionStatuses());
        this.objectFilterEntity.setLetterDeliveryTypes(this.optionsPane.getLetterTypes());
        this.objectFilterEntity.setBlockDescriptors(this.parcelInclusionExclusionPane.getBlockDescriptors());
        return this.objectFilterEntity;
    }
}

