/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.filter;

import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.filter.LegendeRendererAttribute;
import de.datomino.peppergis.client.gui.filter.LegendeRendererPosition;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LogisticTourDtoUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllObjectFilterLayerRenderer
implements NavigatorRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllObjectFilterLayerRenderer.class);
    private static final Image TOUR_START_IMAGE;
    private static final Image TOUR_END_IMAGE;
    public static Map<AreaObjectTourLegendType, LegendeRendererAttribute> LEGENDE_RENDERER_MAP;
    public static Map<AreaObjectModel, Color> AREAOBJECT_COLOR_CACHE;
    public static int MIN_AREA_SORT_ORDER;
    private NavigatorPanel navigatorPanel;
    private List<PoiModel> startPois;
    private List<PoiModel> endPois;
    private List<PoiModel> startPickPoints;
    private List<PoiModel> endPickPoints;
    private List<ImmutablePoint> points;
    private List<ImmutablePoint> accessPoints;
    private List<ImmutableLineString> linestringsWithArrow;
    private List<ImmutableLineString> linestringsWithoutArrow;
    private boolean withIndex;
    private boolean active;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = Integer.MAX_VALUE;
    private AreaObjectTourLegendType legendType;
    private AreaTourType areaTourType;
    private AreaObjectModel area;
    private List<Model> orderedObjects;
    private List<Model> nullGeomModels;
    private Map<RendererNode, List<Model>> rendererNodeMap;

    public AllObjectFilterLayerRenderer(boolean active) {
        this.active = active;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        SolidLineRenderer solidLineRenderer;
        ManagerPointRenderer tourPointRenderer = new ManagerPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory(), null);
        double margin = 10.0 * Math.pow(upp, -0.2) * upp;
        if (this.linestringsWithArrow != null && !this.linestringsWithArrow.isEmpty()) {
            solidLineRenderer = new SolidLineRenderer(upp, true, this.navigatorPanel.getCoordinateFactory());
            for (ImmutableLineString lineString : this.linestringsWithArrow) {
                if (lineString == null) continue;
                solidLineRenderer.render(g2d, (ImmutableLineString)lineString.getTransformed(this.navigatorPanel.getCoordinateFactory()), this.getLineColor(), this.getLineScale());
            }
        }
        if (this.linestringsWithoutArrow != null && !this.linestringsWithoutArrow.isEmpty()) {
            solidLineRenderer = new SolidLineRenderer(upp, false, this.navigatorPanel.getCoordinateFactory());
            for (ImmutableLineString lineString : this.linestringsWithoutArrow) {
                if (lineString == null) continue;
                solidLineRenderer.render(g2d, (ImmutableLineString)lineString.getTransformed(this.navigatorPanel.getCoordinateFactory()), this.getLineColor(), this.getLineScale());
            }
        }
        if (this.accessPoints != null && !this.accessPoints.isEmpty()) {
            for (ImmutablePoint point : this.accessPoints) {
                RendererNode node = new RendererNode(null, point.getCoordinate(), this.getLineColor(), this.getLineColor(), 1.0);
                tourPointRenderer.drawPoint(node);
            }
        }
        this.drawObjects(tourPointRenderer, margin);
        tourPointRenderer.drawPoisWithImage(this.endPickPoints, margin, null, this.getLineColor(), "Z");
        tourPointRenderer.drawPoisWithImage(this.startPickPoints, margin, null, this.getLineColor(), "S");
        tourPointRenderer.drawPoisWithImage(this.endPois, margin, null, this.getLineColor(), "Z");
        tourPointRenderer.drawPoisWithImage(this.startPois, margin, null, this.getLineColor(), "S");
        if (this.points != null && !this.points.isEmpty()) {
            if (this.endPois == null || this.endPois.size() == 0 || this.endPois.get(0).getImage() == null) {
                tourPointRenderer.drawImage(this.points.get(this.accessPoints.size() - 1), TOUR_END_IMAGE);
            }
            if (this.startPois == null || this.startPois.size() == 0 || this.startPois.get(0).getImage() == null) {
                tourPointRenderer.drawImage(this.points.get(0), TOUR_START_IMAGE);
            }
        }
        return Collections.emptyList();
    }

    private void drawObjects(ManagerPointRenderer tourPointRenderer, double margin) {
        if (this.areaTourType == null) {
            int index = 1;
            for (ImmutablePoint point : this.points) {
                String string = String.valueOf(index++);
                RendererNode node = new RendererNode(string, point.getCoordinate(), Color.BLACK, Color.WHITE, margin);
                tourPointRenderer.drawBuilding(node, false);
            }
            return;
        }
        this.initRendererNodeMap(margin);
        for (RendererNode node : this.rendererNodeMap.keySet()) {
            tourPointRenderer.drawBuilding(node, false);
            int size = this.rendererNodeMap.get(node).size();
            if (size <= 1) continue;
            Coordinate coordinate = node.getCoordinate();
            Rectangle2D.Double rectangle = DefaultPointRenderer.getRectangle(coordinate, margin, margin * 0.75);
            Coordinate sizeCoord = coordinate.getFactory().createCoordinate(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            RendererNode sizeNode = new RendererNode(String.valueOf(size), sizeCoord, this.getAreaColor(), Color.WHITE, margin);
            sizeNode.setFontStyle(1);
            tourPointRenderer.drawText(sizeNode);
        }
    }

    private void initRendererNodeMap(double margin) {
        LocationWrapper wrapper;
        ImmutablePoint point;
        this.rendererNodeMap = new HashMap<RendererNode, List<Model>>();
        int index = 1;
        for (Model m : this.getOrderedObjects()) {
            point = null;
            wrapper = null;
            Color background = Color.WHITE;
            if (m instanceof ParcelModel) {
                ParcelModel parcel = (ParcelModel)m;
                point = parcel.getGeom();
                wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(parcel);
            } else if (m instanceof SubscriptionModel) {
                SubscriptionModel subscription = (SubscriptionModel)m;
                point = SubscriptionModelUtil.getGeom(subscription);
                wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(subscription.getLocation());
            } else if (m instanceof LetterModel) {
                LetterModel letter = (LetterModel)m;
                point = LetterModelUtil.getGeom(letter);
                wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(letter.getLocation());
                background = PeppergisConstants.LETTER_COLOR;
            }
            if (GeoUtil.isNullPoint(point)) {
                LOGGER.error("a model with null point: " + m);
                continue;
            }
            Coordinate coordinate = point.getCoordinate();
            List<Model> found = null;
            for (RendererNode node : this.rendererNodeMap.keySet()) {
                if (!GeoUtil.areSamedPoints(coordinate, node.getCoordinate(), (Double)1.0)) continue;
                found = this.rendererNodeMap.get(node);
                break;
            }
            if (found == null) {
                String text = String.valueOf(index);
                if (!this.isWithIndex()) {
                    text = ClientFormUtil.getNumberString(wrapper.getHousenumber()) + FormUtil.getStringDisplay(wrapper.getHousenumberExtension());
                }
                RendererNode newNode = new RendererNode(text, coordinate, this.getAreaColor(), background, margin);
                found = new ArrayList<Model>();
                this.rendererNodeMap.put(newNode, found);
            }
            found.add(m);
            if (m instanceof PoiModel) continue;
            ++index;
        }
        index = 1;
        for (Model nullGeom : this.getAllNullGeoms()) {
            point = null;
            wrapper = null;
            if (nullGeom instanceof ParcelModel) {
                ParcelModel parcel = (ParcelModel)nullGeom;
                point = parcel.getGeom();
                wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(parcel);
            } else if (nullGeom instanceof SubscriptionModel) {
                SubscriptionModel subscription = (SubscriptionModel)nullGeom;
                point = SubscriptionModelUtil.getGeom(subscription);
                wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(subscription.getLocation());
            } else if (nullGeom instanceof LetterModel) {
                LetterModel letter = (LetterModel)nullGeom;
                point = LetterModelUtil.getGeom(letter);
                wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(letter.getLocation());
            }
            if (GeoUtil.isNullPoint(point)) {
                LOGGER.error("a model with null point: " + nullGeom);
                continue;
            }
            String text = String.valueOf(index);
            if (!this.isWithIndex()) {
                text = ClientFormUtil.getNumberString(wrapper.getHousenumber()) + FormUtil.getStringDisplay(wrapper.getHousenumberExtension());
            }
            RendererNode newNode = new RendererNode(text, point.getCoordinate(), this.getAreaColor(), PeppergisConstants.NULL_GEOM_COLOR, margin);
            this.rendererNodeMap.put(newNode, Collections.singletonList(nullGeom));
            ++index;
        }
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    public List<Model> getOrderedObjects() {
        return this.orderedObjects == null ? (this.orderedObjects = Collections.emptyList()) : this.orderedObjects;
    }

    public List<Model> getAllNullGeoms() {
        return this.nullGeomModels == null ? (this.nullGeomModels = Collections.emptyList()) : this.nullGeomModels;
    }

    public void setObjects(List<PoiModel> startPois, List<PoiModel> endPois, List<PoiModel> startPickPoints, List<PoiModel> endPickPoints, List<Model> orderedObjects, List<Model> nullGeomModels, AreaTourType areaTourType) {
        this.startPois = startPois;
        this.startPickPoints = startPickPoints;
        this.endPois = endPois;
        this.endPickPoints = endPickPoints;
        this.orderedObjects = orderedObjects;
        this.nullGeomModels = nullGeomModels;
        this.areaTourType = areaTourType;
        this.setSharp(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public AreaTourType getAreaTourType() {
        return this.areaTourType;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.navigatorPanel.repaint(10L);
            this.fireActiveChanged();
        }
    }

    public Set<Coordinate> getAreaRectangles(boolean withoutPois) {
        HashSet<ImmutablePoint> pointSet = new HashSet<ImmutablePoint>();
        for (Model m : this.getOrderedObjects()) {
            ImmutablePoint point = null;
            if (m instanceof ParcelModel) {
                point = ((ParcelModel)m).getGeom();
            } else if (m instanceof SubscriptionModel) {
                point = SubscriptionModelUtil.getGeom((SubscriptionModel)m);
            } else if (m instanceof LetterModel) {
                point = LetterModelUtil.getGeom((LetterModel)m);
            }
            if (GeoUtil.isNullPoint(point)) continue;
            pointSet.add((ImmutablePoint)point.getTransformed(this.navigatorPanel.getCoordinateFactory()));
        }
        if (!withoutPois && this.accessPoints != null) {
            ImmutablePoint transformedPoint;
            List<ImmutablePoint> ps;
            ImmutableLineString line;
            pointSet.addAll(this.accessPoints);
            if (this.linestringsWithArrow != null && !this.linestringsWithArrow.isEmpty()) {
                for (int i = 0; i < this.linestringsWithArrow.size(); ++i) {
                    line = this.linestringsWithArrow.get(i);
                    if (line == null || line.getCoordinates().isEmpty()) continue;
                    ps = line.getCoordinates();
                    for (ImmutablePoint point : ps) {
                        transformedPoint = (ImmutablePoint)point.getTransformed(this.navigatorPanel.getCoordinateFactory());
                        pointSet.add(transformedPoint);
                    }
                }
            }
            if (this.linestringsWithoutArrow != null && !this.linestringsWithoutArrow.isEmpty()) {
                for (int i = 0; i < this.linestringsWithoutArrow.size(); ++i) {
                    line = this.linestringsWithoutArrow.get(i);
                    if (line == null || line.getCoordinates().isEmpty()) continue;
                    ps = line.getCoordinates();
                    for (ImmutablePoint point : ps) {
                        transformedPoint = (ImmutablePoint)point.getTransformed(this.navigatorPanel.getCoordinateFactory());
                        pointSet.add(transformedPoint);
                    }
                }
            }
        }
        return GeoUtils.getAreaRectangle(pointSet);
    }

    public void setSharp(LogisticTourDto<?> logisticTourDto) {
        List<Tupel<ImmutablePoint, ImmutablePoint>> tupels = LogisticTourDtoUtil.getPoints(logisticTourDto);
        List<ImmutableLineString> linestringsWithoutArrow = LogisticTourDtoUtil.getAccessLinestrings(logisticTourDto, tupels);
        List<ImmutableLineString> linestringsWithArrow = LogisticTourDtoUtil.getLineStrings(logisticTourDto);
        this.setSharp(tupels, linestringsWithoutArrow, linestringsWithArrow);
    }

    public void setSharp(List<Tupel<ImmutablePoint, ImmutablePoint>> tupels, List<ImmutableLineString> linestringsWithoutArrow, List<ImmutableLineString> linestringsWithArrow) {
        this.points = new ArrayList<ImmutablePoint>(tupels.size());
        this.accessPoints = new ArrayList<ImmutablePoint>(tupels.size());
        for (Tupel<ImmutablePoint, ImmutablePoint> tupel : tupels) {
            this.points.add(tupel.getElement1());
            this.accessPoints.add(tupel.getElement2());
        }
        this.linestringsWithoutArrow = linestringsWithoutArrow;
        this.linestringsWithArrow = GeoUtil.adaptLineStringCollection(linestringsWithArrow, this.accessPoints);
        this.rendererNodeMap = null;
    }

    public List<Tupel<ImmutablePoint, ImmutablePoint>> getPoints() {
        if (this.accessPoints != null && !this.accessPoints.isEmpty()) {
            ArrayList<Tupel<ImmutablePoint, ImmutablePoint>> tupels = new ArrayList<Tupel<ImmutablePoint, ImmutablePoint>>(this.accessPoints.size());
            for (int i = 0; i < this.accessPoints.size(); ++i) {
                tupels.add(new Tupel<ImmutablePoint, ImmutablePoint>(this.points.get(i), this.accessPoints.get(i)));
            }
            return tupels;
        }
        return Collections.EMPTY_LIST;
    }

    public AllObjectFilterLayerRenderer createClone(boolean active) {
        AllObjectFilterLayerRenderer clone = new AllObjectFilterLayerRenderer(active);
        for (Field field : AllObjectFilterLayerRenderer.class.getDeclaredFields()) {
            try {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.set(clone, field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        return clone;
    }

    public void setWithIndex(boolean withIndex) {
        this.withIndex = withIndex;
    }

    public boolean isWithIndex() {
        return this.withIndex;
    }

    @Override
    public String getName() {
        return "ParcelFilterLayerRenderer";
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.legendType == null ? Integer.MAX_VALUE : this.sortOrder + LEGENDE_RENDERER_MAP.get((Object)this.legendType).getPostion().getSortOrder();
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setLegendType(AreaObjectTourLegendType legendType) {
        this.legendType = legendType;
    }

    public void setArea(AreaObjectModel area, Color color) {
        this.area = area;
        if (color != null) {
            AREAOBJECT_COLOR_CACHE.put(area, color);
        }
    }

    private Color getAreaColor() {
        Color color = AREAOBJECT_COLOR_CACHE.get(this.area);
        if (color == null) {
            while ((color = GeoUtil.getNextColor(null)).equals(Color.WHITE)) {
            }
            AREAOBJECT_COLOR_CACHE.put(this.area, color);
        }
        return color;
    }

    private Color getLineColor() {
        if (this.legendType != null && this.legendType != AreaObjectTourLegendType.HISTORY) {
            return LEGENDE_RENDERER_MAP.get((Object)this.legendType).getColor();
        }
        if (this.area != null) {
            return AREAOBJECT_COLOR_CACHE.get(this.area);
        }
        return Color.BLACK;
    }

    private float getLineScale() {
        return this.legendType == null ? 1.0f : (float)((double)LEGENDE_RENDERER_MAP.get((Object)this.legendType).getLineWidth().intValue() / AbstractLineRenderer.DEFAULTWIDTH);
    }

    static {
        AREAOBJECT_COLOR_CACHE = new HashMap<AreaObjectModel, Color>();
        MIN_AREA_SORT_ORDER = 100;
        try {
            TOUR_START_IMAGE = ImageIO.read(AllObjectFilterLayerRenderer.class.getResourceAsStream("/images/tour/tour_start.png"));
            TOUR_END_IMAGE = ImageIO.read(AllObjectFilterLayerRenderer.class.getResourceAsStream("/images/tour/tour_end.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LegendeRendererPosition positionHistory = LegendeRendererPosition.TOP;
        LegendeRendererPosition positionMotor = LegendeRendererPosition.MIDDLE_1;
        LegendeRendererPosition positionBike = LegendeRendererPosition.MIDDLE;
        LegendeRendererPosition positionFoot = LegendeRendererPosition.BOTTOM;
        try {
            LegendeRendererPosition newHistory = LegendeRendererPosition.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.position.history"));
            LegendeRendererPosition newMotor = LegendeRendererPosition.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.position.motor"));
            LegendeRendererPosition newBike = LegendeRendererPosition.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.position.bike"));
            LegendeRendererPosition newFoot = LegendeRendererPosition.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.position.foot"));
            if (newHistory != null && newMotor != newBike && newMotor != newFoot && newBike != newFoot) {
                positionHistory = newHistory;
                positionMotor = newMotor;
                positionBike = newBike;
                positionFoot = newFoot;
            } else {
                LOGGER.warn("Invalid vehicle renderer positions");
            }
        }
        catch (Exception newHistory) {
            // empty catch block
        }
        int lineWidthHistory = 3;
        int lineWidthMotor = 4;
        int lineWidthBike = 5;
        int lineWidthFoot = 6;
        try {
            lineWidthHistory = Integer.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.line.width.history"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lineWidthMotor = Integer.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.line.width.motor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lineWidthBike = Integer.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.line.width.bike"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lineWidthFoot = Integer.valueOf(ModelEnviroment.getProperties().getProperty("areatour.renderer.line.width.foot"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LEGENDE_RENDERER_MAP == null) {
            LEGENDE_RENDERER_MAP = new HashMap<AreaObjectTourLegendType, LegendeRendererAttribute>();
            LEGENDE_RENDERER_MAP.put(AreaObjectTourLegendType.HISTORY, new LegendeRendererAttribute(positionHistory, lineWidthHistory, null));
            LEGENDE_RENDERER_MAP.put(AreaObjectTourLegendType.MOTORCAR, new LegendeRendererAttribute(positionMotor, lineWidthMotor, PeppergisConstants.MOTOR_SEGMENT_COLOR));
            LEGENDE_RENDERER_MAP.put(AreaObjectTourLegendType.BIKE, new LegendeRendererAttribute(positionBike, lineWidthBike, PeppergisConstants.BIKE_SEGMENT_COLOR));
            LEGENDE_RENDERER_MAP.put(AreaObjectTourLegendType.FOOT, new LegendeRendererAttribute(positionFoot, lineWidthFoot, PeppergisConstants.FOOT_SEGMENT_COLOR));
        }
    }
}

