/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.branch;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.branch.AbstractBranchDialog;
import de.datomino.peppergis.client.manager.branch.AbstractBranchPane;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.BranchModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class BranchDialog
extends AbstractBranchDialog {
    private static final long serialVersionUID = -3185375132358513609L;
    private BranchModel branch;
    private AbstractBranchPane editPane;

    public BranchDialog(BranchModel branch, ModelEnviroment modelEnviroment, Component parent) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0]) + " - " + branch.getName(), modelEnviroment);
        this.branch = branch;
        this.buildLayout();
        this.pack();
        this.center();
        this.setVisible(true);
    }

    @Override
    protected Action getOkAction() {
        AbstractAction okAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 2282804022148846503L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BranchDialog.this.editPane.adaptValuesToModel()) {
                    return;
                }
                UndoManager undoManager = BranchDialog.this.modelEnviroment.getUndoManager();
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.configuration", new Serializable[0]));
                BranchDialog.this.dispose();
            }
        };
        return this.editable ? okAction : null;
    }

    @Override
    protected Component getMainComponent() {
        this.editPane = new AbstractBranchPane(this.branch, this.editable, this.modelEnviroment, false){
            private static final long serialVersionUID = 3271351778413442599L;

            @Override
            protected boolean checkName(String name, BranchModel current) {
                if (StringUtil.isBlank(name)) {
                    JOptionPane.showMessageDialog(BranchDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.branch.branchNameEmpty", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    return false;
                }
                HashSet<BranchModel> branchs = new HashSet<BranchModel>(BranchDialog.this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs());
                Collection<BranchModel> dirtyModels = BranchDialog.this.modelEnviroment.getModelCache().getCachedModels(BranchModel.class);
                branchs.addAll(dirtyModels);
                for (BranchModel branch : branchs) {
                    if (branch == current || !new EqualsBuilder().append(name, branch.getName()).isEquals()) continue;
                    JOptionPane.showMessageDialog(BranchDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.branch.branchNameMultiple", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    return false;
                }
                return true;
            }
        };
        return this.editPane;
    }
}

