/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.branch;

import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.branch.AbstractBranchDialog;
import de.datomino.peppergis.client.manager.branch.AbstractBranchPane;
import de.datomino.peppergis.client.manager.branch.BranchDeletionDialog;
import de.datomino.peppergis.client.manager.branch.BranchModelUtil;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.BranchModelImpl;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.UserRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class BranchConfigrationDialog
extends AbstractBranchDialog {
    private static final long serialVersionUID = -8216184542683790240L;
    private static final String DEFAULT_NEW_NAME = ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.newBranchName", new Serializable[0]);
    private JList branchList;
    private DefaultListModel branchListModel;
    private AddAction addAction = new AddAction();
    private DeleteAction deleteAction = new DeleteAction();
    private DuplicateAction duplicateAction = new DuplicateAction();
    private AbstractBranchPane editPane;

    public BranchConfigrationDialog(Component parent, ModelEnviroment modelEnviroment) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.configuration", new Serializable[0]), modelEnviroment);
        this.buildLayout();
        this.pack();
        this.center();
        this.fillData();
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 2282804022148846503L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchConfigrationDialog.this.editPane.adaptValuesToModel();
                if (!BranchConfigrationDialog.this.checkValidity()) {
                    return;
                }
                UndoManager undoManager = BranchConfigrationDialog.this.modelEnviroment.getUndoManager();
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.branch.configuration", new Serializable[0]));
                try {
                    undoManager.storeTransactions();
                    BranchConfigrationDialog.this.dispose();
                }
                catch (ValidateException ex) {
                    undoManager.handleValidateException(ex);
                }
            }
        };
    }

    private boolean checkValidity() {
        HashSet<BranchModel> branchs = new HashSet<BranchModel>();
        Enumeration elements = this.branchListModel.elements();
        while (elements.hasMoreElements()) {
            branchs.add((BranchModel)elements.nextElement());
        }
        return super.checkValidity(branchs, branchs);
    }

    @Override
    protected Component getMainComponent() {
        JSplitPane panel = new JSplitPane(1);
        panel.setLeftComponent(this.createBranchListPanel());
        panel.setRightComponent(this.createCommonEditPanel());
        return panel;
    }

    private Component createCommonEditPanel() {
        this.editPane = new AbstractBranchPane(null, true, this.modelEnviroment, true){
            private static final long serialVersionUID = 1365868056726044943L;

            @Override
            protected boolean checkName(String name, BranchModel current) {
                if (StringUtil.isBlank(name)) {
                    JOptionPane.showMessageDialog(BranchConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.branch.branchNameEmpty", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    return false;
                }
                ListModel model = BranchConfigrationDialog.this.branchList.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    BranchModel branch = (BranchModel)model.getElementAt(i);
                    if (branch == current || !new EqualsBuilder().append(name, branch.getName()).isEquals()) continue;
                    JOptionPane.showMessageDialog(BranchConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.branch.branchNameMultiple", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    return false;
                }
                return true;
            }
        };
        this.editPane.setEnabled(false);
        this.branchList.addListSelectionListener(new ListSelectionListener(){
            private boolean active = true;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (this.active) {
                    final AbstractBranchPane p = BranchConfigrationDialog.this.editPane;
                    if (p.adaptValuesToModel()) {
                        BranchModel selectedValue = (BranchModel)BranchConfigrationDialog.this.branchList.getSelectedValue();
                        if (selectedValue == null) {
                            p.setBranch(null);
                            p.setEnabled(false);
                            return;
                        }
                        if (p.getBranch() == null || !p.getBranch().equals(selectedValue)) {
                            p.setBranch(selectedValue);
                            BranchConfigrationDialog.this.pack();
                            p.setEnabled(true);
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setActive(false);
                                BranchConfigrationDialog.this.branchList.setSelectedValue(p.getBranch(), false);
                                this.setActive(true);
                            }
                        });
                    }
                }
            }

            public void setActive(boolean active) {
                this.active = active;
            }
        });
        return this.editPane;
    }

    private JPanel createBranchListPanel() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.branchListModel = new DefaultListModel();
        this.branchList = new JList(this.branchListModel);
        this.branchList.setCellRenderer(new AbstractListCellRenderer<BranchModel>(){

            @Override
            protected String getStringFromValue(BranchModel object) {
                return BranchModelUtil.getString(object);
            }
        });
        JScrollPane scroll = new JScrollPane(this.branchList);
        listPanel.add((Component)scroll, "Center");
        this.branchList.setSelectionMode(0);
        JPanel listButtonPanel = new JPanel(new FlowLayout());
        JButton addButton = new JButton(this.addAction);
        listButtonPanel.add(addButton);
        listButtonPanel.add(new JButton(this.duplicateAction));
        JButton deleteButton = new JButton(this.deleteAction);
        listButtonPanel.add(deleteButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)listButtonPanel, "East");
        listPanel.add((Component)buttonPanel, "South");
        listPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.parameter", new Serializable[0])));
        return listPanel;
    }

    private void fillData() {
        List<BranchModel> branchs = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs();
        this.branchListModel.clear();
        for (BranchModel branch : branchs) {
            this.branchListModel.addElement(branch);
        }
    }

    private String getNewName(String defaultName) {
        boolean found;
        String newName = defaultName;
        int suffixCount = 1;
        int size = this.branchListModel.getSize();
        block0: do {
            found = true;
            for (int i = 0; i < size; ++i) {
                BranchModel element = (BranchModel)this.branchListModel.getElementAt(i);
                if (!element.getName().equals(newName)) continue;
                newName = defaultName + "_" + suffixCount;
                ++suffixCount;
                found = false;
                continue block0;
            }
        } while (!found);
        return newName;
    }

    private class DuplicateAction
    extends AbstractAction {
        private static final long serialVersionUID = -3918991601184104211L;

        public DuplicateAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BranchModel branch = BranchConfigrationDialog.this.editPane.getBranch();
            if (branch != null) {
                int size = BranchConfigrationDialog.this.branchListModel.getSize();
                BranchModel newBranch = BranchModelUtil.clone(branch);
                newBranch.setName(BranchConfigrationDialog.this.getNewName(branch.getName()));
                BranchConfigrationDialog.this.branchListModel.addElement(newBranch);
                BranchConfigrationDialog.this.branchList.setSelectedIndex(size);
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1731420024283578996L;

        public DeleteAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BranchModel branch = BranchConfigrationDialog.this.editPane.getBranch();
            if (branch != null) {
                boolean mainBranch = StringUtil.getNotNull(branch.getName()).equals("Hauptstandort");
                boolean areaMainBranch = StringUtil.getNotNull(branch.getName()).equals("Zusteller-Hauptstandort");
                if ((mainBranch &= branch.getBranchType() != null && branch.getBranchType() == BranchType.REGULAR_TOUR_DELIVERER) || (areaMainBranch &= branch.getBranchType() != null && branch.getBranchType() == BranchType.AREA_TOUR_DELIVERER)) {
                    JOptionPane.showMessageDialog(BranchConfigrationDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("errors.deliverer.delMainBranch", new Serializable[0]));
                } else {
                    BranchDeletionDialog.createAndShow(branch, BranchConfigrationDialog.this.modelEnviroment, BranchConfigrationDialog.this, false);
                    if (branch.isDeleted()) {
                        BranchConfigrationDialog.this.branchListModel.removeElement(branch);
                        BranchConfigrationDialog.this.editPane.setBranch(null);
                    }
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 5190280323463698480L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int size = BranchConfigrationDialog.this.branchListModel.getSize();
            BranchModelImpl newBranch = new BranchModelImpl();
            newBranch.setName(BranchConfigrationDialog.this.getNewName(DEFAULT_NEW_NAME));
            BranchConfigrationDialog.this.branchListModel.addElement(newBranch);
            BranchConfigrationDialog.this.branchList.setSelectedIndex(size);
        }
    }
}

