/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager.branch;

import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.search.PoiSearchDialog;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.StringUtil;

public abstract class AbstractBranchPane
extends JPanel {
    private static final long serialVersionUID = -2869950721898662429L;
    private ModelEnviroment modelEnviroment;
    private BranchModel branch;
    private JTextField branchName;
    private JTextArea infoArea;
    private EnumComboBox<BranchType> typeComboBox;
    private CountryComboBox country;
    private JTextField city;
    private JTextField postcode;
    private JTextField street;
    private JTextField housenumber;
    private JTextField extension;
    private JTextField x;
    private JTextField y;
    private boolean editable;
    private PoiModel poi;
    private boolean poiTypeEnabled;
    private SearchPoiAction searchPoiAction;

    public AbstractBranchPane(BranchModel branch, boolean editable, ModelEnviroment modelEnviroment, boolean poiTypeEnabled) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        this.initialize();
        this.setBranch(branch);
        this.poiTypeEnabled = poiTypeEnabled;
    }

    private void fillValues() {
        if (this.branch == null) {
            this.branchName.setEnabled(false);
            return;
        }
        String nameString = StringUtil.nullToEmpty(this.branch.getName());
        this.branchName.setText(nameString);
        this.infoArea.setText(StringUtil.nullToEmpty(this.branch.getInformation()));
        boolean typeComboBoxEnable = false;
        if (this.branch == null) {
            this.typeComboBox.setSelectedValue(null);
        } else {
            BranchType branchType = this.branch.getBranchType();
            if (branchType == BranchType.REGULAR_TOUR) {
                branchType = null;
            }
            typeComboBoxEnable = branchType == null;
            this.typeComboBox.setSelectedValue(branchType);
        }
        if (nameString.equals("Hauptstandort") || nameString.equals("Zusteller-Hauptstandort")) {
            this.branchName.setEnabled(false);
            typeComboBoxEnable = false;
        } else {
            this.branchName.setEnabled(true);
        }
        this.typeComboBox.setEnabled(typeComboBoxEnable);
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.poi == null ? null : this.poi.getLocation());
        if (wrapper != null) {
            this.country.setSelectedItem(wrapper.getCountry());
            this.city.setText(StringUtil.nullToEmpty(wrapper.getCity()));
            this.postcode.setText(StringUtil.nullToEmpty(wrapper.getPostcode()));
            this.street.setText(StringUtil.nullToEmpty(wrapper.getStreet()));
            this.housenumber.setText(StringUtil.nullToEmpty(wrapper.getHousenumber()));
            this.extension.setText(StringUtil.nullToEmpty(wrapper.getHousenumberExtension()));
            Coordinate geoLocation = wrapper.getGeoLocation() == null ? null : GeoUtil.roundCoordinate(wrapper.getGeoLocation().getCoordinate());
            this.x.setText(geoLocation == null ? "" : String.valueOf(geoLocation.getX()));
            this.y.setText(geoLocation == null ? "" : String.valueOf(geoLocation.getY()));
        } else {
            this.country.setSelectedItem(null);
            this.city.setText("");
            this.postcode.setText("");
            this.street.setText("");
            this.housenumber.setText("");
            this.extension.setText("");
            this.x.setText("");
            this.y.setText("");
        }
    }

    protected boolean adaptValuesToModel() {
        if (this.branch != null) {
            String name = this.branchName.getText();
            if (this.checkName(name, this.branch)) {
                this.branch.setName(name);
                this.branch.setInformation(this.infoArea.getText());
                this.branch.setBranchType(this.typeComboBox.getSelectedValue());
                this.branch.setPoi(this.poi);
            } else {
                return false;
            }
        }
        return true;
    }

    protected abstract boolean checkName(String var1, BranchModel var2);

    private void initialize() {
        JPanel top = new JPanel(new SpringLayout());
        top.add(this.createLabel("messages.default.name"));
        this.branchName = new JTextField("");
        this.branchName.setPreferredSize(new Dimension(390, 25));
        this.branchName.setEditable(this.editable);
        top.add(this.branchName);
        top.add(this.createLabel("messages.default.information"));
        this.infoArea = new JTextArea(5, 20);
        this.infoArea.setEditable(this.editable);
        top.add(this.infoArea);
        top.add(this.createLabel("messages.default.type"));
        ArrayList<BranchType> branchTypes = new ArrayList<BranchType>(BranchType.values().length);
        for (BranchType branchType : BranchType.values()) {
            if (branchType == BranchType.REGULAR_TOUR) continue;
            branchTypes.add(branchType);
        }
        this.typeComboBox = new EnumComboBox<BranchType>(BranchType.class, true, (Collection<BranchType>)branchTypes);
        top.add(this.typeComboBox);
        SpringUtilities.makeCompactGrid(top, 3, 2, 0, 5, 0, 5);
        super.add((Component)top, "North");
        super.add((Component)this.createLocationPanel(), "Center");
        super.add((Component)this.createPoiSelectionPane(), "South");
        super.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private JPanel createPoiSelectionPane() {
        JPanel pane = new JPanel(new FlowLayout());
        this.searchPoiAction = new SearchPoiAction();
        this.searchPoiAction.setEnabled(false);
        pane.add(new JButton(this.searchPoiAction));
        return pane;
    }

    private JPanel createLocationPanel() {
        JPanel locationPanel = new JPanel(new SpringLayout());
        JLabel locationCountryLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]));
        locationPanel.add(locationCountryLabel);
        this.country = new CountryComboBox(true, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        this.country.setEnabled(false);
        locationPanel.add(this.country);
        JLabel locationPostLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]));
        locationPanel.add(locationPostLabel);
        this.postcode = new JTextField("");
        this.postcode.setEnabled(false);
        locationPanel.add(this.postcode);
        JLabel locationCityLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]));
        locationPanel.add(locationCityLabel);
        this.city = new JTextField("");
        this.city.setEnabled(false);
        locationPanel.add(this.city);
        JLabel locationStreetLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]));
        locationPanel.add(locationStreetLabel);
        this.street = new JTextField("");
        this.street.setEnabled(false);
        locationPanel.add(this.street);
        JLabel locationHausnumberLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]));
        locationPanel.add(locationHausnumberLabel);
        this.housenumber = new JTextField("");
        this.housenumber.setEnabled(false);
        locationPanel.add(this.housenumber);
        JLabel locationHausnumberExLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]));
        locationPanel.add(locationHausnumberExLabel);
        this.extension = new JTextField("");
        this.extension.setEnabled(false);
        locationPanel.add(this.extension);
        JLabel locationXLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.x", new Serializable[0]));
        locationPanel.add(locationXLabel);
        this.x = new JTextField("");
        this.x.setEnabled(false);
        locationPanel.add(this.x);
        JLabel locationYLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.y", new Serializable[0]));
        locationPanel.add(locationYLabel);
        this.y = new JTextField("");
        this.y.setEnabled(false);
        locationPanel.add(this.y);
        SpringUtilities.makeCompactGrid(locationPanel, 8, 2, 5, 5, 2, 2);
        return locationPanel;
    }

    private JLabel createLabel(String key) {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
        label.setVerticalAlignment(1);
        return label;
    }

    public BranchModel getBranch() {
        return this.branch;
    }

    protected void setBranch(BranchModel branch) {
        this.branch = branch;
        if (this.branch == null) {
            this.poi = null;
            this.searchPoiAction.setEnabled(false);
            this.typeComboBox.setEnabled(false);
        } else {
            this.poi = this.branch.getPoi();
            this.searchPoiAction.setEnabled(true);
            BranchType branchType = this.branch.getBranchType();
            if (branchType == null) {
                this.poi = null;
            } else {
                switch (branchType) {
                    case AREA_TOUR_DELIVERER: {
                        if (this.poi == null || this.poi.getPoiType() == PoiType.AREA_DELIVERER_LOCATION) break;
                        this.poi = null;
                        break;
                    }
                    case REGULAR_TOUR: {
                        this.poi = null;
                        break;
                    }
                    case REGULAR_TOUR_DELIVERER: {
                        if (this.poi == null || this.poi.getPoiType() == PoiType.DELIVERER_LOCATION) break;
                        this.poi = null;
                    }
                }
            }
        }
        this.poi = this.branch == null ? null : this.branch.getPoi();
        this.fillValues();
    }

    private class SearchPoiAction
    extends AbstractAction {
        private static final long serialVersionUID = 7663945868606002947L;

        public SearchPoiAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.search", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BranchType selectedValue = (BranchType)((Object)AbstractBranchPane.this.typeComboBox.getSelectedValue());
            PoiSearchType[] poiTypes = null;
            switch (selectedValue) {
                case AREA_TOUR_DELIVERER: {
                    poiTypes = new PoiSearchType[]{PoiSearchType.AREA_DELIVERER_LOCATION};
                    break;
                }
                case REGULAR_TOUR_DELIVERER: {
                    poiTypes = new PoiSearchType[]{PoiSearchType.DELIVERER_LOCATION};
                    break;
                }
            }
            if (poiTypes != null) {
                PoiSearchDialog poiSearchDialog = new PoiSearchDialog(SwingUtils.findWindowParent(AbstractBranchPane.this), ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.search", new Serializable[0]), AbstractBranchPane.this.modelEnviroment, poiTypes, AbstractBranchPane.this.poiTypeEnabled, false){
                    private static final long serialVersionUID = 6155796719677412745L;

                    @Override
                    protected void doAfterOk() {
                        super.doAfterOk();
                        AbstractBranchPane.this.poi = this.getSelectedPoiModel();
                        AbstractBranchPane.this.fillValues();
                    }
                };
                poiSearchDialog.setVisible(true);
            }
        }
    }
}

