/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.MobileGpsStatus;
import de.datomino.peppergis.type.RendererType;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang.math.NumberUtils;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tripel;

public class ManagerPointRenderer
extends DefaultPointRenderer {
    private static final Image TOUR_START_IMAGE;
    private static final Image TOUR_END_IMAGE;
    private ModelEnviroment modelEnviroment;
    private static double stopRectangleWidth;
    private static double stopRectangleHeight;
    private static int stopRectangleFontSize;

    public ManagerPointRenderer(Graphics2D g2d, double upp, CoordinateFactory coordinateFactory) {
        this(g2d, upp, coordinateFactory, null);
    }

    public ManagerPointRenderer(Graphics2D g2d, double upp, CoordinateFactory coordinateFactory, ModelEnviroment modelEnviroment) {
        super(g2d, upp, coordinateFactory);
        this.modelEnviroment = modelEnviroment;
    }

    public Map<StopModel, Rectangle2D.Double> drawStopsWithStack(Map<Tripel<String, Color, StopModel>, ImmutablePoint> overlappedPoints, double margin, Map<StopModel, Color> stopColorCache, boolean first, boolean last) {
        HashMap<StopModel, Rectangle2D.Double> drawedPointOnmMap = new HashMap<StopModel, Rectangle2D.Double>();
        ArrayList<Tripel<String, Color, StopModel>> keyList = new ArrayList<Tripel<String, Color, StopModel>>(overlappedPoints.keySet());
        if (!keyList.isEmpty()) {
            Coordinate coordinate = null;
            this.sortIndexs(keyList);
            double imageHeight = 0.0;
            if (first || last) {
                Tripel<String, Color, StopModel> indexOfOverlappedPoint = keyList.get(0);
                coordinate = overlappedPoints.get(indexOfOverlappedPoint).getCoordinate();
                Image image = null;
                if (first) {
                    image = TOUR_START_IMAGE;
                }
                if (last) {
                    image = TOUR_END_IMAGE;
                }
                imageHeight = image.getHeight(null);
                imageHeight = this.upp < 1.0 ? (imageHeight *= this.upp) : (imageHeight /= this.upp);
                this.drawImage(coordinate, image);
            }
            for (Tripel<String, Color, StopModel> indexOfOverlappedPoint : keyList) {
                if (coordinate == null) {
                    coordinate = overlappedPoints.get(indexOfOverlappedPoint).getCoordinate();
                } else {
                    coordinate = coordinate.getFactory().createCoordinate(coordinate.getX(), coordinate.getY() + stopRectangleHeight * margin + imageHeight);
                    imageHeight = 0.0;
                }
                this.drawRectangleWithIndex(coordinate, margin, indexOfOverlappedPoint, stopColorCache);
                drawedPointOnmMap.put(indexOfOverlappedPoint.getElement3(), ManagerPointRenderer.createStopRectangle(coordinate, margin));
            }
        }
        return drawedPointOnmMap;
    }

    public Map<StopModel, Rectangle2D.Double> drawStopsWithOutStack(Map<Tripel<String, Color, StopModel>, ImmutablePoint> overlappedPoints, double margin, Map<StopModel, Color> stopColorCache, boolean first, boolean last) {
        HashMap<StopModel, Rectangle2D.Double> drawedPointOnmMap = new HashMap<StopModel, Rectangle2D.Double>();
        ArrayList<Tripel<String, Color, StopModel>> keyList = new ArrayList<Tripel<String, Color, StopModel>>(overlappedPoints.keySet());
        this.sortIndexs(keyList);
        Coordinate coordinate = null;
        double imageHeight = 0.0;
        if (first || last) {
            Tripel<String, Color, StopModel> indexOfOverlappedPoint = keyList.get(0);
            coordinate = overlappedPoints.get(indexOfOverlappedPoint).getCoordinate();
            Image image = null;
            if (first) {
                image = TOUR_START_IMAGE;
            }
            if (last) {
                image = TOUR_END_IMAGE;
            }
            imageHeight = image.getHeight(null);
            imageHeight = this.upp < 1.0 ? (imageHeight *= this.upp) : (imageHeight /= this.upp);
            this.drawImage(coordinate, image);
        }
        if (!keyList.isEmpty()) {
            coordinate = coordinate == null ? overlappedPoints.get(keyList.get(0)).getCoordinate() : coordinate.getFactory().createCoordinate(coordinate.getX(), coordinate.getY() + stopRectangleHeight * margin + imageHeight);
            this.drawRectangleWithIndex(coordinate, margin, keyList.get(0), stopColorCache);
            drawedPointOnmMap.put(keyList.get(0).getElement3(), ManagerPointRenderer.createStopRectangle(coordinate, margin));
        }
        return drawedPointOnmMap;
    }

    private void sortIndexs(ArrayList<Tripel<String, Color, StopModel>> keyList) {
        Comparator<Tripel<String, Color, StopModel>> comparator = new Comparator<Tripel<String, Color, StopModel>>(){

            @Override
            public int compare(Tripel<String, Color, StopModel> o1, Tripel<String, Color, StopModel> o2) {
                if (NumberUtils.isDigits(o1.getElement1()) && NumberUtils.isDigits(o2.getElement1())) {
                    Integer index1 = Integer.valueOf(o1.getElement1());
                    Integer index2 = Integer.valueOf(o2.getElement1());
                    return index1.compareTo(index2);
                }
                return -1;
            }
        };
        Collections.sort(keyList, comparator);
    }

    private void drawRectangleWithIndex(Coordinate c, double margin, Tripel<String, Color, StopModel> indexWithColor, Map<StopModel, Color> stopColorCache) {
        StopModel stop = indexWithColor.getElement3();
        Color color = StopModelUtil.getColorOfStatus(stop, stopColorCache);
        if (this.isSelected(stop)) {
            color = PeppergisConstants.SELECTION_COLOR;
        }
        Color foregroud = indexWithColor.getElement2();
        RendererNode node = new RendererNode(indexWithColor.getElement1(), c, foregroud, color, margin);
        node.setFontSize(stopRectangleFontSize);
        Set<MobileGpsStatus> ss = StopModelUtil.getGpsStatuses(stop);
        if (ss.contains((Object)MobileGpsStatus.OK)) {
            node.setBackground(PeppergisConstants.SERVICE_NOT_DONE_COLOR);
            node.setType(RendererType.HATCH_LINE);
        }
        super.drawShape(ManagerPointRenderer.createStopRectangle(node.getCoordinate(), node.getMargin()), node, node.getMargin() / 5.0);
        node.setFontground(DefaultPointRenderer.STOPCOLOR.getElement1());
        super.drawNumber(node);
    }

    private void drawRectangleWithCrossing(Coordinate c, double margin, Tripel<String, Color, Color> crossingWithColor) {
        RendererNode node = new RendererNode(null, c, crossingWithColor.getElement2(), crossingWithColor.getElement3(), margin);
        Rectangle2D.Double rectangle = ManagerPointRenderer.createStopRectangle(node.getCoordinate(), node.getMargin());
        super.drawShape(rectangle, node, node.getMargin() / 5.0);
        Line2D.Double line = new Line2D.Double();
        line.x1 = rectangle.getMinX();
        line.y1 = rectangle.getMinY();
        line.x2 = rectangle.getMaxX();
        line.y2 = rectangle.getMaxY();
        this.g2d.draw(line);
        line.x1 = rectangle.getMinX();
        line.y1 = rectangle.getMaxY();
        line.x2 = rectangle.getMaxX();
        line.y2 = rectangle.getMinY();
        this.g2d.draw(line);
    }

    public void drawStopWithCircle(ImmutablePoint point, String index, double margin) {
        this.drawStopWithRhombus(point, index, margin, DefaultPointRenderer.STOPCOLOR.getElement1(), DefaultPointRenderer.STOPCOLOR.getElement2());
    }

    public void drawStopWithCircle(ImmutablePoint point, String index, double margin, Color foreground, Color background) {
        RendererNode node = new RendererNode(null, point.getCoordinate(), foreground, background, margin);
        super.drawCircle(node);
        node = new RendererNode(index, point.getCoordinate(), margin);
        super.drawNumber(node);
    }

    public void drawStopWithRhombus(ImmutablePoint point, String index, double margin) {
        this.drawStopWithRhombus(point, index, margin, DefaultPointRenderer.STOPCOLOR.getElement1(), DefaultPointRenderer.STOPCOLOR.getElement2());
    }

    public void drawStopWithRhombus(ImmutablePoint point, String index, double margin, Color foreground, Color background) {
        RendererNode node = new RendererNode(null, point.getCoordinate(), foreground, background, margin);
        DefaultPointRenderer.Rhombus rhombus = new DefaultPointRenderer.Rhombus(this, node.getWidth() * 1.5, node.getWidth());
        Shape shape = rhombus.createShape(point.getCoordinate());
        this.drawShape(shape, node, node.getMargin() / 5.0);
        node = new RendererNode(index, point.getCoordinate(), margin);
        super.drawNumber(node);
    }

    public Map<StopModel, Rectangle2D.Double> drawUnsortedStopsWithStack(List<StopModel> overlappedStops, double margin, CoordinateFactory coordinateFactory) {
        HashMap<StopModel, Rectangle2D.Double> drawedPointOnmMap = new HashMap<StopModel, Rectangle2D.Double>();
        Coordinate coordinate = null;
        for (StopModel stop : overlappedStops) {
            ImmutablePoint point = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation()).getGeoLocation();
            point = (ImmutablePoint)point.getTransformed(coordinateFactory);
            coordinate = coordinate == null ? point.getCoordinate() : coordinate.getFactory().createCoordinate(coordinate.getX(), coordinate.getY() + stopRectangleHeight * margin);
            Color bgColor = Color.WHITE;
            if (this.isSelected(stop)) {
                bgColor = PeppergisConstants.SELECTION_COLOR;
            }
            this.drawRectangleWithCrossing(coordinate, margin, new Tripel<Object, Color, Color>(null, Color.BLACK, bgColor));
            drawedPointOnmMap.put(stop, ManagerPointRenderer.createStopRectangle(coordinate, margin));
        }
        return drawedPointOnmMap;
    }

    public static Rectangle2D.Double createStopRectangle(Coordinate coordinate, double margin) {
        return DefaultPointRenderer.getRectangle(coordinate, margin * stopRectangleWidth, margin * stopRectangleHeight);
    }

    public static boolean isOverlapped(double margin, ImmutablePoint point1, ImmutablePoint point2) {
        Rectangle2D.Double rectangle2;
        if (point1 == null || point2 == null) {
            return false;
        }
        Rectangle2D.Double rectangle1 = ManagerPointRenderer.createStopRectangle(point1.getCoordinate(), margin);
        return rectangle1.contains(rectangle2 = ManagerPointRenderer.createStopRectangle(point2.getCoordinate(), margin)) || rectangle1.intersects(rectangle2);
    }

    public void drawImage(ImmutablePoint immutablePoint, Image image) {
        this.drawImage(immutablePoint.getCoordinate(), image);
    }

    public void drawImage(Coordinate coordinate, Image image) {
        RendererNode rendererNode = new RendererNode("", coordinate, 0.0);
        rendererNode.setImage(image);
        this.drawImage(rendererNode);
    }

    public void drawPoisWithImage(List<PoiModel> pois, double margin, Image defaultImage, Color color, String defaultText) {
        if (pois == null) {
            return;
        }
        for (PoiModel poi : pois) {
            ImmutablePoint point;
            Image image = defaultImage;
            ImageModel imageModel = poi.getImage();
            if (imageModel != null) {
                ImageIcon imageIcon = new ImageIcon(imageModel.getData());
                image = imageIcon.getImage();
            }
            if ((point = LocationModelUtil.getGeom(poi.getLocation())) == null) continue;
            point.getTransformed(this.getCoordinateFactory());
            if (image == null) {
                this.drawStopWithRhombus(point, defaultText, margin * 1.5, color, Color.WHITE);
                continue;
            }
            RendererNode node = new RendererNode("", point.getCoordinate(), margin);
            node.setImage(image);
            this.drawImage(node);
        }
    }

    static {
        try {
            TOUR_START_IMAGE = ImageIO.read(AllObjectFilterLayerRenderer.class.getResourceAsStream("/images/tour/tour_start.png"));
            TOUR_END_IMAGE = ImageIO.read(AllObjectFilterLayerRenderer.class.getResourceAsStream("/images/tour/tour_end.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        stopRectangleWidth = 2.0;
        stopRectangleHeight = 1.5;
        stopRectangleFontSize = 9;
        try {
            stopRectangleWidth = Double.parseDouble(ModelEnviroment.getProperties().getProperty("tour.renderer.stop.width")) / 35.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stopRectangleHeight = Double.parseDouble(ModelEnviroment.getProperties().getProperty("tour.renderer.stop.height")) / 35.0 / 0.75;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stopRectangleFontSize = Integer.parseInt(ModelEnviroment.getProperties().getProperty("tour.renderer.stop.fontsize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

