/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.client.manager.CalendarGui;
import de.datomino.peppergis.client.manager.legend.BranchNode;
import de.datomino.peppergis.client.manager.legend.PoiNode;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DelivererTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6876174758855941855L;
    private CalendarGui calendarGui;

    public DelivererTreeRenderer(CalendarGui calendarGui) {
        this.calendarGui = calendarGui;
    }

    @Override
    public JComponent getTreeCellRendererComponent(JTree tree, Object value, boolean selection, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selection, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof DelivererModel) {
            DelivererModel deliverer = (DelivererModel)userObject;
            this.setText(deliverer.getDelivererNumber() + " - " + deliverer.getName());
            this.setForeground(DelivererModelUtil.determineColor(deliverer, this.calendarGui.getCurrentDate()));
        } else if (userObject instanceof AreaDelivererModel) {
            AreaDelivererModel deliverer = (AreaDelivererModel)userObject;
            this.setText(deliverer.getDelivererNumber() + " - " + deliverer.getName());
            this.setForeground(DelivererModelUtil.determineColor(deliverer, this.calendarGui.getCurrentDate()));
        } else if (userObject instanceof PoiNode) {
            this.setText(((PoiNode)userObject).toString());
        } else if (userObject instanceof BranchNode) {
            this.setText(((BranchNode)userObject).toString());
        }
        return this;
    }
}

