/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.common.BranchComboBox;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiComboBox;
import de.datomino.peppergis.client.gui.tour.AbstractDelivererTimeIntervalDialog;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererFactorModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererRewardModel;
import de.datomino.peppergis.client.model.tour.DelivererRewardModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModel;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class DelivererDialog
extends CommonDialog {
    private static final long serialVersionUID = 553075797926733219L;
    private ModelEnviroment modelEnviroment;
    private DelivererModel delivererModel;
    private JTextField delivererNumber;
    private JTextField name;
    private BranchComboBox branch;
    private JList accounts;
    private PoiComboBox poi;
    private DeleteAccountAction deleteAccountAction;
    private AddAccountAction addAccountAction;
    private JList subStatuses;
    private DeleteSubStatusAction deleteSubStatusAction;
    private AddSubStatusAction addSubStatusAction;
    private JFormattedTextField factor;
    private boolean editable;
    private JCheckBox blockMobileData;
    private JFormattedTextField hourReward;
    private JFormattedTextField kmReward;
    private JSpinner mobilePauseTime;
    private JCheckBox mobilePauseTimeActive;
    private JTextField gpsDeactivationCode;

    public DelivererDialog(Window parent, ModelEnviroment modelEnviroment, boolean editable) {
        this(parent, modelEnviroment, DelivererDialog.createNewDeliverer(parent, modelEnviroment), editable);
    }

    private static DelivererModel createNewDeliverer(Window parent, ModelEnviroment modelEnviroment) {
        TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        BranchModel mainBranch = tourCaller.fetchBranchByNameAndType("Hauptstandort", BranchType.REGULAR_TOUR_DELIVERER);
        if (mainBranch == null) {
            String message = ModelEnviroment.getMessageResolver().resolveMessage("errors.deliverer.noMainBranch", new Serializable[0]);
            String title = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]);
            JOptionPane.showMessageDialog(parent, message, title, 2);
        }
        DelivererModelImpl deliverer = new DelivererModelImpl();
        deliverer.setBranch(mainBranch);
        return deliverer;
    }

    public DelivererDialog(Window parent, ModelEnviroment modelEnviroment, DelivererModel delivererModel, boolean editable) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.delivererWithNumber", new Serializable[]{StringUtil.nullToEmpty(delivererModel.getDelivererNumber()), StringUtil.nullToEmpty(delivererModel.getName())}), Dialog.ModalityType.APPLICATION_MODAL);
        this.delivererModel = delivererModel;
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        super.buildLayout();
        this.fillValues();
        modelEnviroment.getUndoManager().startTransaction();
        this.pack();
        SwingUtils.center((Window)this, parent);
        this.setVisible(true);
    }

    private void fillValues() {
        this.delivererNumber.setText(StringUtil.nullToEmpty(this.delivererModel.getDelivererNumber()));
        this.name.setText(StringUtil.nullToEmpty(this.delivererModel.getName()));
        this.factor.setValue(DelivererModelUtil.getCurrentFactor(this.delivererModel));
        this.branch.setSelectedItem(this.delivererModel.getBranch());
        this.poi.setSelectedItem(this.delivererModel.getPoi());
        DefaultListModel dlmAccounts = (DefaultListModel)this.accounts.getModel();
        for (AccountModel accountModel : this.delivererModel.iterableMobileAccounts()) {
            dlmAccounts.addElement(accountModel);
        }
        DefaultListModel dlmStatuses = (DefaultListModel)this.subStatuses.getModel();
        for (DelivererStatusTimeWindowModel status : this.delivererModel.iterableStatusTimeWindows()) {
            dlmStatuses.addElement(status);
        }
        this.blockMobileData.setSelected(PrimitiveUtil.nullToFalse(this.delivererModel.getBlockMobileData()));
        Integer n = this.delivererModel.getMobilePauseTime();
        if (n == null) {
            this.mobilePauseTimeActive.setSelected(false);
            this.mobilePauseTime.setEnabled(false);
        } else {
            this.mobilePauseTimeActive.setSelected(true);
            this.mobilePauseTime.setEnabled(true);
            this.mobilePauseTime.setValue(Math.max(1, n));
        }
        DelivererRewardModel reward = this.delivererModel.getReward();
        if (reward != null) {
            this.hourReward.setValue(reward.getHourReward());
            this.kmReward.setValue(reward.getKilometerReward());
        }
        this.gpsDeactivationCode.setText(StringUtil.nullToEmpty(this.delivererModel.getGpsDeactivationCode()));
    }

    /*
     * WARNING - void declaration
     */
    private boolean adaptValuesToModel() {
        boolean b = true;
        String delivererNumber = this.delivererNumber.getText();
        Collection<DelivererModel> dirtyModels = this.modelEnviroment.getModelCache().getCachedModels(DelivererModel.class);
        String errorMessageKey = "";
        for (DelivererModel delivererModel : dirtyModels) {
            String dirtyDelivererNumber;
            if (delivererModel.equals(this.delivererModel) || !PrimitiveUtil.equalsNullSafe(dirtyDelivererNumber = delivererModel.getDelivererNumber(), delivererNumber)) continue;
            errorMessageKey = "messages.deliverer.error.multipleDelivererNumber";
            b = false;
            break;
        }
        if (b) {
            HashSet<Long> dirtyIds = new HashSet<Long>();
            for (DelivererModel dirtyModel : dirtyModels) {
                dirtyIds.add(dirtyModel.getId());
            }
            dirtyIds.add(this.delivererModel.getId());
            b = this.modelEnviroment.getAllCaller().getValidateCaller().validateExistingDelivererNumber(delivererNumber, dirtyIds);
            errorMessageKey = "messages.deliverer.error.multipleDelivererNumber";
        }
        if (b) {
            void var6_13;
            this.delivererModel.setDelivererNumber(delivererNumber);
            this.delivererModel.setName(this.name.getText());
            this.delivererModel.setBranch((BranchModel)this.branch.getSelectedItem());
            this.delivererModel.setPoi((PoiModel)this.poi.getSelectedItem());
            this.delivererModel.setGpsDeactivationCode(this.gpsDeactivationCode.getText());
            Object factorValue = this.factor.getValue();
            if (factorValue != null) {
                Double d = DelivererModelUtil.getCurrentFactor(this.delivererModel);
                Double newFactor = Double.parseDouble(factorValue.toString());
                if (d == null || d != newFactor) {
                    DelivererFactorModelImpl factorModel = new DelivererFactorModelImpl();
                    factorModel.setFactor(newFactor);
                    factorModel.setLastModifiedDate(new Date());
                    DelivererEmploymentModel employment = this.delivererModel.getEmployment();
                    if (employment == null) {
                        employment = new DelivererEmploymentModelImpl();
                        employment.setDeliverer(this.delivererModel);
                    }
                    employment.addFactor(factorModel);
                }
            }
            this.delivererModel.setBlockMobileData(this.blockMobileData.isSelected());
            if (this.mobilePauseTimeActive.isSelected()) {
                this.delivererModel.setMobilePauseTime((Integer)this.mobilePauseTime.getValue());
            } else {
                this.delivererModel.setMobilePauseTime(null);
            }
            DelivererRewardModel delivererRewardModel = this.delivererModel.getReward();
            if (delivererRewardModel == null) {
                DelivererRewardModelImpl delivererRewardModelImpl = new DelivererRewardModelImpl();
                delivererRewardModelImpl.setDeliverer(this.delivererModel);
            }
            var6_13.setHourReward(this.hourReward.getValue() == null ? null : Double.valueOf(Double.parseDouble(this.hourReward.getValue().toString())));
            var6_13.setKilometerReward(this.kmReward.getValue() == null ? null : Double.valueOf(Double.parseDouble(this.kmReward.getValue().toString())));
            this.delivererModel.setGpsDeactivationCode(this.gpsDeactivationCode.getText());
            return true;
        }
        JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage(errorMessageKey, new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
        return false;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -4070510918061226363L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DelivererDialog.this.adaptValuesToModel()) {
                    DelivererDialog.this.doAfterOk();
                    DelivererDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.delivererEdited", new Serializable[]{DelivererDialog.this.delivererModel.getDelivererNumber(), DelivererDialog.this.delivererModel.getName()}));
                    DelivererDialog.this.dispose();
                }
            }
        };
    }

    protected void doAfterOk() {
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -6666981717422203934L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DelivererDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                DelivererDialog.this.delivererModel = null;
                DelivererDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(this.createLabel("messages.delivererNumber"));
        this.delivererNumber = new JTextField(20);
        this.delivererNumber.setEditable(this.editable && this.delivererModel.getDelivererNumber() == null);
        panel.add(this.delivererNumber);
        panel.add(this.createLabel("messages.default.name"));
        this.name = new JTextField(20);
        this.name.setEditable(this.editable);
        panel.add(this.name);
        panel.add(this.createLabel("messages.default.humanFactor"));
        NumberFormat format = NumberFormat.getNumberInstance(Locale.GERMANY);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(100));
        this.factor = new JFormattedTextField(formatter);
        this.factor.setColumns(10);
        this.factor.setEditable(this.editable);
        panel.add(this.factor);
        panel.add(this.createLabel("gui.tour.cost.hour"));
        this.hourReward = new JFormattedTextField(NumberFormat.getNumberInstance(Locale.GERMANY));
        this.hourReward.setEditable(this.editable);
        panel.add(this.hourReward);
        panel.add(this.createLabel("gui.tour.cost.km"));
        this.kmReward = new JFormattedTextField(NumberFormat.getNumberInstance(Locale.GERMANY));
        this.kmReward.setEditable(this.editable);
        panel.add(this.kmReward);
        panel.add(this.createLabel("messages.default.group"));
        this.branch = new BranchComboBox((Collection<BranchModel>)this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs(), true);
        this.branch.setEnabled(this.editable);
        panel.add(this.branch);
        panel.add(this.createLabel("messages.default.accounts"));
        panel.add(this.createAccountPane());
        panel.add(this.createLabel("messages.default.depot"));
        this.poi = new PoiComboBox((Collection<PoiModel>)this.modelEnviroment.getAllCaller().getTourCaller().fetchPoisWithTypes(CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION)), true);
        panel.add(this.poi);
        panel.add(this.createLabel("messages.default.status"));
        panel.add(this.createSubStatusPane());
        panel.add(this.createLabel("messages.deliverer.blockMobileData"));
        this.blockMobileData = new JCheckBox();
        panel.add(this.blockMobileData);
        panel.add(this.createLabel("messages.deliverer.mobilePauseTime"));
        JPanel subPanel = new JPanel(new BorderLayout());
        this.mobilePauseTimeActive = new JCheckBox();
        this.mobilePauseTimeActive.setSelected(false);
        subPanel.add((Component)this.mobilePauseTimeActive, "West");
        this.mobilePauseTime = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.mobilePauseTime.setEnabled(false);
        subPanel.add((Component)this.mobilePauseTime, "Center");
        panel.add(subPanel);
        this.mobilePauseTimeActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DelivererDialog.this.mobilePauseTime.setEnabled(DelivererDialog.this.mobilePauseTimeActive.isSelected());
            }
        });
        panel.add(this.createLabel("messages.deliverer.gpsDeactivationCode"));
        this.gpsDeactivationCode = new JTextField();
        panel.add(this.gpsDeactivationCode);
        SpringUtilities.makeCompactGrid(panel, 12, 2, 5, 5, 2, 2);
        return panel;
    }

    private JPanel createSubStatusPane() {
        JPanel substatusPane = new JPanel(new BorderLayout());
        this.subStatuses = new JList(new DefaultListModel());
        final ListCellRenderer cellRenderer = this.subStatuses.getCellRenderer();
        this.subStatuses.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DelivererStatusTimeWindowModel status;
                Object rValue = value;
                if (value instanceof DelivererStatusTimeWindowModel && (status = (DelivererStatusTimeWindowModel)value).getStatus() != null) {
                    EnumItem<DelivererStatus> item = new EnumItem<DelivererStatus>(status.getStatus());
                    String sValue = item.toString();
                    sValue = sValue + " (" + ClientFormUtil.dateToString(status.getStartTime(), FormUtil.DATEFORMAT) + " - " + ClientFormUtil.dateToString(status.getEndTime(), FormUtil.DATEFORMAT) + ")";
                    rValue = sValue;
                }
                return cellRenderer.getListCellRendererComponent(list, rValue, index, isSelected, cellHasFocus);
            }
        });
        this.subStatuses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indexes = DelivererDialog.this.subStatuses.getSelectedIndices();
                DelivererDialog.this.deleteSubStatusAction.setEnabled(DelivererDialog.this.editable && indexes != null && indexes.length > 0);
            }
        });
        substatusPane.add((Component)new JScrollPane(this.subStatuses), "Center");
        JPanel buttonPane = new JPanel(new BorderLayout());
        this.deleteSubStatusAction = new DeleteSubStatusAction();
        JButton delete = new JButton(this.deleteSubStatusAction);
        this.deleteSubStatusAction.setEnabled(false);
        buttonPane.add((Component)delete, "West");
        this.addSubStatusAction = new AddSubStatusAction();
        JButton add = new JButton(this.addSubStatusAction);
        this.addSubStatusAction.setEnabled(this.editable);
        buttonPane.add((Component)add, "East");
        substatusPane.add((Component)buttonPane, "South");
        return substatusPane;
    }

    private JPanel createAccountPane() {
        JPanel accountPane = new JPanel(new BorderLayout());
        this.accounts = new JList(new DefaultListModel());
        final ListCellRenderer cellRenderer = this.accounts.getCellRenderer();
        this.accounts.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object rValue = value;
                if (value instanceof AccountModel) {
                    AccountModel account = (AccountModel)value;
                    rValue = account.getLogin();
                }
                return cellRenderer.getListCellRendererComponent(list, rValue, index, isSelected, cellHasFocus);
            }
        });
        this.accounts.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indexes = DelivererDialog.this.accounts.getSelectedIndices();
                DelivererDialog.this.deleteAccountAction.setEnabled(DelivererDialog.this.editable && indexes != null && indexes.length > 0);
            }
        });
        this.accounts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AccountModel accountModel;
                super.mouseClicked(e);
                if (DelivererDialog.this.editable && e.getClickCount() >= 2 && (accountModel = (AccountModel)DelivererDialog.this.accounts.getSelectedValue()) != null) {
                    DelivererDialog.this.showAccountDialog(accountModel);
                }
            }
        });
        accountPane.add((Component)new JScrollPane(this.accounts), "Center");
        JPanel accountButtonPanel = new JPanel(new BorderLayout());
        this.deleteAccountAction = new DeleteAccountAction();
        JButton delete = new JButton(this.deleteAccountAction);
        this.deleteAccountAction.setEnabled(false);
        accountButtonPanel.add((Component)delete, "West");
        this.addAccountAction = new AddAccountAction();
        JButton add = new JButton(this.addAccountAction);
        this.addAccountAction.setEnabled(this.editable);
        accountButtonPanel.add((Component)add, "East");
        accountPane.add((Component)accountButtonPanel, "South");
        return accountPane;
    }

    private boolean showAccountDialog(AccountModel accountModel) {
        int d;
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(this.createLabel("messages.default.user"));
        JTextField user = new JTextField(20);
        user.setText(accountModel.getLogin());
        panel.add(user);
        panel.add(this.createLabel("gui.userdialog.password"));
        JPasswordField password1 = new JPasswordField(20);
        panel.add(password1);
        panel.add(this.createLabel("gui.userdialog.password.repeat"));
        JPasswordField password2 = new JPasswordField(20);
        panel.add(password2);
        SpringUtilities.makeCompactGrid(panel, 3, 2, 5, 5, 2, 2);
        while ((d = JOptionPane.showConfirmDialog(this, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.account", new Serializable[0]), 0, -1)) == 0 && !this.checkAccountValues(accountModel, user.getText(), password1.getPassword(), password2.getPassword())) {
        }
        if (d == 0) {
            accountModel.setLogin(user.getText());
            accountModel.setMd5Password(StringUtil.getMd5String(password1.getPassword()));
            return true;
        }
        return false;
    }

    private boolean checkAccountValues(AccountModel accountModel, String login, char[] password, char[] password2) {
        boolean ok = true;
        Collection<AccountModel> dirtyModels = this.modelEnviroment.getModelCache().getCachedModels(AccountModel.class);
        for (AccountModel accountModel2 : dirtyModels) {
            String dirtyLogin;
            if (accountModel.equals(accountModel2) || !new EqualsBuilder().append(login, dirtyLogin = accountModel2.getLogin()).isEquals()) continue;
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.error.multipleLogin", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            ok = false;
            break;
        }
        if (ok) {
            HashSet<Long> dirtyIds = new HashSet<Long>();
            for (AccountModel dirtyAccount : dirtyModels) {
                dirtyIds.add(dirtyAccount.getId());
            }
            dirtyIds.add(accountModel.getId());
            boolean bl = this.modelEnviroment.getAllCaller().getValidateCaller().validateExistingMobileAccount(login, dirtyIds);
            if (!bl) {
                JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.error.multipleLogin", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                ok = false;
            }
        }
        if (!ArrayUtils.isEquals(password, password2)) {
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.error.unequalPasswords", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            ok = false;
        }
        return ok;
    }

    private JLabel createLabel(String key) {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
        label.setVerticalAlignment(1);
        return label;
    }

    public DelivererModel getDelivererModel() {
        return this.delivererModel;
    }

    private class AddSubStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = 7308306454662648296L;

        public AddSubStatusAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final EnumComboBox status = new EnumComboBox(DelivererStatus.class, false, (Enum[])DelivererStatus.values());
            status.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            AbstractDelivererTimeIntervalDialog dialog = new AbstractDelivererTimeIntervalDialog(DelivererDialog.this.getParent(), status, "messages.default.status"){
                private static final long serialVersionUID = 7285990464599353619L;

                @Override
                protected void setTimeWindow(Set<Tupel<Date, Date>> timeWindows) {
                    for (Tupel<Date, Date> timeWindow : timeWindows) {
                        DelivererStatusTimeWindowModelImpl subStatus = new DelivererStatusTimeWindowModelImpl();
                        subStatus.setStatus((DelivererStatus)((Object)status.getSelectedValue()));
                        subStatus.setStartTime(timeWindow.getElement1());
                        subStatus.setEndTime(timeWindow.getElement2());
                        DefaultListModel dlm = (DefaultListModel)DelivererDialog.this.subStatuses.getModel();
                        if (DelivererModelUtil.resolveTimeIntervalConflicts((Component)DelivererDialog.this, DelivererDialog.this.delivererModel, subStatus, dlm) == 1) {
                            subStatus.delete();
                            continue;
                        }
                        subStatus.setDeliverer(DelivererDialog.this.delivererModel);
                        dlm.addElement(subStatus);
                    }
                }
            };
            dialog.setVisible(true);
        }
    }

    private class DeleteSubStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = -2103924914988322768L;

        public DeleteSubStatusAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues;
            DefaultListModel dlm = (DefaultListModel)DelivererDialog.this.subStatuses.getModel();
            for (Object selectedValue : selectedValues = DelivererDialog.this.subStatuses.getSelectedValues()) {
                dlm.removeElement(selectedValue);
                DelivererStatusTimeWindowModel subStatus = (DelivererStatusTimeWindowModel)selectedValue;
                subStatus.setDeliverer(null);
                subStatus.delete();
            }
        }
    }

    private class AddAccountAction
    extends AbstractAction {
        private static final long serialVersionUID = -8697408377385908816L;

        public AddAccountAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AccountModelImpl accountModel = new AccountModelImpl();
            accountModel.setDeliverer(DelivererDialog.this.delivererModel);
            accountModel.setLogin("");
            accountModel.setMd5Password("");
            if (DelivererDialog.this.showAccountDialog(accountModel)) {
                DefaultListModel dlm = (DefaultListModel)DelivererDialog.this.accounts.getModel();
                dlm.addElement(accountModel);
            } else {
                accountModel.delete();
            }
        }
    }

    private class DeleteAccountAction
    extends AbstractAction {
        private static final long serialVersionUID = 1420438828975341991L;

        public DeleteAccountAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues;
            DefaultListModel dlm = (DefaultListModel)DelivererDialog.this.accounts.getModel();
            for (Object selectedValue : selectedValues = DelivererDialog.this.accounts.getSelectedValues()) {
                dlm.removeElement(selectedValue);
                AccountModel accountModel = (AccountModel)selectedValue;
                accountModel.setDeliverer(null);
                accountModel.delete();
            }
        }
    }
}

