/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.client.manager.handler.CalendarActions;
import de.datomino.peppergis.client.manager.util.WeekdayName;
import de.datomino.peppergis.util.FormUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CalendarGui {
    private JComboBox yearComboBox;
    private JComboBox monthComboBox;
    private JButton[] dayButtons;
    private Date currentDate;
    protected GregorianCalendar calendar;
    private JFormattedTextField currentDayField;
    private static final int[] DAYSINMONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public JPanel createCalendarGui() {
        CalendarActions caldendarActions = new CalendarActions(this);
        JPanel monthCalendarPanel = new JPanel(new BorderLayout());
        monthCalendarPanel.setPreferredSize(FormUtil.SIZEOFCALENDAR);
        monthCalendarPanel.add((Component)this.createCalendarDateChangePanel(caldendarActions), "North");
        monthCalendarPanel.add((Component)this.createCalendarDaysPanel(caldendarActions), "Center");
        JPanel southPane = new JPanel(new GridLayout(1, 2));
        this.currentDayField = new JFormattedTextField(new SimpleDateFormat(FormUtil.DATEFORMAT)){
            private static final long serialVersionUID = 4924498587424161606L;

            @Override
            public void setBorder(Border border) {
            }
        };
        this.currentDayField.setEditable(false);
        this.currentDayField.setBackground(Color.WHITE);
        this.currentDayField.setValue(new Date());
        southPane.add(this.currentDayField);
        JButton todayButton = new JButton(caldendarActions.getTodayAction()){
            private static final long serialVersionUID = -7323990738409513662L;

            @Override
            public void setBorder(Border border) {
            }
        };
        todayButton.setBackground(Color.WHITE);
        southPane.add(todayButton);
        southPane.setBackground(Color.WHITE);
        southPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        monthCalendarPanel.add((Component)southPane, "South");
        caldendarActions.displayCalendar();
        return monthCalendarPanel;
    }

    public void update() {
        this.setCurrentDate(this.calendar.getTime());
    }

    protected boolean isSameWeek(String[] date) {
        int selDay = Integer.parseInt(date[0].trim());
        int selMonth = Integer.parseInt(date[1].trim());
        int selYear = Integer.parseInt(date[2].trim());
        return selDay == this.calendar.get(5) && selMonth == this.calendar.get(2) + 1 && selYear == this.calendar.get(1);
    }

    protected String changDayInHeader(String oldHeader, GregorianCalendar currentDay) {
        String[] lines = oldHeader.split("\n");
        if (lines.length != 4) {
            return oldHeader;
        }
        return " \n" + lines[1] + "\n" + currentDay.get(5) + " - " + (currentDay.get(2) + 1) + " - " + currentDay.get(1) + "\n \n";
    }

    private JPanel createCalendarDaysPanel(CalendarActions calendarActions) {
        JPanel calendarDaysPanel = new JPanel(new BorderLayout());
        JLabel weekday1 = this.createWeekdayLabel(WeekdayName.D7.getShortName(), Color.RED);
        JLabel weekday2 = this.createWeekdayLabel(WeekdayName.D6.getShortName(), Color.BLUE);
        JLabel weekday3 = this.createWeekdayLabel(WeekdayName.D5.getShortName(), Color.BLACK);
        JLabel weekday4 = this.createWeekdayLabel(WeekdayName.D4.getShortName(), Color.BLACK);
        JLabel weekday5 = this.createWeekdayLabel(WeekdayName.D3.getShortName(), Color.BLACK);
        JLabel weekday6 = this.createWeekdayLabel(WeekdayName.D2.getShortName(), Color.BLACK);
        JLabel weekday7 = this.createWeekdayLabel(WeekdayName.D1.getShortName(), Color.BLACK);
        JPanel weekPanel = new JPanel(new GridLayout(1, 7));
        weekPanel.setBorder(BorderFactory.createEmptyBorder());
        weekPanel.add(weekday7);
        weekPanel.add(weekday6);
        weekPanel.add(weekday5);
        weekPanel.add(weekday4);
        weekPanel.add(weekday3);
        weekPanel.add(weekday2);
        weekPanel.add(weekday1);
        JPanel daysPanel = new JPanel(new GridLayout(6, 7));
        daysPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.dayButtons = new JButton[42];
        for (int i = 0; i < this.dayButtons.length; ++i) {
            this.dayButtons[i] = new JButton(calendarActions.getDayChangeAction());
            this.dayButtons[i].setBackground(Color.WHITE);
            this.dayButtons[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.dayButtons[i].setHorizontalAlignment(0);
            this.dayButtons[i].setHorizontalTextPosition(0);
            this.dayButtons[i].setName("day");
            daysPanel.add(this.dayButtons[i]);
        }
        calendarDaysPanel.add((Component)weekPanel, "North");
        calendarDaysPanel.add((Component)daysPanel, "Center");
        return calendarDaysPanel;
    }

    private JLabel createWeekdayLabel(String string, Color color) {
        JLabel weekday = new JLabel();
        weekday.setForeground(color);
        weekday.setHorizontalAlignment(0);
        weekday.setHorizontalTextPosition(0);
        weekday.setText(string);
        return weekday;
    }

    private JPanel createCalendarDateChangePanel(final CalendarActions calendarActions) {
        JPanel calendarDateChangePanel = new JPanel();
        calendarDateChangePanel.setLayout(new BorderLayout());
        calendarDateChangePanel.setBorder(null);
        Vector<String> yearList = new Vector<String>(50);
        for (int i = 2000; i < 2050; ++i) {
            yearList.addElement(String.valueOf(i));
        }
        this.yearComboBox = new JComboBox(yearList);
        this.yearComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                calendarActions.setYear(Integer.valueOf((String)CalendarGui.this.yearComboBox.getSelectedItem()));
            }
        });
        Vector<String> monthList = new Vector<String>(12);
        for (int i = 1; i < 13; ++i) {
            monthList.addElement(String.valueOf(i));
        }
        this.monthComboBox = new JComboBox(monthList);
        this.monthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                calendarActions.setMonth(Integer.valueOf((String)CalendarGui.this.monthComboBox.getSelectedItem()) - 1);
            }
        });
        JButton monthDownButton = new JButton(calendarActions.getMonthDownAction());
        JButton monthUpButton = new JButton(calendarActions.getMonthUpAction());
        calendarDateChangePanel.setLayout(new GridLayout(1, 3));
        calendarDateChangePanel.add(this.yearComboBox);
        calendarDateChangePanel.add(this.monthComboBox);
        calendarDateChangePanel.add(monthDownButton);
        calendarDateChangePanel.add(monthUpButton);
        calendarDateChangePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        return calendarDateChangePanel;
    }

    public void setDateDisplay(String year, String month) {
        this.yearComboBox.getModel().setSelectedItem(year);
        this.monthComboBox.setSelectedItem(month);
    }

    public void displayCalendar(GregorianCalendar calendar) {
        Calendar cal = Calendar.getInstance();
        cal.set(calendar.get(1), calendar.get(2), calendar.get(5));
        this.currentDate = cal.getTime();
        calendar.set(cal.get(1), cal.get(2), 1);
        int firstDayOfWeek = calendar.get(7);
        if (firstDayOfWeek == 1) {
            firstDayOfWeek = 8;
        }
        int daysOfMonth = DAYSINMONTH[cal.get(2)];
        if (calendar.isLeapYear(calendar.get(1)) && cal.get(2) == 1) {
            ++daysOfMonth;
        }
        this.showDays(firstDayOfWeek, daysOfMonth, calendar.get(5));
        this.setDateDisplay(Integer.toString(calendar.get(1)), Integer.toString(cal.get(2) + 1));
    }

    public void showDays(int firstDayOfWeek, int daysOfMonth, int currentDay) {
        this.clearDayDisplay();
        for (int day = 1; day <= daysOfMonth; ++day) {
            int pos = day + firstDayOfWeek - 3;
            this.dayButtons[pos].setText(Integer.toString(day));
            this.dayButtons[pos].setEnabled(true);
            if (day == currentDay) {
                this.dayButtons[pos].setSelected(true);
                continue;
            }
            this.dayButtons[pos].setSelected(false);
        }
    }

    private void clearDayDisplay() {
        for (int i = 0; i < 42; ++i) {
            this.dayButtons[i].setEnabled(false);
            this.dayButtons[i].setSelected(false);
            this.dayButtons[i].setText("");
        }
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
        this.currentDayField.setValue(currentDate);
    }

    public GregorianCalendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(GregorianCalendar calendar) {
        this.calendar = calendar;
    }
}

