/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.manager;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.navigator.RoutePlannerPane;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.manager.AbstractRoutingGui;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractManagerMapGui<M>
extends AbstractRoutingGui<M> {
    private static final long serialVersionUID = 4356162773636657220L;
    public static double MAXUPPFORPARCEL = 1.0;
    protected NavigatorPanel navigatorPanel;
    protected ModelEnviroment modelEnviroment;
    protected Coordinate coordinate;

    public AbstractManagerMapGui(LayoutManager layout, ModelEnviroment modelEnviroment) {
        super(layout);
        this.modelEnviroment = modelEnviroment;
    }

    public abstract Component getPane();

    public abstract void setAreaRectangles(Set<Coordinate> var1);

    public AreaLayerModel getLayer() {
        return null;
    }

    public FilterEntity getCurrentFilter() {
        return null;
    }

    @Override
    public List<NavigatorRenderer> getRenderer() {
        return this.navigatorPanel.getRenderers();
    }

    protected Tupel<ImmutablePoint, ImmutablePoint> getDefaultBoundary() {
        Coordinate centerCoordinate = OpenStreetmapViewFactory.INSTANCE.createCoordinate(this.coordinate);
        Coordinate topLeftCoordinate = OpenStreetmapViewFactory.INSTANCE.createCoordinate(centerCoordinate.getX() - 200.0, centerCoordinate.getY() + 200.0);
        Coordinate bottomRightCoordinate = OpenStreetmapViewFactory.INSTANCE.createCoordinate(centerCoordinate.getX() + 200.0, centerCoordinate.getY() - 200.0);
        ImmutablePoint topLeft = ImmutableGeoObjectFactory.createImmutablePoint(topLeftCoordinate);
        ImmutablePoint bottomRight = ImmutableGeoObjectFactory.createImmutablePoint(bottomRightCoordinate);
        return new Tupel<ImmutablePoint, ImmutablePoint>(topLeft, bottomRight);
    }

    public NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = Wgs84Factory.INSTANCE.createCoordinate(coordinate);
    }

    public void updateParcelAndSubscription() {
        if (this.navigatorPanel.getUpp() > MAXUPPFORPARCEL) {
            return;
        }
        Tupel<ImmutablePoint, ImmutablePoint> boundary = GeoUtils.getBoundaryOfNavigatorPanel(this.navigatorPanel);
        if (boundary == null) {
            boundary = this.getDefaultBoundary();
        }
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        List<NavigatorRenderer> renderers = this.navigatorPanel.getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (renderer instanceof SubscriptionLayerRenderer && renderer.isActive()) {
                List<SubscriptionModel> subscriptions = tourCaller.fetchSubscriptions(boundary.getElement1(), boundary.getElement2());
                ((SubscriptionLayerRenderer)renderer).setWithIndex(false);
                ArrayList<Tupel<SubscriptionModel, Integer>> tupel = new ArrayList<Tupel<SubscriptionModel, Integer>>(subscriptions.size());
                CollectionUtil.transform(subscriptions, tupel, new Transformer<SubscriptionModel, Tupel<SubscriptionModel, Integer>>(){

                    @Override
                    public Tupel<SubscriptionModel, Integer> transform(SubscriptionModel t) {
                        return new Tupel<SubscriptionModel, Object>(t, null);
                    }
                });
                ((SubscriptionLayerRenderer)renderer).setSubscriptions(tupel);
            }
            if (!(renderer instanceof ParcelLayerRenderer) || !renderer.isActive()) continue;
            List<ParcelModel> parcels = tourCaller.fetchParcels(boundary.getElement1(), boundary.getElement2(), false);
            ((ParcelLayerRenderer)renderer).setParcels(parcels);
        }
        this.navigatorPanel.repaint();
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected JPanel createRoutePlannerPane(final JTabbedPane tabbedPane) {
        final RoutePlannerPane pane = new RoutePlannerPane(this.getNavigatorPanel(), this, this.getModelEnviroment());
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (tabbedPane.getSelectedComponent() == pane.getParent()) {
                    pane.setActive(true);
                } else {
                    pane.setActive(false);
                }
            }
        });
        return ClientSwingUtil.createPanelForComponent(pane, " ");
    }
}

