/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.importer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.Importer;
import de.datomino.peppergis.dto.importer.ContentImportDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.CsvColumnManager;
import de.datomino.util.assistant.model.CsvContentGuesser;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.FileField;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.assistant.model.StringField;
import de.datomino.util.assistant.model.Wizard;
import de.datomino.util.callback.CallBack;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;

public abstract class AbstractCsvImporter<D extends GenericCsvDto>
implements Importer {
    protected FileField fileField;
    protected StringField delimiterField;
    protected StringField textQuoteField;
    protected StringField encodingField;
    private List<CsvColumnChoiceField> columnMapFields;
    private Integer maximumFieldCount;

    public AbstractCsvImporter() {
        this(null);
    }

    public AbstractCsvImporter(Integer maximumFieldCount) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.fileField = new FileField(messageResolver.resolveMessage("messages.parameter.file", new Serializable[0]), null, (List<? extends FileFilter>)Collections.singletonList(new FileNameExtensionFilter("CSV", "csv", "CSV")));
        this.delimiterField = new StringField(messageResolver.resolveMessage("messages.parameter.delimiter", new Serializable[0]), ";");
        this.textQuoteField = new StringField(messageResolver.resolveMessage("messages.parameter.textquote", new Serializable[0]), "\"");
        this.encodingField = new StringField(messageResolver.resolveMessage("messages.parameter.encoding", new Serializable[0]), "UTF-8");
        this.maximumFieldCount = maximumFieldCount;
    }

    @Override
    public Wizard getWizard() {
        Iterator<Fieldset> addFieldsetIterator;
        Wizard wizard = new Wizard(this.getTitle());
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Page file = new Page(messageResolver.resolveMessage("messages.page.file.title", new Serializable[0]));
        Fieldset fileParams = new Fieldset(messageResolver.resolveMessage("messages.parameter.file.title", new Serializable[0]));
        fileParams.addField(this.fileField);
        file.addFieldset(fileParams);
        Fieldset csvParams = new Fieldset(messageResolver.resolveMessage("messages.parameter.csvparams.title", new Serializable[0]));
        csvParams.addField(this.delimiterField);
        csvParams.addField(this.textQuoteField);
        csvParams.addField(this.encodingField);
        CsvContentGuesser contentGuesser = new CsvContentGuesser(this.fileField, this.encodingField, this.delimiterField, this.textQuoteField, messageResolver);
        csvParams.addAction(contentGuesser);
        file.addFieldset(csvParams);
        wizard.addPage(file);
        List<CsvColumnChoiceField> columnMapFieldsLocal = this.getColumnMapFields();
        file.addLeaveAction(new CsvColumnManager(contentGuesser, columnMapFieldsLocal));
        List<CallBack<Boolean, Window>> additionalFileLeaveActions = this.getAdditonalFileLeaveActions(contentGuesser);
        for (CallBack<Boolean, Window> action : additionalFileLeaveActions) {
            file.addLeaveAction(action);
        }
        LinkedList dataPages = new LinkedList();
        List<Fieldset> addfieldsets = this.getAdditionalFieldsets();
        Iterator<CsvColumnChoiceField> csvColumnChoiceFieldIterator = columnMapFieldsLocal.iterator();
        Iterator<Fieldset> iterator = addFieldsetIterator = addfieldsets == null ? null : addfieldsets.iterator();
        if (csvColumnChoiceFieldIterator.hasNext() || addFieldsetIterator != null && addFieldsetIterator.hasNext()) {
            List<Page> data = this.createPage(csvColumnChoiceFieldIterator, addFieldsetIterator, this.getDataLeaveActions());
            dataPages.addAll(data);
        }
        for (Page data : dataPages) {
            wizard.addPage(data);
        }
        List<Page> addPages = this.getAdditionalPages();
        if (addPages != null) {
            for (Page page : addPages) {
                wizard.addPage(page);
            }
        }
        return wizard;
    }

    protected List<CallBack<Boolean, Window>> getDataLeaveActions() {
        return Collections.emptyList();
    }

    protected List<Page> createPage(Iterator<CsvColumnChoiceField> columnMapFieldsLocal, Iterator<Fieldset> addfieldsets, List<CallBack<Boolean, Window>> leaveActions) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        ArrayList<Page> pages = new ArrayList<Page>();
        while (columnMapFieldsLocal.hasNext()) {
            Page data = new Page(messageResolver.resolveMessage("messages.page.content.title", new Serializable[0]));
            pages.add(data);
            Fieldset columns = new Fieldset(messageResolver.resolveMessage("messages.parameter.column.title", new Serializable[0]));
            data.addFieldset(columns);
            for (int count = 0; columnMapFieldsLocal.hasNext() && (this.maximumFieldCount == null || count < this.maximumFieldCount); ++count) {
                columns.addField(columnMapFieldsLocal.next());
            }
        }
        if (addfieldsets != null && addfieldsets.hasNext()) {
            Page data = pages.isEmpty() ? new Page(messageResolver.resolveMessage("messages.page.content.title", new Serializable[0])) : (Page)pages.get(pages.size() - 1);
            while (addfieldsets.hasNext()) {
                data.addFieldset(addfieldsets.next());
            }
        }
        Page data = pages.isEmpty() ? new Page(messageResolver.resolveMessage("messages.page.content.title", new Serializable[0])) : (Page)pages.get(pages.size() - 1);
        for (CallBack<Boolean, Window> action : leaveActions) {
            data.addLeaveAction(action);
        }
        return pages;
    }

    protected List<CsvColumnChoiceField> getColumnMapFields() {
        if (this.columnMapFields == null || this.columnMapFields.isEmpty()) {
            this.columnMapFields = new LinkedList<CsvColumnChoiceField>();
            this.addCsvFields(this.columnMapFields);
        }
        return this.columnMapFields;
    }

    protected abstract void addCsvFields(List<CsvColumnChoiceField> var1);

    protected List<Fieldset> getAdditionalFieldsets() {
        return null;
    }

    protected List<Page> getAdditionalPages() {
        return null;
    }

    protected List<CallBack<Boolean, Window>> getAdditonalFileLeaveActions(CsvContentGuesser contentGuesser) {
        return Collections.emptyList();
    }

    public abstract String getTitle();

    protected String createRegex(String ... regs) {
        return CsvColumnChoiceField.createRegex(regs);
    }

    protected String createRegexForXCoordinate() {
        return CsvColumnChoiceField.createRegexForXCoordinate();
    }

    protected String createRegexForYCoordinate() {
        return CsvColumnChoiceField.createRegexForYCoordinate();
    }

    protected void writeToDto(D dto) {
        byte[] content;
        try {
            content = FileUtils.readFileToByteArray((File)this.fileField.getValue());
            ((GenericCsvDto)dto).setDelim(((String)this.delimiterField.getValue()).charAt(0));
            ((GenericCsvDto)dto).setTextQuote(((String)this.textQuoteField.getValue()).charAt(0));
            ((GenericCsvDto)dto).setEncoding((String)this.encodingField.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ((ContentImportDto)dto).setContent(content);
        for (CsvColumnChoiceField choiceField : this.columnMapFields) {
            ((GenericCsvDto)dto).setSingleColumnMapping(choiceField.getCanonicalName(), ((String)choiceField.getValue()).trim());
        }
    }
}

