/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.subscription;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModel;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.filter.subscription.SubscriptionFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.CyclingIterator;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class SubscriptionFilterableMarkerRenderer
extends AbstractFilterableMarkerNavigatorRenderer<SubscriptionModel, SubscriptionLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties, SubscriptionFilterModel> {
    private static final long serialVersionUID = -900631221474032854L;
    private static final Color MARK_GREEN_COLOR = new Color(0, 153, 0);
    private AbstractMapEditorPanel editorPanel;
    private Map<AreaObjectModel, Color> areaObjectColorCache = new LinkedHashMap<AreaObjectModel, Color>();
    private Map<SubscriptionLocationObject, Tupel<ImmutablePoint, Double>> drawedSubscriptionsOnMap = new LinkedHashMap<SubscriptionLocationObject, Tupel<ImmutablePoint, Double>>();
    private AreaPointRenderer areaPointRenderer = null;
    private SubscriptionFilterPatternSetupRendererSelektor subscriptionFilterPatternSetupSelektor;
    private CyclingIterator<Color> cyclingColorIterator;
    protected AreaLayerModel layer;
    private Mode mode;
    private SubscriptionToggleAction allToggleAction;
    private SubscriptionToggleAction activeToggleAction;
    private SubscriptionToggleAction inactiveToggleAction;

    public SubscriptionFilterableMarkerRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel layer) {
        super(name, title, editorPanel.getNavigatorPanel(), null, null, new DummyPointRenderer(), maxUpp, bucketsModel, true);
        this.editorPanel = editorPanel;
        ((DummyPointRenderer)this.getPointRenderer()).setSubscriptionRenderer(this);
        this.cyclingColorIterator = new CyclingIterator<Color>(PaintUtil.RANDOM_COLORS);
        this.layer = layer;
        this.mode = Mode.ALL;
        this.allToggleAction = new SubscriptionToggleAction(title, Mode.ALL);
        this.activeToggleAction = new SubscriptionToggleAction("Aktive Abonnenten markieren", Mode.ACTIVE);
        this.inactiveToggleAction = new SubscriptionToggleAction("Inaktive Abonnenten markieren", Mode.INACTIVE);
        this.allToggleAction.toggleActions = Arrays.asList(this.activeToggleAction, this.inactiveToggleAction);
        this.activeToggleAction.toggleActions = Arrays.asList(this.allToggleAction, this.inactiveToggleAction);
        this.inactiveToggleAction.toggleActions = Arrays.asList(this.allToggleAction, this.activeToggleAction);
    }

    @Override
    public synchronized Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        this.drawedSubscriptionsOnMap.clear();
        return super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
    }

    @Override
    protected void drawHover(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, Collection<SubscriptionLocationObject> hovers, double upp) {
        double margin = 10.0 * upp;
        for (SubscriptionLocationObject subscriptionLocationObject : hovers) {
            if (subscriptionLocationObject == null) continue;
            this.createInfobox((SubscriptionModel)subscriptionLocationObject.getModel(), margin, subscriptionLocationObject.getImmutablePoint());
        }
    }

    @Override
    protected void paintSpecialElements(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        for (SubscriptionLocationObject subscription : this.drawedSubscriptionsOnMap.keySet()) {
            int count = 0;
            Tupel<ImmutablePoint, Double> tupel = this.drawedSubscriptionsOnMap.get(subscription);
            CoordinateFactory coordinateFactory = this.getNavigatorPanel().getCoordinateFactory();
            Rectangle2D.Double rectangle = DefaultPointRenderer.getRectangle(((ImmutablePoint)tupel.getElement1().getTransformed(coordinateFactory)).getCoordinate(), tupel.getElement2() * 2.0, tupel.getElement2() * 1.5);
            Color colorOfAreaObject = this.areaObjectColorCache.get(((SubscriptionModel)subscription.getModel()).getAreaObject());
            for (Tupel<ImmutablePoint, Double> t : this.drawedSubscriptionsOnMap.values()) {
                Rectangle2D.Double r = DefaultPointRenderer.getRectangle(((ImmutablePoint)t.getElement1().getTransformed(coordinateFactory)).getCoordinate(), t.getElement2() * 2.0, tupel.getElement2() * 1.5);
                if (!r.contains(rectangle)) continue;
                ++count;
            }
            if (count <= true) continue;
            Coordinate c = coordinateFactory.createCoordinate(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            RendererNode node = new RendererNode(String.valueOf(count), c, tupel.getElement2());
            node.setFontground(colorOfAreaObject);
            this.areaPointRenderer.drawText(node);
        }
    }

    private void createInfobox(SubscriptionModel subscription, double margin, ImmutablePoint geom) {
        List<String> infoBox = SubscriptionModelUtil.getInfoBoxString(subscription);
        Color colorOfAreaObject = this.areaObjectColorCache.get(subscription.getAreaObject());
        if (geom != null && this.areaPointRenderer != null) {
            this.areaPointRenderer.drawInfoBox(infoBox, geom.getCoordinate(), colorOfAreaObject, margin);
        }
    }

    public void setSubscriptionFilterPatternSetupModel(SubscriptionFilterPatternSetupModel subscriptionFilterPatternSetupModel, ModelEnviroment modelEnviroment) {
        this.clearRendererCache();
        SubscriptionFilterPatternSetupRendererSelektor subscriptionFilterPatternSetupRendererSelektor = this.subscriptionFilterPatternSetupSelektor = subscriptionFilterPatternSetupModel == null ? null : new SubscriptionFilterPatternSetupRendererSelektor(subscriptionFilterPatternSetupModel, modelEnviroment);
        if (this.subscriptionFilterPatternSetupSelektor == null) {
            this.setRendererChecker(null);
        } else {
            this.setRendererChecker(new RendererChecker<SubscriptionLocationObject>(){

                @Override
                public boolean isToBeRendered(SubscriptionLocationObject w) {
                    return SubscriptionFilterableMarkerRenderer.this.subscriptionFilterPatternSetupSelektor.isToBeRendered(w.getModel());
                }
            });
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected AbstractFilterPatternSetupRendererSelektor<?, SubscriptionModel, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor() {
        return this.subscriptionFilterPatternSetupSelektor;
    }

    @Override
    protected int getCycles() {
        return 1;
    }

    @Override
    public void showMarked(Collection<SubscriptionLocationObject> markedObjects) {
        if (markedObjects == null) {
            return;
        }
        Collection<SubscriptionModel> subscriptions = this.createSubscriptionCollection(markedObjects);
        LinkedList<SubscriptionLocationObject> markedObjectsOnlyInLayer = new LinkedList<SubscriptionLocationObject>();
        for (SubscriptionLocationObject sub : markedObjects) {
            if (!this.isProperLayer(sub)) continue;
            markedObjectsOnlyInLayer.add(sub);
        }
        CollectionUtil.transform(markedObjectsOnlyInLayer, subscriptions, new Transformer<SubscriptionLocationObject, SubscriptionModel>(){

            @Override
            public SubscriptionModel transform(SubscriptionLocationObject t) {
                return (SubscriptionModel)t.getModel();
            }
        });
        this.editorPanel.updatePanelAfterMark(this.getRenderObjectType(), subscriptions);
    }

    protected boolean isProperLayer(SubscriptionLocationObject sub) {
        return ((SubscriptionModel)sub.getModel()).getAreaLayer() == this.layer;
    }

    protected Collection<SubscriptionModel> createSubscriptionCollection(Collection<SubscriptionLocationObject> markedObjects) {
        return new HashSet<SubscriptionModel>(markedObjects.size());
    }

    @Override
    protected void showClicked(Collection<SubscriptionLocationObject> cs) {
        ArrayList<SubscriptionLocationObject> filtered = new ArrayList<SubscriptionLocationObject>(cs.size());
        for (SubscriptionLocationObject locationObject : cs) {
            if (!this.isProperLayer(locationObject)) continue;
            filtered.add(locationObject);
        }
        if (!filtered.isEmpty()) {
            ArrayList<SubscriptionModel> subscriptions = new ArrayList<SubscriptionModel>(filtered.size());
            CollectionUtil.transform(filtered, subscriptions, new Transformer<SubscriptionLocationObject, SubscriptionModel>(){

                @Override
                public SubscriptionModel transform(SubscriptionLocationObject object) {
                    return (SubscriptionModel)object.getModel();
                }
            });
            SubscriptionDialog subscriptionDialog = new SubscriptionDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), subscriptions, this.editorPanel.getModelEnviroment());
            subscriptionDialog.setInternalFrame(this.getInternalFrame());
            subscriptionDialog.setVisible(true);
        }
    }

    protected PausableInternalFrame getInternalFrame() {
        return null;
    }

    @Override
    protected boolean isToDrawObject(SubscriptionLocationObject s) {
        boolean activeDraw;
        SubscriptionModel model = (SubscriptionModel)s.getModel();
        AreaLayerModel areaLayer = model.getAreaLayer();
        boolean bl = activeDraw = SubscriptionModelUtil.isActive((SubscriptionModel)s.getModel()) && SubscriptionModelUtil.isCurrentDateInTimeRange(model);
        if (this.layer == null || areaLayer != null && areaLayer.equals(this.layer)) {
            switch (this.mode) {
                case ALL: {
                    return true;
                }
                case ACTIVE: {
                    return activeDraw;
                }
                case INACTIVE: {
                    return !activeDraw;
                }
            }
        }
        return false;
    }

    @Override
    protected Collection<SubscriptionLocationObject> getFilteredObjects(Collection<SubscriptionLocationObject> ss) {
        Collection<SubscriptionLocationObject> subscriptionLocationObjects = super.getFilteredObjects(ss);
        switch (this.mode) {
            case ALL: {
                return subscriptionLocationObjects;
            }
            case ACTIVE: {
                LinkedList<SubscriptionLocationObject> filtered = new LinkedList<SubscriptionLocationObject>();
                for (SubscriptionLocationObject slo : subscriptionLocationObjects) {
                    SubscriptionModel model = (SubscriptionModel)slo.getModel();
                    if (!SubscriptionModelUtil.isActive(model) || !SubscriptionModelUtil.isCurrentDateInTimeRange(model)) continue;
                    filtered.add(slo);
                }
                return filtered;
            }
            case INACTIVE: {
                LinkedList<SubscriptionLocationObject> filtered = new LinkedList<SubscriptionLocationObject>();
                for (SubscriptionLocationObject slo : subscriptionLocationObjects) {
                    SubscriptionModel model = (SubscriptionModel)slo.getModel();
                    if (SubscriptionModelUtil.isActive(model) && SubscriptionModelUtil.isCurrentDateInTimeRange(model)) continue;
                    filtered.add(slo);
                }
                return filtered;
            }
        }
        return subscriptionLocationObjects;
    }

    @Override
    public AbstractFilterableMarkerNavigatorRenderer.RenderObjectType getRenderObjectType() {
        return AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.SUBSCRIPTIONRENDERER;
    }

    public void removeMarkedSubscriptions(Collection<SubscriptionModel> subscriptions) {
        HashSet<SubscriptionModel> set = new HashSet<SubscriptionModel>(subscriptions);
        Collection markedObjects = this.getMarkedObjects();
        ArrayList<SubscriptionLocationObject> list = new ArrayList<SubscriptionLocationObject>(subscriptions.size());
        for (SubscriptionLocationObject subscriptionLocationObject : markedObjects) {
            if (!set.contains(subscriptionLocationObject.getModel())) continue;
            list.add(subscriptionLocationObject);
        }
        this.removeMarkedObjects(list);
    }

    @Override
    protected Iterable<? extends Model> getChangeListeningModels(SubscriptionLocationObject s) {
        return ((SubscriptionModel)s.getModel()).iterableSubscriptionAttributeValues();
    }

    @Override
    public void defaultSelectionChanged(PatterLegendSelectionEvent<SubscriptionFilterModel> event) {
        super.defaultSelectionChanged(event);
        if (this.subscriptionFilterPatternSetupSelektor != null) {
            this.subscriptionFilterPatternSetupSelektor.setShowFilterDefault(event.isSelected());
        }
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    @Override
    public void filterSelectionChanged(PatterLegendSelectionEvent<SubscriptionFilterModel> event) {
        super.filterSelectionChanged(event);
        if (this.subscriptionFilterPatternSetupSelektor != null) {
            this.subscriptionFilterPatternSetupSelektor.turnFilter(event.getObjectFilter(), event.isSelected());
        }
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public SubscriptionToggleAction getAllToggleAction() {
        return this.allToggleAction;
    }

    public SubscriptionToggleAction getActiveToggleAction() {
        return this.activeToggleAction;
    }

    public SubscriptionToggleAction getInactiveToggleAction() {
        return this.inactiveToggleAction;
    }

    protected AreaPointRenderer getAreaPointRenderer() {
        return this.areaPointRenderer;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    private class SubscriptionToggleAction
    extends AbstractToggleAction {
        private static final long serialVersionUID = -242928162745443639L;
        private Mode mode;
        private List<SubscriptionToggleAction> toggleActions;

        public SubscriptionToggleAction(String title, Mode mode) {
            super(title);
            this.mode = mode;
        }

        @Override
        public void turnOn() {
            SubscriptionFilterableMarkerRenderer.this.mode = this.mode;
            SubscriptionFilterableMarkerRenderer.this.turnOn();
            for (SubscriptionToggleAction action : this.toggleActions) {
                action.setSelected(false);
            }
        }

        @Override
        public void turnOff() {
            SubscriptionFilterableMarkerRenderer.this.turnOff();
        }
    }

    protected static class DummyPointRenderer
    extends AbstractRenderer<DefaultRendererProperties, ImmutablePoint, SubscriptionLocationObject>
    implements PointRenderer<DefaultRendererProperties, SubscriptionLocationObject> {
        protected SubscriptionFilterableMarkerRenderer renderer;
        private boolean showHouseNumber = false;

        protected DummyPointRenderer() {
        }

        @Override
        public DefaultRendererProperties createRendererProperties(SubscriptionLocationObject u) {
            return new DefaultRendererProperties();
        }

        @Override
        public void render(Graphics2D g2d, SubscriptionLocationObject object, ImmutablePoint geom, DefaultRendererProperties rendererProperties) {
            double upp = rendererProperties.getUpp();
            double margin = 10.0 * Math.pow(upp, -0.2) * upp;
            this.renderer.areaPointRenderer = new AreaPointRenderer(g2d, upp, geom.getCoordinateFactory());
            Color colorOfAreaObject = Color.WHITE;
            AreaObjectModel areaObject = ((SubscriptionModel)object.getModel()).getAreaObject();
            if (areaObject != null && (colorOfAreaObject = (Color)this.renderer.areaObjectColorCache.get(areaObject)) == null) {
                colorOfAreaObject = (Color)this.renderer.cyclingColorIterator.next();
                this.renderer.areaObjectColorCache.put(areaObject, colorOfAreaObject);
            }
            colorOfAreaObject = new Color(colorOfAreaObject.getRed(), colorOfAreaObject.getGreen(), colorOfAreaObject.getBlue(), 150);
            if (this.renderer.getMarkedObjects().contains(object)) {
                colorOfAreaObject = ObjectMarkerNavigatorRenderer.MARK_COLOR;
            }
            geom = this.getToThePoint(object, geom);
            RendererNode node = this.createRendererNode(object, geom, margin, colorOfAreaObject);
            this.renderer.areaPointRenderer.drawBuilding(node, false);
            this.renderer.drawedSubscriptionsOnMap.put(object, new Tupel<ImmutablePoint, Double>(geom, margin));
        }

        protected RendererNode createRendererNode(SubscriptionLocationObject object, ImmutablePoint geom, double margin, Color colorOfAreaObject) {
            String string = null;
            if (this.showHouseNumber) {
                LocationModel location = ((SubscriptionModel)object.getModel()).getLocation();
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                string = FormUtil.getStringDisplay(locationWrapper.getHousenumber() == null ? null : String.valueOf(locationWrapper.getHousenumber())) + FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
            }
            return new RendererNode(string, geom.getCoordinate(), DummyPointRenderer.getFrameColor((SubscriptionModel)object.getModel()), colorOfAreaObject, margin);
        }

        protected ImmutablePoint getToThePoint(SubscriptionLocationObject object, ImmutablePoint geom) {
            return geom;
        }

        public static Color getFrameColor(SubscriptionModel model) {
            Color frameColor = null;
            frameColor = !SubscriptionModelUtil.isCurrentDateInTimeRange(model) ? Color.BLACK : (!SubscriptionModelUtil.isActive(model) || SubscriptionModelUtil.isCurrentDateInBreakTime(model) ? Color.RED : (SubscriptionModelUtil.isCurrentDaySelected(model) ? MARK_GREEN_COLOR : Color.CYAN));
            return frameColor;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Dimension getOptimalPreviewDimension() {
            return new Dimension(10, 10);
        }

        public void setSubscriptionRenderer(SubscriptionFilterableMarkerRenderer subscriptionRenderer) {
            this.renderer = subscriptionRenderer;
            if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("subscription.renderer.houseNumber.show"))) {
                this.showHouseNumber = true;
            }
        }

        @Override
        public void render(Graphics2D g2d, SubscriptionLocationObject u, Collection<ImmutablePoint> geom, DefaultRendererProperties rendererProperties) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }
    }

    public static enum Mode {
        ALL,
        ACTIVE,
        INACTIVE;

    }
}

