/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.subscription;

import de.datomino.peppergis.client.data.DataManagerAccess;
import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.location.ImportedLocationAddressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.gui.subscription.BasicSubscriptionPane;
import de.datomino.peppergis.client.gui.subscription.SubscriptionAttributeValuePane;
import de.datomino.peppergis.client.gui.subscription.SubscriptionBreakTimePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicArrowButton;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public class SubscriptionDialog
extends CommonDialog
implements Pausable {
    private static final long serialVersionUID = 7701393906002917081L;
    private List<SubscriptionModel> subscriptions;
    private int currentIndex = 0;
    private ModelEnviroment modelEnviroment;
    private BasicSubscriptionPane basicSubscriptionPane;
    private List<SubscriptionAttributeValuePane> subscriptionAttributeValuePanes;
    private ParcelAddressPane parcelAddressPane;
    private ImportedLocationAddressPane importedLocationAddressPane;
    private SubscriptionBreakTimePane subscriptionBreakTimePane;
    private PausableInternalFrame internalFrame;
    private Map<ParcelModel, ValueChangeListener> valueChangeListeners;

    public SubscriptionDialog(Window parent, List<SubscriptionModel> subscriptions, ModelEnviroment modelEnviroment) {
        super((Component)parent, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.subscriptions = subscriptions;
        this.modelEnviroment = modelEnviroment;
        this.valueChangeListeners = new HashMap<ParcelModel, ValueChangeListener>();
        this.buildLayout();
        for (final SubscriptionModel subscription : subscriptions) {
            LocationModel location = subscription.getLocation();
            final ParcelModel parcel = location.getParcel();
            if (parcel == null) continue;
            ValueChangeListener listener = new ValueChangeListener(){

                @Override
                public void valueChanged(ValueChangeEvent e) {
                    if (subscription.equals(SubscriptionDialog.this.getCurrentSubscription()) && SubscriptionDialog.this.parcelAddressPane != null) {
                        SubscriptionDialog.this.parcelAddressPane.setParcel(parcel);
                    }
                }
            };
            parcel.addValueChangeListener(listener);
            this.valueChangeListeners.put(parcel, listener);
        }
        if (this.subscriptions.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            if (this.importedLocationAddressPane != null) {
                this.importedLocationAddressPane.centerCoord();
            }
            if (this.parcelAddressPane != null) {
                this.parcelAddressPane.centerCoord();
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setTitle(this.subscriptions.get(this.currentIndex).getSubscriptionNumber());
        this.pack();
        this.setDefaultCloseOperation(2);
        SwingUtils.centerDialog(this, this.getParent());
        if (visible) {
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.setVisible(visible);
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4578396289778907053L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SubscriptionDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel addressComponent;
        JTabbedPane tabbedPane = new JTabbedPane();
        SubscriptionModel subscription = this.subscriptions.get(this.currentIndex);
        boolean modifiable = SubscriptionModelUtil.isSubscriptionModifiable(subscription);
        this.basicSubscriptionPane = new BasicSubscriptionPane(subscription, this.modelEnviroment);
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.common", new Serializable[0]), this.basicSubscriptionPane);
        LocationModel location = subscription.getLocation();
        ParcelModel parcel = location.getParcel();
        if (parcel == null) {
            this.importedLocationAddressPane = new ImportedLocationAddressPane(location.getImportedLocation(), this.modelEnviroment, false, true);
            addressComponent = this.importedLocationAddressPane;
        } else {
            addressComponent = this.parcelAddressPane = new ParcelAddressPane(parcel, this.modelEnviroment, false, false);
        }
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.address", new Serializable[0]), addressComponent);
        this.subscriptionBreakTimePane = new SubscriptionBreakTimePane(subscription);
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime", new Serializable[0]), this.subscriptionBreakTimePane);
        Collection<AttributeGroupModel> groups = this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(AttributeGroupType.SUBSCRIPTION);
        this.subscriptionAttributeValuePanes = new ArrayList<SubscriptionAttributeValuePane>(groups.size());
        for (AttributeGroupModel group : groups) {
            SubscriptionAttributeValuePane subscriptionAttributeValuePane = new SubscriptionAttributeValuePane(subscription, Collections.singleton(group), this.modelEnviroment);
            subscriptionAttributeValuePane.fillValues(subscription);
            this.subscriptionAttributeValuePanes.add(subscriptionAttributeValuePane);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)subscriptionAttributeValuePane, "North");
            tabbedPane.add(group.getName(), new JScrollPane(panel));
        }
        this.setEnabled(modifiable);
        return tabbedPane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -6675080622780941906L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = SubscriptionDialog.this.modelEnviroment.getUndoManager();
                undoManager.joinTransaction();
                undoManager.startTransaction();
                SubscriptionDialog.this.basicSubscriptionPane.adaptValuesToModel();
                for (SubscriptionAttributeValuePane subscriptionAttributeValuePane : SubscriptionDialog.this.subscriptionAttributeValuePanes) {
                    subscriptionAttributeValuePane.adaptValuesToModel((Model)SubscriptionDialog.this.subscriptions.get(SubscriptionDialog.this.currentIndex));
                }
                if (SubscriptionDialog.this.importedLocationAddressPane != null) {
                    SubscriptionDialog.this.importedLocationAddressPane.adaptValuesToModel();
                }
                if (SubscriptionDialog.this.parcelAddressPane != null) {
                    try {
                        SubscriptionDialog.this.parcelAddressPane.adaptValuesToModel(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (SubscriptionDialog.this.subscriptionBreakTimePane != null) {
                    SubscriptionDialog.this.subscriptionBreakTimePane.adaptValuesToModel();
                }
                SubscriptionDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.attributesChanged", new Serializable[]{((SubscriptionModel)SubscriptionDialog.this.subscriptions.get(SubscriptionDialog.this.currentIndex)).getSubscriptionNumber()}));
                SubscriptionDialog.this.dispose();
            }
        };
    }

    private JPanel createControlPanel() {
        this.setTitle(this.subscriptions.get(this.currentIndex).getSubscriptionNumber());
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SubscriptionDialog.this.nextSubscription(-1);
            }
        });
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(this.currentIndex + 1 + "/" + this.subscriptions.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SubscriptionDialog.this.nextSubscription(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void nextSubscription(int step) {
        this.currentIndex += step;
        if (this.currentIndex < 0) {
            this.currentIndex = this.subscriptions.size() - 1;
        } else if (this.currentIndex > this.subscriptions.size() - 1) {
            this.currentIndex = 0;
        }
        this.getContentPane().removeAll();
        this.buildLayout();
        this.add((Component)this.createControlPanel(), "First");
        this.pack();
    }

    public void setLocallyEnabled(boolean b) {
        this.basicSubscriptionPane.setEnabled(b);
        for (SubscriptionAttributeValuePane subscriptionAttributeValuePane : this.subscriptionAttributeValuePanes) {
            subscriptionAttributeValuePane.setEnabled(b);
        }
        if (this.parcelAddressPane != null) {
            this.parcelAddressPane.setEnabled(b);
        }
        if (this.subscriptionBreakTimePane != null) {
            this.subscriptionBreakTimePane.setEnabled(b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.importedLocationAddressPane != null) {
            this.importedLocationAddressPane.setEnabled(b);
        }
        this.setLocallyEnabled(b);
    }

    private SubscriptionModel getCurrentSubscription() {
        return this.subscriptions.get(this.currentIndex);
    }

    @Override
    protected Action[] getAdditionalActions() {
        Action[] actions2;
        Action[] superActions = super.getAdditionalActions();
        if (this.isExternalEditEnabled() && DataManagerAccess.isModelAllowedToEdit()) {
            actions2 = new Action[superActions.length + 1];
            System.arraycopy(superActions, 0, actions2, 0, superActions.length);
            actions2[actions2.length - 1] = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0])){
                private static final long serialVersionUID = 1508001147833279482L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SubscriptionDialog.this.internalFrame != null) {
                        SubscriptionDialog.this.internalFrame.pause(SubscriptionDialog.this);
                    }
                    DataManagerAccess.showModel(ModelEnviroment.getDesktopClientApplication(), SubscriptionDialog.this.getCurrentSubscription());
                    if (SubscriptionDialog.this.internalFrame != null) {
                        SubscriptionDialog.this.internalFrame.unlockResume();
                    }
                }
            };
        } else {
            actions2 = superActions;
        }
        return actions2;
    }

    public void setInternalFrame(PausableInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    protected boolean isExternalEditEnabled() {
        return true;
    }

    @Override
    public void pause() {
        this.setVisible(false);
    }

    @Override
    public void resume() {
        this.setVisible(true);
    }

    @Override
    protected boolean close() {
        for (Map.Entry<ParcelModel, ValueChangeListener> entry : this.valueChangeListeners.entrySet()) {
            entry.getKey().removeValueChangeListener(entry.getValue());
        }
        return super.close();
    }
}

