/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.subscription;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.AreaObjectComboBox;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.ktde.util.StringUtil;

public class BasicSubscriptionPane
extends JPanel {
    private static final long serialVersionUID = -3647790887499691564L;
    private SubscriptionModel subscriptionModel;
    private JTextField subscriptionNumber;
    private JTextArea information;
    private JComboBox status;
    private AreaObjectComboBox area;
    private AreaLayerComboBox layer;
    private ModelEnviroment modelEnviroment;
    private EnumComboBox<SubscriptionDeliveryType> subscriptionDeliveryType;
    private JFormattedTextField startDate;
    private JFormattedTextField endDate;
    private JCheckBox monday;
    private JCheckBox tuesday;
    private JCheckBox wednesday;
    private JCheckBox thursday;
    private JCheckBox friday;
    private JCheckBox saturday;
    private JCheckBox sunday;
    private JTextField customerNumber;
    private JCheckBox company;
    private JTextField companyName;
    private JTextField firstName;
    private JTextField lastName;

    public BasicSubscriptionPane(SubscriptionModel subscriptionModel, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.subscriptionModel = subscriptionModel;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.setSubscriptionModel(subscriptionModel);
    }

    public void setSubscriptionModel(SubscriptionModel subscriptionModel) {
        this.subscriptionModel = subscriptionModel;
        if (this.subscriptionModel == null) {
            this.subscriptionNumber.setText("");
            this.information.setText("");
            this.status.setSelectedIndex(0);
            this.area.setSelectedIndex(0);
            this.layer.setSelectedIndex(0);
            this.subscriptionDeliveryType.setSelectedValue(SubscriptionDeliveryType.OWN);
            Date now = new Date();
            this.startDate.setValue(now);
            this.endDate.setValue(now);
            this.monday.setSelected(false);
            this.tuesday.setSelected(false);
            this.wednesday.setSelected(false);
            this.thursday.setSelected(false);
            this.friday.setSelected(false);
            this.saturday.setSelected(false);
            this.sunday.setSelected(false);
            this.customerNumber.setText("");
            this.company.setSelected(false);
            this.companyName.setText("");
            this.firstName.setText("");
            this.lastName.setText("");
        } else {
            this.subscriptionNumber.setText(this.subscriptionModel.getSubscriptionNumber());
            this.information.setText(this.subscriptionModel.getInformation());
            this.information.setCaretPosition(0);
            int toSelect = 0;
            for (int i = 0; i < this.status.getItemCount(); ++i) {
                EnumItem enumItem = (EnumItem)this.status.getItemAt(i);
                if (enumItem.getT() != this.subscriptionModel.getStatus()) continue;
                toSelect = i;
                break;
            }
            this.status.setSelectedIndex(toSelect);
            AreaObjectModel areaObjectModel = this.subscriptionModel.getAreaObject();
            AreaLayerModel areaLayerModel = this.subscriptionModel.getAreaLayer();
            if (areaObjectModel == null) {
                this.layer.setSelectedIndex(0);
                if (areaLayerModel == null) {
                    this.area.setSelectedIndex(0);
                } else {
                    this.layer.setSelectedItem(areaLayerModel);
                }
            } else {
                areaLayerModel = areaObjectModel.getAreaLayer();
                this.layer.setSelectedItem(areaLayerModel);
                this.area.setSelectedItem(areaObjectModel);
            }
            SubscriptionDeliveryType deliveryType = this.subscriptionModel.getDeliveryType();
            if (deliveryType == null) {
                deliveryType = SubscriptionDeliveryType.OWN;
            }
            this.subscriptionDeliveryType.setSelectedValue(deliveryType);
            this.startDate.setValue(this.subscriptionModel.getStartDate());
            this.endDate.setValue(this.subscriptionModel.getEndDate());
            this.monday.setSelected(this.subscriptionModel.getMonday());
            this.tuesday.setSelected(this.subscriptionModel.getTuesday());
            this.wednesday.setSelected(this.subscriptionModel.getWednesday());
            this.thursday.setSelected(this.subscriptionModel.getThursday());
            this.friday.setSelected(this.subscriptionModel.getFriday());
            this.saturday.setSelected(this.subscriptionModel.getSaturday());
            this.sunday.setSelected(this.subscriptionModel.getSunday());
            CustomerModel customer = this.subscriptionModel.getCustomer();
            if (customer != null) {
                this.customerNumber.setText(StringUtil.nullToEmpty(customer.getCustomerNumber()));
                boolean company = PrimitiveUtil.nullToFalse(customer.getCompany());
                this.company.setSelected(company);
                this.companyName.setText(StringUtil.nullToEmpty(customer.getCompanyName()));
                this.firstName.setText(StringUtil.nullToEmpty(customer.getFirstName()));
                this.lastName.setText(StringUtil.nullToEmpty(customer.getLastName()));
            } else {
                this.customerNumber.setText("");
                this.company.setSelected(false);
                this.companyName.setText("");
                this.firstName.setText("");
                this.lastName.setText("");
            }
        }
    }

    public void adaptValuesToModel() {
        if (this.subscriptionModel != null) {
            this.subscriptionModel.setInformation(this.information.getText());
            EnumItem enumItem = (EnumItem)this.status.getSelectedItem();
            this.subscriptionModel.setStatus((SubscriptionStatus)((Object)enumItem.getT()));
            AreaObjectModel areaObject = (AreaObjectModel)this.area.getSelectedItem();
            this.subscriptionModel.setAreaObject(areaObject);
            this.subscriptionModel.setDeliveryType(this.subscriptionDeliveryType.getSelectedValue());
            Date startDateValue = (Date)this.startDate.getValue();
            if (startDateValue != null) {
                startDateValue = TimeUtil.normalize(startDateValue);
            }
            this.subscriptionModel.setStartDate(startDateValue);
            Date enddateValue = (Date)this.endDate.getValue();
            if (enddateValue != null) {
                enddateValue = TimeUtil.setTime(enddateValue, 23, 59, 59);
            }
            this.subscriptionModel.setEndDate(enddateValue);
            this.subscriptionModel.setMonday(this.monday.isSelected());
            this.subscriptionModel.setTuesday(this.tuesday.isSelected());
            this.subscriptionModel.setWednesday(this.wednesday.isSelected());
            this.subscriptionModel.setThursday(this.thursday.isSelected());
            this.subscriptionModel.setFriday(this.friday.isSelected());
            this.subscriptionModel.setSaturday(this.saturday.isSelected());
            this.subscriptionModel.setSunday(this.sunday.isSelected());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.information.setEnabled(enabled);
        this.status.setEnabled(enabled);
        this.area.setEnabled(enabled);
        this.subscriptionDeliveryType.setEnabled(enabled);
        this.startDate.setEditable(enabled);
        this.endDate.setEditable(enabled);
        this.monday.setEnabled(enabled);
        this.tuesday.setEnabled(enabled);
        this.wednesday.setEnabled(enabled);
        this.thursday.setEnabled(enabled);
        this.friday.setEnabled(enabled);
        this.saturday.setEnabled(enabled);
        this.sunday.setEnabled(enabled);
    }

    private void buildLayout() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel mainPanel = new JPanel(new SpringLayout());
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptionNumber", new Serializable[0])));
        this.subscriptionNumber = new JTextField(30);
        this.subscriptionNumber.setEditable(false);
        mainPanel.add(this.subscriptionNumber);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.customerNumber", new Serializable[0])));
        this.customerNumber = new JTextField(30);
        this.customerNumber.setEditable(false);
        mainPanel.add(this.customerNumber);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.cutomer.isCompany", new Serializable[0])));
        this.company = new JCheckBox();
        this.company.setEnabled(false);
        mainPanel.add(this.company);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.companyName", new Serializable[0])));
        this.companyName = new JTextField(30);
        this.companyName.setEditable(false);
        mainPanel.add(this.companyName);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.firstName", new Serializable[0])));
        this.firstName = new JTextField(30);
        this.firstName.setEditable(false);
        mainPanel.add(this.firstName);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.lastName", new Serializable[0])));
        this.lastName = new JTextField(30);
        this.lastName.setEditable(false);
        mainPanel.add(this.lastName);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.status", new Serializable[0])));
        Vector<EnumItem<SubscriptionStatus>> vector = new Vector<EnumItem<SubscriptionStatus>>(SubscriptionStatus.values().length);
        for (SubscriptionStatus subscriptionStatus : SubscriptionStatus.values()) {
            vector.addElement(new EnumItem<SubscriptionStatus>(subscriptionStatus));
        }
        this.status = new JComboBox(vector);
        mainPanel.add(this.status);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
        this.layer = new AreaLayerComboBox(this.modelEnviroment, true, AreaObjectGenInfoDiscriminator.values(), false, false);
        this.layer.setEnabled(false);
        this.layer.addActionListener(new LayerActionListener());
        mainPanel.add(this.layer);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0])));
        this.area = new AreaObjectComboBox(true){
            private static final long serialVersionUID = 3101821871856266950L;

            @Override
            protected String getStringRepresentation(AreaObjectModel t) {
                return AreaObjectModelUtil.getShortcutAndDisplayname(t);
            }
        };
        mainPanel.add(this.area);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(SubscriptionDeliveryType.class.getName(), new Serializable[0])));
        this.subscriptionDeliveryType = new EnumComboBox<SubscriptionDeliveryType>(SubscriptionDeliveryType.class, false);
        mainPanel.add(this.subscriptionDeliveryType);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.validityTime", new Serializable[0])));
        JPanel subPanel = new JPanel(new SpringLayout());
        this.startDate = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        subPanel.add(this.startDate);
        this.endDate = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        subPanel.add(this.endDate);
        SpringUtilities.makeCompactGrid(subPanel, 1, 2, 0, 0, 20, 0);
        mainPanel.add(subPanel);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.weekdays", new Serializable[0])));
        subPanel = new JPanel(new SpringLayout());
        this.monday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday.short", new Serializable[0]));
        subPanel.add(this.monday);
        this.tuesday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday.short", new Serializable[0]));
        subPanel.add(this.tuesday);
        this.wednesday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday.short", new Serializable[0]));
        subPanel.add(this.wednesday);
        this.thursday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday.short", new Serializable[0]));
        subPanel.add(this.thursday);
        this.friday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday.short", new Serializable[0]));
        subPanel.add(this.friday);
        this.saturday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday.short", new Serializable[0]));
        subPanel.add(this.saturday);
        this.sunday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday.short", new Serializable[0]));
        subPanel.add(this.sunday);
        SpringUtilities.makeCompactGrid(subPanel, 1, 7, 0, 0, 2, 2);
        mainPanel.add(subPanel);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]));
        label.setVerticalAlignment(1);
        mainPanel.add(label);
        this.information = new JTextArea(5, 30);
        mainPanel.add(new JScrollPane(this.information));
        SpringUtilities.makeCompactGrid(mainPanel, 13, 2, 5, 5, 2, 2);
        outerPanel.add((Component)mainPanel, "West");
        this.add((Component)outerPanel, "North");
    }

    private class LayerActionListener
    implements ActionListener {
        private LayerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerModel newLayer = (AreaLayerModel)BasicSubscriptionPane.this.layer.getSelectedItem();
            if (newLayer == null) {
                BasicSubscriptionPane.this.area.setModels(null);
            } else {
                AreaLayerModel currentLayer;
                AreaObjectModel selectedItem = (AreaObjectModel)BasicSubscriptionPane.this.area.getSelectedItem();
                AreaLayerModel areaLayerModel = currentLayer = selectedItem == null ? null : selectedItem.getAreaLayer();
                if (!PrimitiveUtil.equalsNullSafe(currentLayer, newLayer)) {
                    DefaultComboBoxModel dcm = (DefaultComboBoxModel)BasicSubscriptionPane.this.area.getModel();
                    dcm.removeAllElements();
                    ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(newLayer.countAreaObjects());
                    for (AreaObjectModel areaObject : newLayer.iterableAreaObjects()) {
                        list.add(areaObject);
                    }
                    Collections.sort(list, ComparatorUtils.chainedComparator(ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                        @Override
                        public Object transform(Object input) {
                            return StringUtil.nullToEmpty(((AreaObjectModel)input).getShortcut());
                        }
                    }), ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                        @Override
                        public Object transform(Object input) {
                            return StringUtil.nullToEmpty(((AreaObjectModel)input).getDisplayname());
                        }
                    })));
                    dcm.addElement("");
                    for (AreaObjectModel areaObjectModel : list) {
                        dcm.addElement(areaObjectModel);
                    }
                }
            }
        }
    }
}

