/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.stop;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.AbstractLayerRenderer;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;

public class StopLayerRenderer
extends AbstractLayerRenderer {
    private List<StopModel> stops;
    private List<PoiModel> pois;

    public StopLayerRenderer(boolean active, ModelEnviroment modelEnviroment) {
        this(active, false, modelEnviroment);
    }

    public StopLayerRenderer(boolean active, boolean withIndex, ModelEnviroment modelEnviroment) {
        super(active, withIndex, null, modelEnviroment);
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>> set;
        ImmutableLineString bikeLineString;
        SegmentModel bikeSegment;
        ImmutableLineString footLineString;
        SegmentModel footSegment;
        ImmutableLineString motorLineString;
        SegmentModel motorSegment;
        LocationWrapper wrapper;
        LocationModel location;
        HashMap<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>> map = new HashMap<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>>();
        for (StopModel stop : this.stops) {
            location = stop.getLocation();
            if (location == null) continue;
            wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            motorSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.MOTORCAR, this.modelEnviroment);
            motorLineString = motorSegment == null ? null : motorSegment.getGeom();
            footSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.FOOT, this.modelEnviroment);
            footLineString = footSegment == null ? null : footSegment.getGeom();
            bikeSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.BIKE, this.modelEnviroment);
            bikeLineString = bikeSegment == null ? null : bikeSegment.getGeom();
            set = (HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>)map.get(wrapper.getGeoLocation());
            if (set == null) {
                set = new HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>();
                map.put(wrapper.getGeoLocation(), set);
            }
            set.add(new Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>(motorLineString, footLineString, bikeLineString));
        }
        for (PoiModel poi : this.pois) {
            location = poi.getLocation();
            if (location == null) continue;
            wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            motorSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.MOTORCAR, this.modelEnviroment);
            motorLineString = motorSegment == null ? null : motorSegment.getGeom();
            footSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.FOOT, this.modelEnviroment);
            footLineString = footSegment == null ? null : footSegment.getGeom();
            bikeSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.BIKE, this.modelEnviroment);
            bikeLineString = bikeSegment == null ? null : bikeSegment.getGeom();
            set = (Set)map.get(wrapper.getGeoLocation());
            if (set == null) {
                set = new HashSet();
                map.put(wrapper.getGeoLocation(), set);
            }
            set.add(new Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>(motorLineString, footLineString, bikeLineString));
        }
        this.drawSegments(map, g2d, upp);
        DefaultPointRenderer pointRenderer = new DefaultPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory());
        double margin = 20.0 * Math.pow(upp, -0.2) * upp;
        pointRenderer.drawStops(this.stops, margin, null, this.withIndex);
        pointRenderer.drawPois(this.pois, margin, this.withIndex);
        return Collections.emptyList();
    }

    public void setStops(List<StopModel> stops) {
        this.stops = stops;
    }

    public void setPois(List<PoiModel> pois) {
        this.pois = pois;
    }

    @Override
    public String getName() {
        return "StopLayerRenderer";
    }
}

