/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.stop;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.model.stop.StopLocationObject;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.StringUtil;

public class StopFilterableMarkerRenderer
extends AbstractFilterableMarkerNavigatorRenderer<StopModel, StopLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties, Model> {
    private static final long serialVersionUID = 1496747833828149002L;
    private static final int BOX_WIDTH = 70;
    private Date startTime;
    private Date endTime;

    public StopFilterableMarkerRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<StopLocationObject, ImmutablePoint> bucketsModel) {
        super(name, title, editorPanel.getNavigatorPanel(), null, null, new DummyPointRenderer(), maxUpp, bucketsModel, false);
    }

    @Override
    public void showMarked(Collection<StopLocationObject> markedObjects) {
    }

    @Override
    protected void showClicked(Collection<StopLocationObject> cs) {
    }

    @Override
    protected AbstractFilterPatternSetupRendererSelektor<?, StopModel, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor() {
        return null;
    }

    @Override
    protected void paintSpecialElements(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    protected void drawHover(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, Collection<StopLocationObject> hovers, double upp) {
        if (hovers == null || hovers.isEmpty()) {
            return;
        }
        double margin = this.getNavigatorPanel().getUpp() * 10.0;
        AreaPointRenderer areaPointRenderer = new AreaPointRenderer(g2d, upp, this.getNavigatorPanel().getCoordinateFactory());
        for (StopLocationObject object : hovers) {
            if (object == null) continue;
            this.createInfobox(areaPointRenderer, (StopModel)object.getModel(), margin, object.getImmutablePoint());
        }
    }

    private void createInfobox(AreaPointRenderer areaPointRenderer, StopModel stopModel, double margin, ImmutablePoint geom) {
        String clientName;
        ArrayList<String> infoBox = new ArrayList<String>();
        CustomerModel customer = null;
        Iterator<ServiceTicketStopRelationModel> iter = stopModel.iterateServiceStopRelations();
        while (iter.hasNext()) {
            ServiceTicketModel serviceTicket = iter.next().getServiceTicket();
            customer = serviceTicket == null ? null : serviceTicket.getCustomer();
        }
        String string = clientName = customer == null ? "" : StringUtil.nullToEmpty(customer.getName());
        if (clientName.length() > 70) {
            clientName = FormUtil.getStringWithLength(clientName.trim(), 70);
        }
        infoBox.add(clientName);
        String s = stopModel.getInformation() == null ? " " : stopModel.getInformation();
        s = s + (stopModel.getDelivererInformation() == null ? " " : stopModel.getDelivererInformation());
        s = s + (stopModel.getParkingInformation() == null ? " " : stopModel.getParkingInformation());
        if (s.length() > 70) {
            s = FormUtil.getStringWithLength(s.trim(), 70);
        }
        infoBox.add(s);
        areaPointRenderer.drawInfoBox(infoBox, geom.getCoordinate(), Color.RED, margin);
    }

    @Override
    protected int getCycles() {
        return 2;
    }

    @Override
    protected boolean isToDrawObject(StopLocationObject s) {
        Date date;
        StopModel m = s == null ? null : (StopModel)s.getModel();
        Date date2 = date = m == null ? null : m.getEstimatedTimeOfArrival();
        if (this.startTime != null || this.endTime != null) {
            boolean b = false;
            if (date != null) {
                boolean bl = this.startTime == null ? true : (b = !date.before(this.startTime));
                b &= this.endTime == null ? true : !date.after(this.endTime);
            }
            return b;
        }
        return true;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public AbstractFilterableMarkerNavigatorRenderer.RenderObjectType getRenderObjectType() {
        return AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.STOPRENDERER;
    }

    @Override
    protected Iterable<? extends Model> getChangeListeningModels(StopLocationObject s) {
        Iterable<ServiceTicketStopRelationModel> iterableServiceStopRelations = ((StopModel)s.getModel()).iterableServiceStopRelations();
        LinkedList<ServiceTicketStopRelationModel> models = new LinkedList<ServiceTicketStopRelationModel>();
        List<Model> list = CollectionUtil.iterableToList(iterableServiceStopRelations);
        models.addAll(list);
        for (ServiceTicketStopRelationModel serviceTicketStopRelationModel : ((StopModel)s.getModel()).iterableServiceStopRelations()) {
            list = CollectionUtil.iterableToList(serviceTicketStopRelationModel.iterableServiceValues());
            models.addAll(list);
        }
        return models;
    }

    protected static class DummyPointRenderer
    extends AbstractRenderer<DefaultRendererProperties, ImmutablePoint, StopLocationObject>
    implements PointRenderer<DefaultRendererProperties, StopLocationObject> {
        protected DummyPointRenderer() {
        }

        @Override
        public DefaultRendererProperties createRendererProperties(StopLocationObject u) {
            return new DefaultRendererProperties();
        }

        @Override
        public void render(Graphics2D g2d, StopLocationObject stopLocationObject, ImmutablePoint geom, DefaultRendererProperties rendererProperties) {
            double upp = rendererProperties.getUpp();
            double margin = 20.0 * Math.pow(upp, -0.2) * upp;
            AreaPointRenderer areaPointRenderer = new AreaPointRenderer(g2d, upp, geom.getCoordinateFactory());
            geom = this.getToThePoint(stopLocationObject, geom);
            areaPointRenderer.drawCircle(geom.getCoordinate(), margin);
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Dimension getOptimalPreviewDimension() {
            return new Dimension(10, 10);
        }

        @Override
        public void render(Graphics2D g2d, StopLocationObject u, Collection<ImmutablePoint> geom, DefaultRendererProperties rendererProperties) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }

        protected ImmutablePoint getToThePoint(StopLocationObject stopLocationObject, ImmutablePoint geom) {
            return geom;
        }
    }
}

