/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer.editor;

import de.datomino.peppergis.client.gui.renderer.editor.ValueEditor;
import java.awt.Component;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang.builder.ToStringBuilder;

public class IntegerValueEditor
extends ValueEditor<Integer> {
    private static final long serialVersionUID = -804668763638524682L;
    private JSpinner spinner;

    public IntegerValueEditor(Integer value) {
        this(value, 0, 100);
    }

    public IntegerValueEditor(Integer value, Integer minimum, Integer maximum) {
        this(value, minimum, maximum, 0);
    }

    public IntegerValueEditor(Integer value, Integer minimum, Integer maximum, Integer defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        this.spinner = new JSpinner(new SpinnerNumberModel(value, minimum, maximum, 1));
        this.add((Component)this.spinner, "Center");
    }

    @Override
    public Integer getValue() {
        return ((Number)this.spinner.getValue()).intValue();
    }

    @Override
    public void setValue(Integer value) {
        this.spinner.setValue(value);
    }

    @Override
    public String getSerializedValue() {
        Object o = this.spinner.getValue();
        return o == null ? null : o.toString();
    }

    @Override
    public void setSerializedValue(String value) {
        if (value != null) {
            try {
                this.setValue(Integer.valueOf(value));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("value", this.spinner.getValue()).toString();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
    }
}

