/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer.editor;

import de.datomino.peppergis.client.gui.image.ImageChooserDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.editor.ValueEditor;
import de.datomino.peppergis.client.model.base.ImageModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ImageValueEditor
extends ValueEditor<ImageModel> {
    private static final long serialVersionUID = -8000211701125248000L;
    private JButton button;
    private ModelEnviroment modelEnviroment;
    private ImageModel imageModel;

    public ImageValueEditor(ImageModel imageModel, final ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
        this.button = new JButton();
        this.add((Component)this.button, "Center");
        this.setValue(imageModel);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ImageChooserDialog imageChooserDialog = new ImageChooserDialog(ImageValueEditor.this.getParentWindow(), modelEnviroment, false);
                imageChooserDialog.setCallBack(new ImageChooserDialog.CallBack(){

                    @Override
                    public void executeAfterOk() {
                        ImageValueEditor.this.setValue(imageChooserDialog.getSelectedImage());
                    }

                    @Override
                    public void executeAfterCancel() {
                    }
                });
                imageChooserDialog.setVisible(true);
            }
        });
    }

    private Window getParentWindow() {
        Container parent;
        Container currentContainer = this;
        do {
            if (!((parent = currentContainer.getParent()) instanceof Window)) continue;
            return (Window)parent;
        } while ((currentContainer = parent) != null);
        return null;
    }

    @Override
    public String getSerializedValue() {
        if (this.imageModel == null) {
            return null;
        }
        Long id = this.imageModel.getId();
        return id == null ? null : Long.toString(id);
    }

    @Override
    public ImageModel getValue() {
        return this.imageModel;
    }

    @Override
    public void setSerializedValue(String value) {
        try {
            Long id = Long.parseLong(value);
            this.fetchAndSetImageModel(id);
        }
        catch (NumberFormatException ex) {
            this.setValue(null);
        }
        catch (NullPointerException ex) {
            this.setValue(null);
        }
    }

    private void fetchAndSetImageModel(Long id) {
        this.setValue(id == null ? null : this.modelEnviroment.getAllCaller().getBaseCaller().getImageById(id));
    }

    @Override
    public void setValue(ImageModel value) {
        this.imageModel = value;
        if (value == null) {
            this.button.setText("");
        } else {
            this.button.setText(value.getName());
        }
        this.button.repaint(1L);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }
}

