/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer.editor;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.editor.ValueEditor;
import de.datomino.util.geo.swing.PaintUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.border.LineBorder;

public class ColorValueEditor
extends ValueEditor<Color> {
    private static final long serialVersionUID = -6890610894255672053L;
    private Color color;
    private JButton button = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.chooseColor", new Serializable[0])){
        private static final long serialVersionUID = -1501022295075315602L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = JColorChooser.showDialog(ColorValueEditor.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.chooseColor", new Serializable[0]), ColorValueEditor.this.color);
            if (color != null) {
                ColorValueEditor.this.setValue(color);
            }
        }
    });

    public ColorValueEditor(Color value) {
        this.add((Component)this.button, "Center");
        this.setValue(value);
    }

    @Override
    public Color getValue() {
        return this.color;
    }

    @Override
    public void setValue(Color color) {
        this.color = color;
        this.button.setBorder(new LineBorder(color, 4));
    }

    @Override
    public String getSerializedValue() {
        return this.color == null ? null : PaintUtil.getColorString(this.color, false);
    }

    @Override
    public void setSerializedValue(String value) {
        if (value != null) {
            try {
                this.setValue(PaintUtil.extractColor(0, value));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }
}

