/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer.area;

import de.datomino.peppergis.client.gui.area.AreaNameRenderingType;
import de.datomino.peppergis.client.gui.filter.area.AreaFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRendererPrintTypeDecider;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.attribute.AttributeHelper;
import de.datomino.peppergis.client.util.filter.RendererFactory;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueModelAttributeWrapper;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.PropertyUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.swing.AbstractBucketNavigatorMouseManipulatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.Renderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaLayerRenderer
extends AbstractBucketNavigatorMouseManipulatorRenderer<AreaObjectModel, ImmutablePolygonKind> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaLayerRenderer.class);
    private static AreaNameRenderingType areaNameRenderingType;
    private String areaNameRenderingPattern = null;
    private static Double bucketSize;
    private List<AreaObjectModel> currentAreaObjects = new ArrayList<AreaObjectModel>();
    private AntRunner antRunner;
    private double maxShortCutUpp = 4.0;
    private double maxMarkIconUpp = 4.0;
    private double maxMarkCircleUpp = 256.0;
    private AreaFilterPatternSetupRendererSelektor areaFilterPatternSetupRendererSelektor;
    private boolean emphasizeSelected = true;
    private Collection<AreaLayerModel> allowedAreaLayers;
    private Rectangle2D.Double selectedRectangle;
    private AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider;
    private Font font;
    private boolean reduceGeom;
    private Map<AreaObjectModel, List<Tupel<Double, DetaillessAreaObjectGeometryModel>>> detaillessMap = new HashMap<AreaObjectModel, List<Tupel<Double, DetaillessAreaObjectGeometryModel>>>();
    private Set<AreaObjectModel> changedAreaObjectsForDetailless = new HashSet<AreaObjectModel>();
    private ModelEnviroment modelEnviroment;
    private DetaillessAreaObjectGeometryModelValueChangeListener detaillessAreaObjectGeometryModelValueChangeListener = new DetaillessAreaObjectGeometryModelValueChangeListener();
    private List<AreaAttributeValueDescriptorModel> overlayDescriptors;
    private boolean drawAreaHover = true;
    private boolean drawAntLineActive = true;
    private Set<ObjectFilter<AreaFilterModel, AttributeValueFilterModel>> invisibleFilters;
    private double markRadiusInPixel = 5.0;
    private static Image areaInfoimage;
    private boolean islandMode = false;

    protected AreaLayerRenderer(String name, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel, double minUpp, double maxUpp, AreaRenderer<?, AreaObjectModel> areaRenderer, LineRenderer<?, AreaObjectModel> lineRenderer, AreaRenderer<?, AreaObjectModel> markAreaRenderer, Double maxShortCutUpp, boolean reduceGeom, ModelEnviroment modelEnviroment, GeomExtractor<AreaObjectModel, ImmutablePolygonKind> geomExtractor, NavigatorPanel navigatorPanel, List<AreaAttributeValueDescriptorModel> overlayDescriptors) {
        super(name, bucketsModel, minUpp, maxUpp, areaRenderer, lineRenderer, null, geomExtractor, navigatorPanel);
        this.reduceGeom = reduceGeom;
        this.modelEnviroment = modelEnviroment;
        if (maxShortCutUpp != null) {
            this.maxShortCutUpp = maxShortCutUpp;
        }
        this.overlayDescriptors = overlayDescriptors;
        String drawHoverString = ModelEnviroment.getProperties().getProperty("area.renderer.drawHover");
        try {
            this.drawAreaHover = StringUtil.isBlank(drawHoverString) || StringUtil.isTrue(drawHoverString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String drawAntLineString = ModelEnviroment.getProperties().getProperty("area.renderer.drawAntLine");
        try {
            this.drawAntLineActive = StringUtil.isTrue(drawAntLineString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String maxMarkIconUppString = ModelEnviroment.getProperties().getProperty("area.renderer.maxInfoIconUpp");
        try {
            this.maxMarkIconUpp = Double.parseDouble(maxMarkIconUppString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String maxMarkCircleUppString = ModelEnviroment.getProperties().getProperty("area.renderer.maxInfoCircleUpp");
        try {
            this.maxMarkCircleUpp = Double.parseDouble(maxMarkCircleUppString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.overlayDescriptors = overlayDescriptors;
    }

    @Override
    public <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> Collection<Tripel<AreaRenderer<U, AreaObjectModel>, LineRenderer<V, AreaObjectModel>, PointRenderer<W, AreaObjectModel>>> getRenderersForModel(AreaObjectModel model, int cycle) {
        return this.getRenderersForModel(model, cycle, this.emphasizeSelected, false);
    }

    public <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> Collection<Tripel<AreaRenderer<U, AreaObjectModel>, LineRenderer<V, AreaObjectModel>, PointRenderer<W, AreaObjectModel>>> getRenderersForModel(AreaObjectModel model, int cycle, boolean emphazised, boolean ignoreFilter) {
        Collection renderers;
        if (ignoreFilter || this.areaFilterPatternSetupRendererSelektor == null) {
            renderers = super.getRenderersForModel(model, cycle);
        } else {
            List areaRenderers = this.areaFilterPatternSetupRendererSelektor.getRenderers(model);
            ArrayList list = new ArrayList(areaRenderers.size());
            LineRenderer lineRenderer = this.getLineRenderer();
            for (Renderer renderer : areaRenderers) {
                if (renderer == null) continue;
                AreaRenderer areaRenderer = (AreaRenderer)renderer;
                list.add(new Tripel(areaRenderer, lineRenderer, null));
            }
            renderers = list;
        }
        if (emphazised && this.currentAreaObjects.contains(model)) {
            for (Tripel tripel : renderers) {
                AreaRenderer<AreaObjectModel, AreaObjectModel> renderer;
                if (tripel == null || (renderer = tripel.getElement1()) == null) continue;
                AreaRenderer<RendererProperties, AreaObjectModel> emphazise = renderer.emphazise(model);
                tripel.setElement1(emphazise);
            }
        }
        return renderers;
    }

    @Override
    public boolean isAllowed(AreaObjectModel model) {
        return this.allowedAreaLayers == null || this.allowedAreaLayers.contains(model.getAreaLayer());
    }

    @Override
    public synchronized Collection<OnTopRendering> paintOnto(final Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, final double upp) {
        if (this.islandMode) {
            this.drawWhiteForMap(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        }
        if (!this.isActive() || upp > this.getMaxUpp() || upp < this.getMinUpp()) {
            return Collections.emptyList();
        }
        Collection<OnTopRendering> onTops = super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        if (this.emphasizeSelected && upp <= 64.0) {
            for (AreaObjectModel areaObjectModel : this.currentAreaObjects) {
                ImmutablePolygonKind geom = this.getGeomToPaint(areaObjectModel, upp);
                if (geom == null) continue;
                ImmutablePolygonKind poly = (ImmutablePolygonKind)geom.getTransformed(this.getPanel().getCoordinateFactory());
                if (poly instanceof ImmutableMultiPolygon) {
                    for (ImmutablePolygon immutablePolygon : ((ImmutableMultiPolygon)poly).getParts()) {
                        this.drawAntLine(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp, immutablePolygon);
                    }
                    continue;
                }
                this.drawAntLine(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp, (ImmutablePolygon)poly);
            }
        }
        if (this.drawAreaHover) {
            OnTopRendering onTopRendering = new OnTopRendering(){

                @Override
                public void paint() {
                    Double distLimit = null;
                    if (upp <= AreaLayerRenderer.this.maxMarkIconUpp) {
                        distLimit = (double)areaInfoimage.getWidth(null) / 2.0;
                    } else if (upp <= AreaLayerRenderer.this.maxMarkCircleUpp) {
                        distLimit = AreaLayerRenderer.this.markRadiusInPixel;
                    }
                    AreaPointRenderer areaPointRenderer = null;
                    double margin = 10.0 * Math.pow(upp, -0.2) * upp;
                    if (AreaLayerRenderer.this.selectedRectangle != null) {
                        areaPointRenderer = new AreaPointRenderer(g2d, upp, AreaLayerRenderer.this.getCoordinateFactory());
                        RendererNode node = new RendererNode(null, null, Color.BLACK, null, margin);
                        node.setType(RendererType.DASH_LINE);
                        areaPointRenderer.drawShape(AreaLayerRenderer.this.selectedRectangle, node, margin / 10.0);
                    }
                    if (distLimit != null) {
                        Collection hover = AreaLayerRenderer.this.getHover();
                        Coordinate coord = AreaLayerRenderer.this.getMouseNow();
                        if (hover != null && coord != null) {
                            AreaObjectModel area = null;
                            double minDist = Double.MAX_VALUE;
                            NavigatorPanel panel = AreaLayerRenderer.this.getPanel();
                            Point2D.Double mouseNowPixel = panel.getPixel(coord);
                            double mouseNowX = mouseNowPixel.getX();
                            double mouseNowY = mouseNowPixel.getY();
                            for (AreaObjectModel model : hover) {
                                Collection<ImmutablePoint> mPoints = GeoUtils.findCenterPointInPolygonKind(model.getGeom(), true);
                                for (ImmutablePoint point : mPoints) {
                                    double ty;
                                    Point2D.Double mPixel = panel.getPixel(point.getCoordinate());
                                    double tx = mPixel.getX() - mouseNowX;
                                    double cDist = Math.sqrt(tx * tx + (ty = mPixel.getY() - mouseNowY) * ty);
                                    if (!(cDist <= distLimit) || !(cDist < minDist)) continue;
                                    minDist = cDist;
                                    area = model;
                                }
                            }
                            if (area != null) {
                                ArrayList<String> infoBox = new ArrayList<String>(AreaLayerRenderer.this.overlayDescriptors.size() + 4);
                                String shortCutKey = area.getAreaLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.shortcut.order" : "messages.area.shortcut";
                                infoBox.add(ModelEnviroment.getMessageResolver().resolveMessage(shortCutKey, new Serializable[0]) + ": " + area.getShortcut());
                                infoBox.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]) + ": " + area.getDisplayname());
                                infoBox.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + ": " + area.countAreaObjectParcelRel());
                                PoiModel poi = area.getPoi();
                                String poiNumber = poi == null ? "" : poi.getPoiNumber();
                                infoBox.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]) + ": " + area.countSubscriptions());
                                infoBox.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.poiNumber", new Serializable[0]) + ": " + StringUtil.nullToEmpty(poiNumber));
                                HashMap<AreaAttributeValueDescriptorModel, AreaAttributeValueModel> attributeMap = new HashMap<AreaAttributeValueDescriptorModel, AreaAttributeValueModel>();
                                for (AreaAttributeValueModel value : area.iterableAreaAttributeValues()) {
                                    attributeMap.put(value.getAreaAttributeValueDescriptor(), value);
                                }
                                for (AreaAttributeValueDescriptorModel descriptor : AreaLayerRenderer.this.overlayDescriptors) {
                                    String line = descriptor.getName() + ": ";
                                    AreaAttributeValueModel value = (AreaAttributeValueModel)attributeMap.get(descriptor);
                                    if (value != null) {
                                        AreaAttributeValueModelAttributeWrapper wrapper = new AreaAttributeValueModelAttributeWrapper(value);
                                        line = line + AttributeHelper.getTextRepresentationValue(wrapper);
                                    }
                                    infoBox.add(line);
                                }
                                if (areaPointRenderer == null) {
                                    areaPointRenderer = new AreaPointRenderer(g2d, upp, AreaLayerRenderer.this.getCoordinateFactory());
                                }
                                areaPointRenderer.drawInfoBox(infoBox, coord, Color.BLACK, 10.0 * upp);
                            }
                        }
                    }
                }
            };
            ArrayList<OnTopRendering> aOnTops = new ArrayList<OnTopRendering>(onTops.size() + 1);
            aOnTops.addAll(onTops);
            aOnTops.add(onTopRendering);
            return aOnTops;
        }
        return onTops;
    }

    private void drawWhiteForMap(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        ImmutablePolygonKind rectangle;
        CoordinateFactory factory = this.getPanel().getCoordinateFactory();
        Coordinate bottomLeft = factory.createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY());
        Coordinate topRight = factory.createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY());
        try {
            rectangle = ImmutableGeoObjectFactory.createImmutablePolygonRectangle(ImmutableGeoObjectFactory.createImmutablePoint(bottomLeft), ImmutableGeoObjectFactory.createImmutablePoint(topRight));
        }
        catch (IllegalPointCountException e) {
            throw new RuntimeException(e);
        }
        Collection<AreaObjectModel> models = this.getGeometries(bottomLeft, topRight, upp);
        for (AreaObjectModel model : models) {
            ImmutablePolygonKind geom = model.getGeom();
            if (geom == null) continue;
            geom = (ImmutablePolygonKind)geom.getTransformed(factory).snapToGrid(upp);
            rectangle = (ImmutablePolygonKind)rectangle.difference(geom);
        }
        Area[] areas = PaintUtil.createPolygonArea(rectangle);
        Color color = g2d.getColor();
        g2d.setColor(Color.WHITE);
        for (Area area : areas) {
            g2d.fill(area);
        }
        g2d.setColor(color);
    }

    @Override
    public <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> void render(AreaObjectModel model, Graphics2D g2d, AreaRenderer<U, AreaObjectModel> areaRenderer, U areaRendererProperties, LineRenderer<V, AreaObjectModel> lineRenderer, V lineRendererProperties, PointRenderer<W, AreaObjectModel> pointRenderer, W pointRendererProperties, CoordinateFactory factory, double upp, int cycle) {
        super.render(model, g2d, areaRenderer, areaRendererProperties, lineRenderer, lineRendererProperties, pointRenderer, pointRendererProperties, factory, upp, cycle);
        ImmutablePolygonKind poly = model.getGeom();
        String name = this.getName(model);
        if (poly != null && !StringUtil.isBlank(name)) {
            boolean noDecider;
            poly = (ImmutablePolygonKind)poly.getTransformed(this.getPanel().getCoordinateFactory());
            AreaLayerRendererPrintTypeDecider decider = this.getAreaLayerRendererPrintTypeDecider();
            boolean bl = noDecider = decider == null;
            if (noDecider || decider.drawMarkCircle(model)) {
                Collection<ImmutablePoint> centerPoints;
                if (upp <= this.maxMarkIconUpp) {
                    centerPoints = GeoUtils.findCenterPointInPolygonKind(poly, true);
                    for (ImmutablePoint centerPoint : centerPoints) {
                        this.drawMarkIcon(g2d, upp, centerPoint);
                    }
                } else if (upp <= this.maxMarkCircleUpp) {
                    centerPoints = GeoUtils.findCenterPointInPolygonKind(poly, true);
                    for (ImmutablePoint centerPoint : centerPoints) {
                        this.drawMarkCircle(g2d, upp, centerPoint);
                    }
                }
            }
            if (upp <= this.maxShortCutUpp && (noDecider || decider.printName(model)) && !StringUtil.isBlank(name)) {
                if (poly instanceof ImmutableMultiPolygon) {
                    ImmutablePolygon biggestImmutablePolygon = null;
                    double biggestArea = -1.0;
                    for (ImmutablePolygon immutablePolygon : ((ImmutableMultiPolygon)poly).getParts()) {
                        double area = Math.abs(immutablePolygon.getArea());
                        if (!(area > biggestArea)) continue;
                        biggestImmutablePolygon = immutablePolygon;
                        biggestArea = area;
                    }
                    if (biggestImmutablePolygon != null) {
                        this.drawName(g2d, upp, biggestImmutablePolygon, name);
                    }
                } else {
                    this.drawName(g2d, upp, (ImmutablePolygon)poly, name);
                }
            }
        }
    }

    private void drawMarkCircle(Graphics2D g2d, double upp, ImmutablePoint centerPoint) {
        Color color = Color.BLACK;
        g2d.setColor(color);
        BasicStroke stroke = new BasicStroke((float)(3.0 * upp));
        g2d.setStroke(stroke);
        NavigatorPanel panel = this.getPanel();
        ImmutablePoint tCenterPoint = (ImmutablePoint)centerPoint.getTransformed(panel.getCoordinateFactory());
        double realX = tCenterPoint.getX();
        double realY = tCenterPoint.getY();
        Point2D.Double point = new Point2D.Double(realX, realY);
        point = panel.getPixel(point);
        point = new Point2D.Double(point.getX() - this.markRadiusInPixel, point.getY() + this.markRadiusInPixel);
        point = panel.getReal(point);
        double dm = this.markRadiusInPixel * upp * 2.0;
        Ellipse2D.Double ell = new Ellipse2D.Double(point.getX(), point.getY(), dm, dm);
        g2d.draw(ell);
    }

    private void drawMarkIcon(Graphics2D g2d, double upp, ImmutablePoint centerPoint) {
        NavigatorPanel panel = this.getPanel();
        ImmutablePoint tCenterPoint = (ImmutablePoint)centerPoint.getTransformed(panel.getCoordinateFactory());
        double realX = tCenterPoint.getX();
        double realY = tCenterPoint.getY();
        AffineTransform transform = g2d.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        g2d.scale(1.0 / scaleX, 1.0 / scaleY);
        int width = areaInfoimage.getWidth(null) / 2;
        int height = areaInfoimage.getHeight(null) / 2;
        double x = realX * scaleX;
        double y = realY * scaleY;
        g2d.drawImage(areaInfoimage, (int)Math.round(x - (double)width), (int)Math.round(y - (double)height), null);
        g2d.setTransform(transform);
    }

    protected String getName(AreaObjectModel model) {
        return areaNameRenderingType.formate(this.areaNameRenderingPattern, model);
    }

    private void drawName(Graphics2D g2d, double upp, ImmutablePolygon immutablePolygon, String name) {
        AffineTransform affineTransform = g2d.getTransform();
        Color color = Color.BLACK;
        g2d.setColor(color);
        String rName = name.trim();
        double scaleX = affineTransform.getScaleX() / 1.5;
        double scaleY = affineTransform.getScaleY() / 1.5;
        AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
        g2d.transform(flip);
        Font gFont = g2d.getFont();
        this.font = this.getAreaFont(gFont);
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        FontMetrics fontMetrics = g2d.getFontMetrics();
        double height = fontMetrics.getHeight();
        double width = fontMetrics.stringWidth(rName);
        ImmutablePoint center = immutablePolygon.getCentroid();
        Point2D.Double dst = new Point2D.Double();
        double realX = center.getX();
        double realY = center.getY();
        AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(realX, realY), dst);
        g2d.drawString(rName, (float)(dst.getX() - width / 2.0), (float)(dst.getY() - height / 2.0 - 20.0 / upp));
        g2d.setTransform(affineTransform);
        g2d.setFont(gFont);
    }

    public Font getAreaFont() {
        return this.font;
    }

    private Font getAreaFont(Font font) {
        if (this.font == null) {
            Properties properties = ModelEnviroment.getProperties();
            String name = properties.getProperty("area.font.name");
            String sizeString = properties.getProperty("area.font.size");
            Integer size = null;
            if (!StringUtil.isBlank(sizeString)) {
                try {
                    size = Integer.valueOf(sizeString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String styleString = properties.getProperty("area.font.style");
            int style = 0;
            if (!StringUtil.isBlank(styleString)) {
                if ((styleString = styleString.toUpperCase()).contains("BOLD")) {
                    style |= 1;
                }
                if (styleString.contains("ITALIC")) {
                    style |= 2;
                }
            }
            if (StringUtil.isBlank(name)) {
                this.font = font.deriveFont(style);
                if (size != null) {
                    this.font = this.font.deriveFont(size);
                }
            } else {
                this.font = new Font(name, style, size == null ? font.getSize() : size.intValue());
            }
        }
        return this.font;
    }

    public void setAreaFont(Font font) {
        this.font = font;
    }

    private void drawAntLine(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp, ImmutablePolygon immutablePolygon) {
        if (this.drawAntLineActive) {
            this.drawAntLine(g2d, realBoundaryBottomLeft, realBoundaryTopRight, immutablePolygon.getShell(), upp * 5.0);
            for (ImmutableLineString linestring : immutablePolygon.getHoles()) {
                this.drawAntLine(g2d, realBoundaryBottomLeft, realBoundaryTopRight, linestring, upp * 5.0);
            }
        }
    }

    private void drawAntLine(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, ImmutableLineString geom, double margin) {
        if (GeoUtils.isGeomInRectangle(realBoundaryBottomLeft.getX(), realBoundaryTopRight.getX(), realBoundaryTopRight.getY(), realBoundaryBottomLeft.getY(), geom)) {
            Color color1 = Color.BLACK;
            Color color2 = Color.WHITE;
            float wenh = 1.3f;
            float dashlen = 20.0f;
            float dashoff = System.currentTimeMillis() / 250L % 20L;
            float dashlen2 = dashlen / wenh;
            float dashoff2 = dashoff / wenh;
            BasicStroke strokeDash1 = new BasicStroke((float)margin, 2, 0, 10.0f, new float[]{dashlen, dashlen}, dashoff);
            BasicStroke strokeDash2 = new BasicStroke((float)margin * wenh, 2, 0, 10.0f, new float[]{dashlen2, dashlen2}, dashoff2);
            boolean first = true;
            GeneralPath line = new GeneralPath();
            for (ImmutablePoint immutablePoint : geom.getCoordinates()) {
                Coordinate c = immutablePoint.getCoordinate();
                if (first) {
                    ((Path2D)line).moveTo(c.getX(), c.getY());
                    first = false;
                    continue;
                }
                ((Path2D)line).lineTo(c.getX(), c.getY());
            }
            g2d.setStroke(strokeDash2);
            g2d.setColor(color2);
            g2d.draw(line);
            g2d.setStroke(strokeDash1);
            g2d.setColor(color1);
            g2d.draw(line);
        }
    }

    public synchronized void setCurrentAreaObject(Collection<AreaObjectModel> areaObject) {
        this.currentAreaObjects.clear();
        this.currentAreaObjects.addAll(areaObject);
        if (!areaObject.isEmpty()) {
            this.startAntRunner();
        } else {
            this.killAntRunner();
        }
    }

    public List<AreaObjectModel> getCurrentAreaObjects() {
        if (this.currentAreaObjects == null) {
            this.currentAreaObjects = new ArrayList<AreaObjectModel>();
        }
        return this.currentAreaObjects;
    }

    private synchronized void killAntRunner() {
        if (this.antRunner != null) {
            this.antRunner.stopped = true;
            this.antRunner = null;
        }
    }

    private synchronized void startAntRunner() {
    }

    public AreaFilterPatternSetupRendererSelektor setAreaFilterPatternSetupModel(AreaFilterPatternSetupModel areaFilterPatternSetupModel, ModelEnviroment modelEnviroment) {
        if (areaFilterPatternSetupModel == null) {
            this.clearFilterVisibility();
            this.areaFilterPatternSetupRendererSelektor = null;
            this.getPanel().repaint(1L);
        } else if (this.areaFilterPatternSetupRendererSelektor == null || !this.areaFilterPatternSetupRendererSelektor.getModelFilterPatternSetup().equals(areaFilterPatternSetupModel)) {
            this.areaFilterPatternSetupRendererSelektor = new AreaFilterPatternSetupRendererSelektor(areaFilterPatternSetupModel, modelEnviroment);
            this.getPanel().repaint(1L);
        }
        return this.areaFilterPatternSetupRendererSelektor;
    }

    public AreaFilterPatternSetupRendererSelektor getAreaFilterPatternSetupRendererSelektor() {
        return this.areaFilterPatternSetupRendererSelektor;
    }

    public static AreaLayerRenderer createDefaultAreaLayerRenderer(String name, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel, GeomExtractor<AreaObjectModel, ImmutablePolygonKind> geomExtractor, String propPrefix, ModelEnviroment modelEnviroment, Double fMaxUpp, boolean reduceGeom, NavigatorPanel navigatorPanel) {
        return AreaLayerRenderer.createDefaultAreaLayerRenderer(name, bucketsModel, geomExtractor, propPrefix, modelEnviroment, fMaxUpp, null, reduceGeom, navigatorPanel);
    }

    public static AreaLayerRenderer createDefaultAreaLayerRenderer(String name, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel, GeomExtractor<AreaObjectModel, ImmutablePolygonKind> geomExtractor, String prefix, ModelEnviroment modelEnviroment, Double fMaxUpp, Integer maxAlpha, boolean reduceGeom, NavigatorPanel navigatorPanel) {
        Properties properties = ModelEnviroment.getProperties();
        String border = properties.getProperty("layerstyle." + prefix + ".border");
        String fill = properties.getProperty("layerstyle." + prefix + ".fill");
        String mark = properties.getProperty("layerstyle." + prefix + ".mark");
        List<Tupel<String, String>> borderParameters = PropertyUtil.getPrefixedProperties(properties, "layerstyle." + prefix + ".border.parameter.");
        LineRenderer lineRenderer = RendererType.DASH_LINE.name().equals(border) ? (LineRenderer)RendererFactory.getInstance().createRenderer(RendererType.DASH_LINE, borderParameters, modelEnviroment, null, true, null) : (RendererType.SOLID_LINE.name().equals(border) ? (LineRenderer)RendererFactory.getInstance().createRenderer(RendererType.SOLID_LINE, borderParameters, modelEnviroment, null, true, null) : (LineRenderer)RendererFactory.getInstance().createRenderer(RendererType.SOLID_LINE, borderParameters, modelEnviroment, null, true, null));
        AreaRenderer markAreaRenderer = null;
        List<Tupel<String, String>> markAreaParameters = PropertyUtil.getPrefixedProperties(properties, "layerstyle." + prefix + ".mark.parameter.");
        if (RendererType.HATCH_QUAD.name().equals(mark)) {
            markAreaRenderer = (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.HATCH_QUAD, markAreaParameters, modelEnviroment, null, true, maxAlpha);
        } else if (RendererType.PLAIN.name().equals(mark)) {
            markAreaRenderer = (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.PLAIN, markAreaParameters, modelEnviroment, null, true, maxAlpha);
        } else if (RendererType.RANDOM_AREA.name().equals(mark)) {
            markAreaRenderer = (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.RANDOM_AREA, markAreaParameters, modelEnviroment, null, true, maxAlpha);
        } else if (RendererType.INVISIBLE.name().equalsIgnoreCase(mark)) {
            markAreaRenderer = (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.INVISIBLE, markAreaParameters, modelEnviroment, null, true, maxAlpha);
        } else if (RendererType.HATCH_LINE.name().equalsIgnoreCase(mark)) {
            markAreaRenderer = (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.HATCH_LINE, markAreaParameters, modelEnviroment, null, true, maxAlpha);
        }
        List<Tupel<String, String>> areaParameters = PropertyUtil.getPrefixedProperties(properties, "layerstyle." + prefix + ".fill.parameter.");
        AreaRenderer areaRenderer = RendererType.HATCH_QUAD.name().equals(fill) ? (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.HATCH_QUAD, areaParameters, modelEnviroment, null, true, maxAlpha, markAreaRenderer) : (RendererType.PLAIN.name().equals(fill) ? (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.PLAIN, areaParameters, modelEnviroment, null, true, maxAlpha, markAreaRenderer) : (RendererType.RANDOM_AREA.name().equals(fill) ? (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.RANDOM_AREA, areaParameters, modelEnviroment, null, true, maxAlpha, markAreaRenderer) : (RendererType.INVISIBLE.name().equalsIgnoreCase(fill) ? (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.INVISIBLE, areaParameters, modelEnviroment, null, true, maxAlpha, markAreaRenderer) : (RendererType.HATCH_LINE.name().equalsIgnoreCase(fill) ? (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.HATCH_LINE, areaParameters, modelEnviroment, null, true, maxAlpha, markAreaRenderer) : (AreaRenderer)RendererFactory.getInstance().createRenderer(RendererType.PLAIN, areaParameters, modelEnviroment, null, true, maxAlpha, markAreaRenderer)))));
        double minUpp = PropertyUtil.extractDouble(properties, "layerstyle." + prefix + ".minUpp", 0.0);
        double maxUpp = fMaxUpp == null ? PropertyUtil.extractDouble(properties, "layerstyle." + prefix + ".maxUpp", 512.0) : fMaxUpp;
        double maxShortcutUpp = PropertyUtil.extractDouble(properties, "layerstyle." + prefix + ".maxNameRenderingUpp", 8.0);
        String overlay = ModelEnviroment.getProperties().getProperty("area.overlay.descriptors");
        ArrayList<AreaAttributeValueDescriptorModel> descriptors = new ArrayList<AreaAttributeValueDescriptorModel>();
        if (overlay != null) {
            Set<String> descriptorKeys = CollectionUtil.buildHashSet(overlay.replaceAll(" ", "").split(","));
            Collection<AreaAttributeValueDescriptorModel> areaAttributeValueDescriptors = modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
            for (AreaAttributeValueDescriptorModel descriptor : areaAttributeValueDescriptors) {
                if (!descriptorKeys.contains(descriptor.getKey().replaceAll(" ", ""))) continue;
                descriptors.add(descriptor);
            }
        }
        return new AreaLayerRenderer(name, bucketsModel, minUpp, maxUpp, areaRenderer, lineRenderer, markAreaRenderer, maxShortcutUpp, reduceGeom, modelEnviroment, geomExtractor, navigatorPanel, descriptors);
    }

    public static AreaLayerRenderer createDefaultAreaLayerRenderer(String name, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel, GeomExtractor<AreaObjectModel, ImmutablePolygonKind> geomExtractor, String propPrefix, ModelEnviroment modelEnviroment, boolean reduceGeom, NavigatorPanel navigatorPanel) {
        return AreaLayerRenderer.createDefaultAreaLayerRenderer(name, bucketsModel, geomExtractor, propPrefix, modelEnviroment, null, reduceGeom, navigatorPanel);
    }

    public void setEmphasizeSelected(boolean emphasizeSelected) {
        this.emphasizeSelected = emphasizeSelected;
    }

    public static Double getAreaLayerBucketSize() {
        if (bucketSize == null) {
            String areaLayerBucketSizeString = ModelEnviroment.getProperties().getProperty("arealayer.bucketsize");
            bucketSize = 50000.0;
            if (!StringUtil.isBlank(areaLayerBucketSizeString)) {
                try {
                    bucketSize = Double.parseDouble(areaLayerBucketSizeString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bucketSize;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void prepare(Coordinate realBoundaryBottomLeft, Coordinate realBoundaryTopRight, double upp) {
    }

    public void setSelectedRectangle(Rectangle2D.Double selectedRectangle) {
        this.selectedRectangle = selectedRectangle;
    }

    public void addAllowedAreaLayer(AreaLayerModel areaLayer) {
        if (this.allowedAreaLayers == null) {
            this.allowedAreaLayers = new HashSet<AreaLayerModel>();
        }
        this.allowedAreaLayers.add(areaLayer);
    }

    public void removeAllowedAreaLayer(AreaLayerModel areaLayer) {
        if (this.allowedAreaLayers == null) {
            return;
        }
        this.allowedAreaLayers.remove(areaLayer);
    }

    public void setAreaLayerRendererPrintTypeDecider(AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider) {
        this.areaLayerRendererPrintTypeDecider = areaLayerRendererPrintTypeDecider;
    }

    public AreaLayerRendererPrintTypeDecider getAreaLayerRendererPrintTypeDecider() {
        return this.areaLayerRendererPrintTypeDecider;
    }

    @Override
    protected ImmutablePolygonKind getGeomToPaint(AreaObjectModel model, double upp) {
        if (this.reduceGeom) {
            List<Tupel<Double, DetaillessAreaObjectGeometryModel>> list = this.detaillessMap.get(model);
            DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometryModel = null;
            if (list != null) {
                for (Tupel<Double, DetaillessAreaObjectGeometryModel> tupel : list) {
                    Double cUpp = tupel.getElement1();
                    if (!(upp >= cUpp)) continue;
                    detaillessAreaObjectGeometryModel = tupel.getElement2();
                    break;
                }
            }
            if (detaillessAreaObjectGeometryModel == null) {
                return model.getGeom();
            }
            return detaillessAreaObjectGeometryModel.getGeom();
        }
        return model.getGeom();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Collection<AreaObjectModel> getGeometries(Coordinate bottomLeft, Coordinate topRight, double upp) {
        Collection<AreaObjectModel> models = super.getGeometries(bottomLeft, topRight, upp);
        if (this.reduceGeom) {
            void var10_19;
            HashSet<AreaObjectModel> mapless = new HashSet<AreaObjectModel>();
            LinkedList<AreaObjectModel> noDetails = new LinkedList<AreaObjectModel>();
            block0: for (AreaObjectModel areaObjectModel : models) {
                areaObjectModel.addValueChangeListener(this.detaillessAreaObjectGeometryModelValueChangeListener);
                List<Tupel<Double, DetaillessAreaObjectGeometryModel>> list = this.detaillessMap.get(areaObjectModel);
                if (list == null) {
                    if (this.changedAreaObjectsForDetailless.contains(areaObjectModel)) {
                        ArrayList<Tupel<Double, DetaillessAreaObjectGeometryModel>> arrayList = new ArrayList<Tupel<Double, DetaillessAreaObjectGeometryModel>>(areaObjectModel.countDetaillessAreaObjectGeometries());
                        for (DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometryModel : areaObjectModel.iterableDetaillessAreaObjectGeometries()) {
                            arrayList.add(new Tupel<Double, DetaillessAreaObjectGeometryModel>(detaillessAreaObjectGeometryModel.getFromScale(), detaillessAreaObjectGeometryModel));
                        }
                        Collections.sort(arrayList);
                        this.detaillessMap.put(areaObjectModel, arrayList);
                        continue;
                    }
                    mapless.add(areaObjectModel);
                    noDetails.add(areaObjectModel);
                    continue;
                }
                DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometryModel3 = null;
                for (Tupel<Double, DetaillessAreaObjectGeometryModel> tupel : list) {
                    Double cUpp = (Double)tupel.getElement1();
                    if (!(upp >= cUpp)) continue;
                    detaillessAreaObjectGeometryModel3 = (DetaillessAreaObjectGeometryModel)tupel.getElement2();
                    if (detaillessAreaObjectGeometryModel3 != null) continue block0;
                    noDetails.add(areaObjectModel);
                    continue block0;
                }
            }
            Collection<Tupel<AreaObjectModel, List<Double>>> detaillessSteps = this.getDetaillessSteps(mapless);
            for (Tupel<AreaObjectModel, List<Double>> tupel : detaillessSteps) {
                List<Double> upps = tupel.getElement2();
                ArrayList<Tupel<Double, Object>> arrayList = new ArrayList<Tupel<Double, Object>>(upps.size());
                for (Double cUpp : upps) {
                    arrayList.add(new Tupel<Double, Object>(cUpp, null));
                }
                AreaObjectModel key = tupel.getElement1();
                this.detaillessMap.put(key, arrayList);
                mapless.remove(key);
            }
            List list = Collections.emptyList();
            for (AreaObjectModel areObjectModel : mapless) {
                this.detaillessMap.put(areObjectModel, list);
            }
            if (noDetails.isEmpty()) {
                List list2 = Collections.emptyList();
            } else {
                Collection<Tupel<AreaObjectModel, DetaillessAreaObjectGeometryModel>> collection = this.modelEnviroment.getAllCaller().getAreaCaller().getDetaillessAreaGeometryForUpp(noDetails, upp);
            }
            block6: for (Tupel tupel : var10_19) {
                List<Tupel<Double, DetaillessAreaObjectGeometryModel>> list3 = this.detaillessMap.get(tupel.getElement1());
                for (Tupel<Double, DetaillessAreaObjectGeometryModel> sTupel : list3) {
                    Double cUpp = sTupel.getElement1();
                    if (!(upp >= cUpp)) continue;
                    DetaillessAreaObjectGeometryModel foundDetailless = (DetaillessAreaObjectGeometryModel)tupel.getElement2();
                    sTupel.setElement2(foundDetailless);
                    continue block6;
                }
            }
        }
        return models;
    }

    private Collection<Tupel<AreaObjectModel, List<Double>>> getDetaillessSteps(Set<AreaObjectModel> mapless) {
        if (mapless != null && !mapless.isEmpty()) {
            return this.modelEnviroment.getAllCaller().getAreaCaller().getDetaillessSteps(mapless);
        }
        return Collections.emptyList();
    }

    public void setShowFilterDefault(boolean selection) {
        if (this.areaFilterPatternSetupRendererSelektor != null) {
            this.areaFilterPatternSetupRendererSelektor.setShowFilterDefault(selection);
        }
        this.getPanel().repaint(10L);
    }

    public void setShowFilter(ObjectFilter<AreaFilterModel, AttributeValueFilterModel> objectFilter, boolean selection) {
        if (this.invisibleFilters == null) {
            this.invisibleFilters = new HashSet<ObjectFilter<AreaFilterModel, AttributeValueFilterModel>>();
        }
        if (selection) {
            this.invisibleFilters.remove(objectFilter);
        } else {
            this.invisibleFilters.add(objectFilter);
        }
        if (this.areaFilterPatternSetupRendererSelektor != null) {
            this.areaFilterPatternSetupRendererSelektor.setShowFilter(this.invisibleFilters);
        }
        this.getPanel().repaint(10L);
    }

    public void clearFilterVisibility() {
        this.invisibleFilters = null;
        if (this.areaFilterPatternSetupRendererSelektor != null) {
            this.areaFilterPatternSetupRendererSelektor.setShowFilterDefault(null);
            this.areaFilterPatternSetupRendererSelektor.setShowFilter(null);
        }
        this.getPanel().repaint(10L);
    }

    public void setIslandMode(boolean islandMode) {
        this.islandMode = islandMode;
    }

    public void setAreaNameRenderingPattern(String areaNameRenderingPattern) {
        this.areaNameRenderingPattern = areaNameRenderingPattern;
    }

    @Override
    public void close() {
        super.close();
        this.killAntRunner();
    }

    static {
        String areaNameRenderingTypeString = ModelEnviroment.getProperties().getProperty("area.name.rendering.type");
        try {
            areaNameRenderingType = AreaNameRenderingType.valueOf(areaNameRenderingTypeString.toUpperCase());
        }
        catch (Exception ex) {
            areaNameRenderingType = AreaNameRenderingType.SHORTCUT;
        }
        try {
            areaInfoimage = ImageIO.read(AreaLayerRenderer.class.getResource("/images/areainfo.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class DetaillessAreaObjectGeometryModelValueChangeListener
    implements ValueChangeListener {
        private DetaillessAreaObjectGeometryModelValueChangeListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent e) {
            Object source = e.getSource();
            if ((e.getType() == ValueChangeEvent.Type.DELETE || e.getType() == ValueChangeEvent.Type.UPDATE && e.getProperty() == AreaObjectModelImpl.AreaObjectModelEnum.GEOM) && source instanceof AreaObjectModel) {
                AreaObjectModel areaObjectModel = (AreaObjectModel)source;
                AreaLayerRenderer.this.detaillessMap.remove(areaObjectModel);
                AreaLayerRenderer.this.changedAreaObjectsForDetailless.add(areaObjectModel);
            }
        }
    }

    private class AntRunner
    extends Thread {
        private boolean stopped;

        private AntRunner() {
        }

        @Override
        public void run() {
            while (!this.stopped && AreaLayerRenderer.this.getPanel().getUpp() <= 16.0) {
                AreaLayerRenderer.this.callRepaint();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

