/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.ktde.swing.navigator.AbstractMouseManipulatorAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public class ZoomingRenderer
extends AbstractMouseManipulatorAction
implements NavigatorRenderer {
    private static final long serialVersionUID = 213386295676715595L;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private float fontFactor = 1.0f;
    private double thickness = 3.0;
    private Orientation orientation;
    private NavigatorPanel navigatorPanel;
    private int yMargin;
    private int xMargin;
    private double xPoint1;
    private double xPoint2;
    private double xPoint3;
    private double yPoint1;
    private double yPoint2;
    private int sortOrder = Integer.MAX_VALUE;

    public ZoomingRenderer(NavigatorPanel navigatorPanel) {
        super(navigatorPanel, null, "ZoomingRender");
        this.navigatorPanel = navigatorPanel;
        Properties properties = ModelEnviroment.getProperties();
        try {
            this.orientation = Orientation.valueOf(properties.getProperty("navigator.zooming.orientation"));
        }
        catch (Exception ex) {
            this.orientation = Orientation.NORTH_EAST;
        }
        try {
            this.yMargin = Integer.parseInt(properties.getProperty("navigator.zooming.yMargin"));
        }
        catch (Exception ex) {
            this.yMargin = 50;
        }
        try {
            this.xMargin = Integer.parseInt(properties.getProperty("navigator.zooming.xMargin"));
        }
        catch (Exception ex) {
            this.xMargin = 100;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.isActive()) {
            AffineTransform affineTransform;
            double d;
            NavigatorPanel panel = this.navigatorPanel;
            Point2D.Double center = null;
            switch (this.orientation) {
                case CENTER: {
                    center = panel.getReal(panel.getCenterPixel());
                    break;
                }
                case EAST: {
                    center = new Point2D.Double(realBoundaryTopRight.getX() - (double)this.xMargin * upp, panel.getReal(panel.getCenterPixel()).getY());
                    break;
                }
                case NORTH: {
                    center = new Point2D.Double(panel.getReal(panel.getCenterPixel()).getX(), realBoundaryTopRight.getY() - (double)this.yMargin * upp);
                    break;
                }
                case SOUTH: {
                    center = new Point2D.Double(panel.getReal(panel.getCenterPixel()).getX(), realBoundaryBottomLeft.getY() + (double)this.yMargin * upp);
                    break;
                }
                case WEST: {
                    center = new Point2D.Double(realBoundaryBottomLeft.getX() + (double)this.xMargin * upp, panel.getReal(panel.getCenterPixel()).getY());
                    break;
                }
                case NORTH_EAST: {
                    center = new Point2D.Double(realBoundaryTopRight.getX() - (double)this.xMargin * upp, realBoundaryTopRight.getY() - (double)this.yMargin * upp);
                    break;
                }
                case NORTH_WEST: {
                    center = new Point2D.Double(realBoundaryBottomLeft.getX() + (double)this.xMargin * upp, realBoundaryTopRight.getY() - (double)this.yMargin * upp);
                    break;
                }
                case SOUTH_EAST: {
                    center = new Point2D.Double(realBoundaryTopRight.getX() - (double)this.xMargin * upp, realBoundaryBottomLeft.getY() + (double)this.yMargin * upp);
                    break;
                }
                case SOUTH_WEST: {
                    center = new Point2D.Double(realBoundaryBottomLeft.getX() + (double)this.xMargin * upp, realBoundaryBottomLeft.getY() + (double)this.yMargin * upp);
                }
            }
            double cY = center.getY();
            double cX = center.getX();
            BasicStroke stroke = new BasicStroke((float)(upp * this.thickness));
            g2d.setStroke(stroke);
            g2d.setColor(Color.BLACK);
            double half = 20.0 * upp;
            double left = cX - half;
            double right = cX + half;
            double uGap = 10.0 * upp + cY;
            Path2D.Double rect = null;
            rect = new Path2D.Double();
            double g = 2.0;
            double fHeight = 30.0 * (double)this.fontFactor;
            this.xPoint1 = left - g * upp;
            this.yPoint1 = cY - g * upp;
            this.xPoint2 = right + g * upp;
            this.yPoint2 = uGap + fHeight * upp;
            ((Path2D)rect).moveTo(left - g * upp, uGap + fHeight * upp);
            ((Path2D)rect).lineTo(left - g * upp, cY - g * upp);
            ((Path2D)rect).lineTo(right + g * upp, cY - g * upp);
            ((Path2D)rect).lineTo(right + g * upp, uGap + fHeight * upp);
            ((Path2D)rect).lineTo(left - g * upp, uGap + fHeight * upp);
            double secondRectDist = 2.0 * half;
            this.xPoint3 = right + secondRectDist + g * 3.0 * upp;
            ((Path2D)rect).moveTo(right + g * upp, cY - g * upp);
            ((Path2D)rect).lineTo(right + secondRectDist + g * 3.0 * upp, cY - g * upp);
            ((Path2D)rect).lineTo(right + secondRectDist + g * 3.0 * upp, uGap + fHeight * upp);
            ((Path2D)rect).lineTo(right + g * upp, uGap + fHeight * upp);
            if (rect != null) {
                g2d.setColor(Color.WHITE);
                g2d.fill(rect);
                g2d.setColor(Color.BLACK);
            }
            if ((d = (affineTransform = g2d.getTransform()).getDeterminant()) != 0.0) {
                try {
                    g2d.draw(rect);
                    Font font = g2d.getFont();
                    Font drawFont = font.deriveFont((float)font.getSize() * this.fontFactor);
                    g2d.setFont(drawFont);
                    double scaleX = affineTransform.getScaleX() / 1.5;
                    double scaleY = affineTransform.getScaleY() / 1.5;
                    AffineTransform flip = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
                    g2d.transform(flip);
                    String rName1 = "-";
                    String rName2 = "+";
                    FontMetrics fontMetrics = g2d.getFontMetrics();
                    double height = fontMetrics.getHeight();
                    double width1 = fontMetrics.stringWidth(rName1);
                    double width2 = fontMetrics.stringWidth(rName2);
                    Point2D.Double dst = new Point2D.Double();
                    AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(cX, cY), dst);
                    g2d.drawString(rName1, (float)(dst.getX() - width1 / 2.0), (float)(dst.getY() - height / 2.0));
                    cX = cX + secondRectDist + 2.0 * g * upp;
                    AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(cX, cY), dst);
                    g2d.drawString(rName2, (float)(dst.getX() - width2 / 2.0), (float)(dst.getY() - height / 2.0));
                    g2d.setFont(font);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            g2d.setTransform(affineTransform);
        }
        return Collections.emptyList();
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
    }

    @Override
    public String getName() {
        return "ZoomingRenderer";
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    @Override
    public void close() {
    }

    @Override
    protected void turnedOn() {
    }

    @Override
    protected void turnedOff() {
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseDragged(int x, int y) {
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (MouseButton.getMouseButton(e) == MouseButton.BUTTON1) {
            Point2D.Double currentPoint = this.getNavigatorPanel().getReal(e.getX(), e.getY());
            double cX = currentPoint.x;
            double cY = currentPoint.y;
            if (cX >= this.xPoint1 && cX <= this.xPoint2 && cY >= this.yPoint1 && cY <= this.yPoint2) {
                NavigatorPanningAction.performZoomStep(this.getNavigatorPanel(), false);
                e.consume();
            } else if (cX >= this.xPoint2 && cX <= this.xPoint3 && cY >= this.yPoint1 && cY <= this.yPoint2) {
                NavigatorPanningAction.performZoomStep(this.getNavigatorPanel(), true);
                e.consume();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseButton.getMouseButton(e) == MouseButton.BUTTON1) {
            Point2D.Double currentPoint = this.getNavigatorPanel().getReal(e.getX(), e.getY());
            double cX = currentPoint.x;
            double cY = currentPoint.y;
            if (cX >= this.xPoint1 && cX <= this.xPoint2 && cY >= this.yPoint1 && cY <= this.yPoint2) {
                e.consume();
            } else if (cX >= this.xPoint2 && cX <= this.xPoint3 && cY >= this.yPoint1 && cY <= this.yPoint2) {
                e.consume();
            }
        }
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseMoved(int x, int y) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public static enum Orientation {
        NORTH_WEST,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        CENTER;

    }
}

