/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.renderer.DashLineColorRenderer;
import de.datomino.util.geo.ImmutableLineString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public class TripleDashLineColorRenderer
extends DashLineColorRenderer {
    private Color color;

    public TripleDashLineColorRenderer(double upp, boolean isWithArrow, CoordinateFactory factory, Color color) {
        super(upp, isWithArrow, factory);
        this.color = color;
    }

    @Override
    public void render(Graphics2D g2d, ImmutableLineString lineString, Tupel<Color, Color> colorTupel, float scale) {
        super.render(g2d, lineString, colorTupel, scale);
        g2d.setColor(this.color);
        float f = (float)(Math.log10(this.upp) / (Math.log10(2.0) * 2.0));
        if ((double)f < 2.5) {
            f = 2.5f;
        }
        BasicStroke strokeDash = new BasicStroke(this.getLineWidth() * scale, 0, 1, 0.0f, new float[]{f, f}, 0.0f);
        g2d.setStroke(strokeDash);
        this.drawLineString(g2d, lineString);
    }
}

