/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.util.geo.ImmutableLineString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public class DashLineRenderer
extends AbstractLineRenderer {
    private float interval;

    public DashLineRenderer(double upp, boolean isWithArrow, CoordinateFactory factory) {
        this(upp, 15.0f, isWithArrow, factory);
    }

    public DashLineRenderer(double upp, float interval, boolean isWithArrow, CoordinateFactory factory) {
        super(upp, isWithArrow, factory);
        this.interval = interval;
    }

    @Override
    public void render(Graphics2D g2d, ImmutableLineString lineString, Tupel<Color, Color> colorTupel, float scale) {
        g2d.setColor(colorTupel.getElement1());
        g2d.setBackground(colorTupel.getElement2());
        float f = (float)((double)this.interval * Math.log10(this.upp) / Math.log10(2.0));
        if (f < this.interval) {
            f = this.interval;
        }
        BasicStroke strokeDash = new BasicStroke(this.getLineWidth() * scale, 0, 0, 10.0f, new float[]{f, f}, 0.0f);
        g2d.setStroke(strokeDash);
        this.drawLineString(g2d, lineString);
    }

    public void render(Graphics2D g2d, ImmutableLineString lineString, Color color, float scale) {
        this.render(g2d, lineString, new Tupel<Color, Object>(color, null), scale);
    }
}

