/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.graphics.Polygon2D;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public class CoordinateEditorLayerRenderer
implements NavigatorRenderer {
    private NavigatorPanel navigatorPanel;
    private boolean active;
    private Coordinate coordinate;
    private Polygon2D polygon;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = Integer.MAX_VALUE;

    public CoordinateEditorLayerRenderer(boolean active) {
        this.active = active;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        double margin = 8.0 * upp;
        DefaultPointRenderer renderer = new DefaultPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory());
        this.polygon = renderer.drawPin(this.coordinate, margin, Color.GREEN);
        return Collections.emptyList();
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.navigatorPanel.repaint(10L);
        }
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Coordinate getSelectedCoordinate(Point2D.Double point) {
        if (this.polygon != null && this.polygon.contains(point)) {
            return this.coordinate;
        }
        return null;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = this.navigatorPanel.getCoordinateFactory().createCoordinate(coordinate);
    }

    @Override
    public String getName() {
        return "CoordinateEditorLayerRenderer";
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

