/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.map.RendererNode;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractTableRenderer
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JList list = this.createJList(value, 0, table.getFont());
        if (isSelected) {
            list.setBackground(PeppergisConstants.SELECTION_COLOR);
        }
        return list;
    }

    protected JList createJList(Object value, int alignment, Font font) {
        return this.createJList(value, alignment, font, null);
    }

    protected JList createJList(Object value, final int alignment, final Font font, final Icon icon) {
        JList list = new JList();
        list.setFixedCellHeight(this.getCellHeight());
        list.setOpaque(true);
        list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = new JLabel();
                label.setVerticalAlignment(0);
                label.setHorizontalAlignment(alignment);
                label.setFont(font);
                if (icon != null && index == 0) {
                    label.setIcon(icon);
                }
                if (value instanceof RendererNode) {
                    RendererNode node = (RendererNode)value;
                    label.setText(node.getText());
                    label.setForeground(node.getFontground());
                    label.setIcon(node.getIcon());
                } else {
                    label.setText((String)value);
                }
                return label;
            }
        });
        Vector vector = new Vector();
        if (value instanceof List) {
            for (Object o : (List)value) {
                vector.addElement(o);
            }
        } else {
            String str = this.getString(value);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(str));
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    vector.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        list.setListData(vector);
        return list;
    }

    protected String getString(Object value) {
        return value == null ? "" : value.toString();
    }

    protected int getCellHeight() {
        return 20;
    }
}

