/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.renderer;

import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.LocationObject;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.AbstractBucketNavigatorStaticRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.Renderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;

public abstract class AbstractFilterablePointBucketNavigatorStaticRenderer<T extends LocationObject<S>, S extends Model>
extends AbstractBucketNavigatorStaticRenderer<T, ImmutablePoint> {
    private Collection<T> hovers;
    private Map<S, List<?>> rendererCache = new HashMap();

    public AbstractFilterablePointBucketNavigatorStaticRenderer(String name, GeoObjectBucketsModel<T, ImmutablePoint> bucketsModel, double minUpp, double maxUpp, PointRenderer<? extends RendererProperties, T> defaultPointRenderer) {
        super(name, bucketsModel, minUpp, maxUpp, null, null, defaultPointRenderer, bucketsModel);
    }

    protected abstract AbstractFilterPatternSetupRendererSelektor<?, S, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor();

    protected abstract boolean canHover();

    @Override
    protected <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> Collection<Tripel<AreaRenderer<U, T>, LineRenderer<V, T>, PointRenderer<W, T>>> getRenderersForModel(T model, int cycle) {
        AbstractFilterPatternSetupRendererSelektor<?, S, ?, ?, ?, ?, ?, ?, ?> filterPatternSetupRendererSelektor = this.getFilterPatternSetupRendererSelektor();
        if (filterPatternSetupRendererSelektor == null) {
            return super.getRenderersForModel(model, cycle);
        }
        List<Tripel<AreaRenderer<U, T>, LineRenderer<V, T>, PointRenderer<W, T>>> list = this.rendererCache.get(model.getModel());
        if (list == null) {
            List renderers = filterPatternSetupRendererSelektor.getRenderers(model.getModel());
            list = new ArrayList<Tripel<AreaRenderer<U, T>, LineRenderer<V, T>, PointRenderer<W, T>>>(renderers.size());
            for (Renderer renderer : renderers) {
                if (renderer == null) continue;
                PointRenderer pointRenderer = (PointRenderer)renderer;
                list.add(new Tripel<Object, Object, PointRenderer>(null, null, pointRenderer));
            }
            this.rendererCache.put(model.getModel(), list);
        }
        return list;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        Collection<OnTopRendering> onTops = super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        this.paintSpecialElements(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
        if (this.canHover() && this.hovers != null && !this.hovers.isEmpty()) {
            this.drawHover(g2d, realBoundaryBottomLeft, realBoundaryTopRight, this.hovers, upp);
        }
        return onTops;
    }

    protected void paintSpecialElements(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    protected abstract void drawHover(Graphics2D var1, Point2D.Double var2, Point2D.Double var3, Collection<T> var4, double var5);

    public void setHovers(Collection<T> hovers) {
        this.hovers = hovers;
        this.callRepaint(1L);
    }

    public void removeFromRendererCache(S model) {
        this.rendererCache.remove(model);
    }

    protected void clearRendererCache() {
        this.rendererCache.clear();
    }

    @Override
    protected Collection<T> getGeometries(Coordinate bottomLeft, Coordinate topRight, double upp) {
        Collection locationObjects = super.getGeometries(bottomLeft, topRight, upp);
        ArrayList sorted = new ArrayList(locationObjects);
        Collections.sort(sorted);
        return sorted;
    }
}

