/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi.search;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.util.international.country.Country;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;

public class PoiSearchTableModel
implements TableModel {
    private List<PoiModel> pois;
    private boolean showType;
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

    public PoiSearchTableModel(boolean showType) {
        this.showType = showType;
    }

    @Override
    public int getRowCount() {
        return this.pois == null ? 0 : this.pois.size();
    }

    @Override
    public int getColumnCount() {
        return this.showType ? 10 : 9;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String key = null;
        if (columnIndex > 1 && !this.showType) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                key = "messages.poi.poiNumber";
                break;
            }
            case 1: {
                key = "messages.poi.name";
                break;
            }
            case 2: {
                key = "messages.poi.poiType";
                break;
            }
            case 3: {
                key = "address.country";
                break;
            }
            case 4: {
                key = "address.postcode";
                break;
            }
            case 5: {
                key = "address.city";
                break;
            }
            case 6: {
                key = "address.district";
                break;
            }
            case 7: {
                key = "address.street";
                break;
            }
            case 8: {
                key = "address.housenumber";
                break;
            }
            case 9: {
                key = "address.housenumberExt";
            }
        }
        return ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PoiModel poi = this.pois.get(rowIndex);
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(poi.getLocation());
        if (columnIndex > 1 && !this.showType) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                return poi.getPoiNumber();
            }
            case 1: {
                return poi.getName();
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(poi.getPoiType());
            }
            case 3: {
                Country country = locationWrapper == null ? null : locationWrapper.getCountry();
                return country == null ? "" : country.getVehicleSign();
            }
            case 4: {
                return locationWrapper == null ? "" : StringUtil.nullToEmpty(locationWrapper.getPostcode());
            }
            case 5: {
                return locationWrapper == null ? "" : StringUtil.nullToEmpty(locationWrapper.getCity());
            }
            case 6: {
                return locationWrapper == null ? "" : StringUtil.nullToEmpty(locationWrapper.getDistrict());
            }
            case 7: {
                return locationWrapper == null ? "" : StringUtil.nullToEmpty(locationWrapper.getStreet());
            }
            case 8: {
                return locationWrapper == null ? "" : StringUtil.nullToEmpty(locationWrapper.getHousenumber());
            }
            case 9: {
                return locationWrapper == null ? "" : StringUtil.nullToEmpty(locationWrapper.getHousenumberExtension());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setPois(List<PoiModel> pois) {
        this.pois = pois;
        this.fireTableModelChanged(new TableModelEvent(this));
    }

    protected void fireTableModelChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public PoiModel getPoi(int selectedRow) {
        return this.pois.get(selectedRow);
    }
}

