/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi.search;

import de.datomino.peppergis.client.gui.address.AddressPane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.lucene.LocationSearchDto;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class PoiSearchParameterPane
extends JPanel {
    private static final long serialVersionUID = -750146835405146194L;
    private PoiSearchType[] poiTypes;
    private AddressPane addressPane;
    private JTextField poiNumber;
    private JTextField poiName;
    private JTextField areaShortcut;
    private EnumComboBox<PoiSearchType> poiType;

    public PoiSearchParameterPane(boolean showPoiTypes, boolean poiTypesWithEmpty, PoiSearchType[] poiTypes, Country preselectedCountry) {
        super(new SpringLayout());
        this.poiTypes = poiTypes;
        this.buildLayout(showPoiTypes, poiTypesWithEmpty, preselectedCountry);
    }

    private void buildLayout(boolean showPoiTypes, boolean poiTypesWithEmpty, Country preselectedCountry) {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(this.createLabel("messages.poi.poiNumber"));
        this.poiNumber = new JTextField();
        panel.add(this.poiNumber);
        panel.add(this.createLabel("messages.poi.name"));
        this.poiName = new JTextField();
        panel.add(this.poiName);
        panel.add(this.createLabel("messages.area.shortcut"));
        this.areaShortcut = new JTextField();
        panel.add(this.areaShortcut);
        if (showPoiTypes) {
            panel.add(this.createLabel("messages.poi.poiType"));
            this.poiType = new EnumComboBox(PoiSearchType.class, poiTypesWithEmpty, (Enum[])this.poiTypes);
            panel.add(this.poiType);
        }
        SpringUtilities.makeCompactGrid(panel, 1, showPoiTypes ? 8 : 6, 5, 5, 2, 2);
        this.add(panel);
        this.addressPane = new AddressPane(preselectedCountry);
        this.add(this.addressPane);
        SpringUtilities.makeCompactGrid(this, 2, 1, 5, 5, 2, 2);
    }

    private JLabel createLabel(String key) {
        return new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
    }

    public String getAreaShortcut() {
        return this.areaShortcut.getText();
    }

    public LocationSearchDto getLocationSearchDto() {
        return this.addressPane.getLocationSearchDto();
    }

    public String getPoiName() {
        return this.poiName.getText();
    }

    public PoiSearchType[] getPoiTypes() {
        PoiSearchType[] poiSearchTypeArray;
        if (this.poiType == null) {
            return this.poiTypes;
        }
        PoiSearchType selectedValue = this.poiType.getSelectedValue();
        if (selectedValue == null) {
            poiSearchTypeArray = this.poiTypes;
        } else {
            PoiSearchType[] poiSearchTypeArray2 = new PoiSearchType[1];
            poiSearchTypeArray = poiSearchTypeArray2;
            poiSearchTypeArray2[0] = selectedValue;
        }
        return poiSearchTypeArray;
    }

    public String getPoiNumber() {
        return this.poiNumber.getText();
    }

    public void addActionListener(final ActionListener actionListener) {
        this.poiNumber.addActionListener(actionListener);
        this.poiName.addActionListener(actionListener);
        this.areaShortcut.addActionListener(actionListener);
        if (this.poiType != null) {
            this.poiType.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode == 10) {
                        actionListener.actionPerformed(new ActionEvent(PoiSearchParameterPane.this.poiType, 0, null));
                    }
                }
            });
        }
        this.addressPane.addActionListener(actionListener);
    }
}

