/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi.search;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.navigator.DefaultNavigatorPanel;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.poi.PoiDialog;
import de.datomino.peppergis.client.gui.poi.search.PoiSearchParameterPane;
import de.datomino.peppergis.client.gui.poi.search.PoiSearchTableModel;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.lucene.PoiSearchDtoImpl;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.swing.navigator.NavigatorPanel;

public class PoiSearchPane
extends JPanel {
    private static final long serialVersionUID = -4357980048663362005L;
    private JTable resultTable;
    private PoiSearchParameterPane poiSearchParameterPane;
    private PoiSearchType[] poiTypes;
    private ModelEnviroment modelEnviroment;
    private boolean showPoiType;
    private boolean poiTypesWithEmpty;
    private NavigatorPanel navigatorPanel;
    private DefaultSimplePointRenderer defaultSimplePointRenderer;

    public PoiSearchPane(ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes, boolean showPoiType) {
        this(modelEnviroment, poiTypes, showPoiType, true);
    }

    public PoiSearchPane(ModelEnviroment modelEnviroment, PoiSearchType[] poiTypes, boolean showPoiType, boolean poiTypesWithEmtpy) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.poiTypes = poiTypes;
        this.showPoiType = showPoiType;
        this.poiTypesWithEmpty = poiTypesWithEmtpy;
        this.buildLayout();
    }

    private void buildLayout() {
        this.poiSearchParameterPane = new PoiSearchParameterPane(this.showPoiType, this.poiTypesWithEmpty, this.poiTypes, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        this.add((Component)this.poiSearchParameterPane, "North");
        JSplitPane splitPane = new JSplitPane(1);
        this.resultTable = new JTable(new PoiSearchTableModel(this.showPoiType));
        this.resultTable.setSelectionMode(0);
        this.resultTable.addMouseListener(new PoiSearchTableMouseListener());
        this.resultTable.getSelectionModel().addListSelectionListener(new PoiSearchTableListSelectionListener());
        splitPane.setLeftComponent(new JScrollPane(this.resultTable));
        this.navigatorPanel = new DefaultNavigatorPanel(splitPane);
        this.defaultSimplePointRenderer = new DefaultSimplePointRenderer(Color.GREEN);
        this.navigatorPanel.addRenderer(new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties()));
        this.navigatorPanel.addRenderer(this.defaultSimplePointRenderer);
        splitPane.setRightComponent(this.navigatorPanel);
        this.add((Component)splitPane, "Center");
        this.poiSearchParameterPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoiSearchPane.this.search();
            }
        });
    }

    public void search() {
        PoiSearchDtoImpl poiSearchDto = new PoiSearchDtoImpl(this.poiSearchParameterPane.getPoiNumber(), this.poiSearchParameterPane.getPoiName(), this.poiSearchParameterPane.getPoiTypes(), this.poiSearchParameterPane.getAreaShortcut(), this.poiSearchParameterPane.getLocationSearchDto());
        Collection<PoiModel> pois = this.modelEnviroment.getAllCaller().getBaseCaller().searchPoi(poiSearchDto, false);
        PoiSearchTableModel model = (PoiSearchTableModel)this.resultTable.getModel();
        model.setPois(new ArrayList<PoiModel>(pois));
        if (pois.isEmpty()) {
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noMatchFound", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
        }
    }

    public PoiModel getSelectedPoi() {
        int selectedRow = this.resultTable.getSelectedRow();
        if (selectedRow >= 0) {
            PoiSearchTableModel model = (PoiSearchTableModel)this.resultTable.getModel();
            PoiModel poi = model.getPoi(selectedRow);
            return poi;
        }
        return null;
    }

    private class PoiSearchTableListSelectionListener
    implements ListSelectionListener {
        private PoiSearchTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = PoiSearchPane.this.resultTable.getSelectedRow();
            if (selectedRow >= 0) {
                PoiSearchTableModel model = (PoiSearchTableModel)PoiSearchPane.this.resultTable.getModel();
                PoiModel poi = model.getPoi(selectedRow);
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(poi.getLocation());
                ImmutablePoint geoLocation = locationWrapper.getGeoLocation();
                PoiSearchPane.this.defaultSimplePointRenderer.setPoint(geoLocation);
                PoiSearchPane.this.navigatorPanel.center(geoLocation.getCoordinate());
            } else {
                PoiSearchPane.this.defaultSimplePointRenderer.setPoint(null);
            }
            PoiSearchPane.this.navigatorPanel.repaint(10L);
        }
    }

    private class PoiSearchTableMouseListener
    extends MouseAdapter {
        private PoiSearchTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && e.getButton() == 1) {
                int selectedRow = PoiSearchPane.this.resultTable.getSelectedRow();
                PoiSearchTableModel model = (PoiSearchTableModel)PoiSearchPane.this.resultTable.getModel();
                PoiModel poi = model.getPoi(selectedRow);
                PoiDialog poiDialog = new PoiDialog(SwingUtils.findWindowParent(PoiSearchPane.this), Collections.singletonList(poi), PoiSearchPane.this.modelEnviroment);
                poiDialog.setVisible(true);
            }
        }
    }
}

