/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PoiDialogAreaTableModel
implements TableModel {
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();
    private List<AreaObjectModel> areas;

    @Override
    public int getRowCount() {
        return this.areas == null ? 0 : this.areas.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaLayer", new Serializable[0]);
            }
            case 1: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]);
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]);
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.areas == null) {
            return null;
        }
        AreaObjectModel area = this.areas.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return area.getAreaLayer().getDisplayname();
            }
            case 1: {
                return area.getShortcut();
            }
            case 2: {
                return area.getDisplayname();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public void setAreas(Collection<AreaObjectModel> areas) {
        this.areas = new ArrayList<AreaObjectModel>(areas);
        this.fireTableChanged(new TableModelEvent(this));
    }
}

