/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiDialog;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.filter.PoiFilterModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererLayerRelationModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.filter.poi.PoiFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.model.poi.PoiLocationObject;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.SwingUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang.builder.EqualsBuilder;

public class PoiFilterableMarkerRenderer
extends AbstractFilterableMarkerNavigatorRenderer<PoiModel, PoiLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties, PoiFilterModel> {
    private static final long serialVersionUID = 7404004796246656117L;
    protected AbstractMapEditorPanel editorPanel;
    private PoiFilterPatternSetupRendererSelektor poiFilterPatternSetupRendererSelektor;
    private boolean mainDelivererLocationActive;
    private boolean branchDelivererLocationActive;
    private boolean delivererDelivererLocationActive;
    private boolean areaDelivererDelivererLocationActive;
    private boolean regularAreaObjectLocationActive;
    private boolean startPickPointAreaObjectLocationActive;
    private boolean endPickPointAreaObjectLocationActive;
    private boolean inactiveAreaObjectLocationActive;
    private boolean customerActive;
    private boolean pickPointActive;
    private static Long mainDelivererLocationId;
    private AreaLayerModel areaLayerModel;

    public PoiFilterableMarkerRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<PoiLocationObject, ImmutablePoint> bucketsModel, ModelEnviroment modelEnviroment, AreaLayerModel areaLayerModel) {
        super(name, title, editorPanel.getNavigatorPanel(), null, null, new DefaultPoiRenderer(areaLayerModel), maxUpp, bucketsModel, false);
        this.editorPanel = editorPanel;
        this.areaLayerModel = areaLayerModel;
        mainDelivererLocationId = modelEnviroment.getAllCaller().getBaseCaller().getMainDelivererLocationPoiId();
    }

    @Override
    public void showMarked(Collection<PoiLocationObject> markedObjects) {
    }

    @Override
    protected void showClicked(Collection<PoiLocationObject> cs) {
        if (cs != null && !cs.isEmpty()) {
            ArrayList<PoiModel> pois = new ArrayList<PoiModel>(cs.size());
            CollectionUtil.transform(cs, pois, new Transformer<PoiLocationObject, PoiModel>(){

                @Override
                public PoiModel transform(PoiLocationObject object) {
                    return (PoiModel)object.getModel();
                }
            });
            PoiDialog poiDialog = new PoiDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), pois, this.editorPanel.getModelEnviroment());
            poiDialog.setVisible(true);
        }
    }

    @Override
    protected void paintSpecialElements(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    protected AbstractFilterPatternSetupRendererSelektor<?, PoiModel, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor() {
        return this.poiFilterPatternSetupRendererSelektor;
    }

    @Override
    protected void drawHover(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, Collection<PoiLocationObject> hovers, double upp) {
    }

    public void setPoiFilterPatternSetup(PoiFilterPatternSetupModel poiFilterPatternSetupModel, ModelEnviroment modelEnviroment) {
        this.clearRendererCache();
        PoiFilterPatternSetupRendererSelektor poiFilterPatternSetupRendererSelektor = this.poiFilterPatternSetupRendererSelektor = poiFilterPatternSetupModel == null ? null : new PoiFilterPatternSetupRendererSelektor(poiFilterPatternSetupModel, modelEnviroment);
        if (this.poiFilterPatternSetupRendererSelektor == null) {
            this.setRendererChecker(null);
        } else {
            this.setRendererChecker(new RendererChecker<PoiLocationObject>(){

                @Override
                public boolean isToBeRendered(PoiLocationObject w) {
                    return PoiFilterableMarkerRenderer.this.poiFilterPatternSetupRendererSelektor.isToBeRendered(w.getModel());
                }
            });
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected boolean isToDrawObject(PoiLocationObject s) {
        return this.isPoiLocationActive(s);
    }

    public boolean isPoiLocationActive(PoiLocationObject s) {
        RenderPoiType[] renderPoiTypes = PoiFilterableMarkerRenderer.getRendererPoiType(s, this.areaLayerModel);
        if (renderPoiTypes == null) {
            return false;
        }
        block12: for (RenderPoiType renderPoiType : renderPoiTypes) {
            switch (renderPoiType) {
                case AREA_DELIVERER_DELIVERER_LOCATION: {
                    if (!this.areaDelivererDelivererLocationActive) continue block12;
                    return true;
                }
                case BRANCH_DELIVERER_LOCATION: {
                    if (!this.branchDelivererLocationActive) continue block12;
                    return true;
                }
                case CUSTOMER: {
                    if (!this.customerActive) continue block12;
                    return true;
                }
                case DELIVERER_DELIVERER_LOCATION: {
                    if (!this.delivererDelivererLocationActive) continue block12;
                    return true;
                }
                case END_PICK_POINT_AREA_OBJECT_LOCATION: {
                    if (!this.endPickPointAreaObjectLocationActive) continue block12;
                    return true;
                }
                case INACTIVE_AREA_OBJECT_LOCATION: {
                    if (!this.inactiveAreaObjectLocationActive) continue block12;
                    return true;
                }
                case MAIN_DELIVERER_LOCATION: {
                    if (!this.mainDelivererLocationActive) continue block12;
                    return true;
                }
                case PICK_POINT: {
                    if (!this.pickPointActive) continue block12;
                    return true;
                }
                case REGULAR_AREA_OBJECT_LOCATION: {
                    if (!this.regularAreaObjectLocationActive) continue block12;
                    return true;
                }
                case START_PICK_POINT_AREA_OBJECT_LOCATION: {
                    if (!this.startPickPointAreaObjectLocationActive) continue block12;
                    return true;
                }
            }
        }
        return false;
    }

    public static RenderPoiType[] getRendererPoiType(PoiLocationObject poiLocationObject, AreaLayerModel areaLayerModel) {
        PoiModel poi = (PoiModel)poiLocationObject.getModel();
        switch (poi.getPoiType()) {
            case AREAOBJECT_LOCATION: {
                return PoiFilterableMarkerRenderer.getRendererPoiTypeAreaLocation(poi, areaLayerModel);
            }
            case CUSTOMER: {
                return new RenderPoiType[]{RenderPoiType.CUSTOMER};
            }
            case DELIVERER_LOCATION: 
            case AREA_DELIVERER_LOCATION: {
                return PoiFilterableMarkerRenderer.getRendererPoiTypeDelivererLocation(poi, areaLayerModel);
            }
            case PICK_POINT: {
                return new RenderPoiType[]{RenderPoiType.PICK_POINT};
            }
        }
        return null;
    }

    private static RenderPoiType[] getRendererPoiTypeDelivererLocation(PoiModel poi, AreaLayerModel areaLayerModel) {
        boolean main = new EqualsBuilder().append(poi.getId(), mainDelivererLocationId).isEquals();
        boolean branch = !poi.isBranchesEmpty();
        boolean deliverer = !poi.isDeliverersEmpty();
        boolean areaDeliverer = PoiFilterableMarkerRenderer.hasAreaDelivererInCurrentLayer(poi, areaLayerModel);
        RenderPoiType[] result = new RenderPoiType[PrimitiveUtil.countTrues(main, branch, deliverer, areaDeliverer)];
        int i = 0;
        if (main) {
            result[i++] = RenderPoiType.MAIN_DELIVERER_LOCATION;
        }
        if (branch) {
            result[i++] = RenderPoiType.BRANCH_DELIVERER_LOCATION;
        }
        if (deliverer) {
            result[i++] = RenderPoiType.DELIVERER_DELIVERER_LOCATION;
        }
        if (areaDeliverer) {
            result[i++] = RenderPoiType.AREA_DELIVERER_DELIVERER_LOCATION;
        }
        return result;
    }

    private static boolean hasAreaDelivererInCurrentLayer(PoiModel poi, AreaLayerModel areaLayerModel) {
        for (AreaDelivererModel deliverer : poi.iterableAreaDeliverers()) {
            for (AreaDelivererLayerRelationModel rel : deliverer.iterableAreaDelivererLayerRelations()) {
                if (!new EqualsBuilder().append(rel.getAreaLayer(), areaLayerModel).isEquals()) continue;
                return true;
            }
        }
        return false;
    }

    private static RenderPoiType[] getRendererPoiTypeAreaLocation(PoiModel poi, AreaLayerModel areaLayerModel) {
        boolean regular = false;
        boolean start = false;
        boolean end = false;
        if (areaLayerModel != null) {
            for (AreaObjectModel areaObject : poi.iterableAreaObjects()) {
                if (!areaLayerModel.equals(areaObject.getAreaLayer())) continue;
                regular = true;
                break;
            }
            for (AreaObjectModel areaObject : poi.iterableFirstThrowAreaObjects()) {
                if (!areaLayerModel.equals(areaObject.getAreaLayer())) continue;
                start = true;
                break;
            }
            for (AreaObjectModel areaObject : poi.iterableLastThrowAreaObjects()) {
                if (!areaLayerModel.equals(areaObject.getAreaLayer())) continue;
                end = true;
                break;
            }
        }
        boolean inactive = !regular && !start && !end;
        RenderPoiType[] result = new RenderPoiType[PrimitiveUtil.countTrues(regular, start, end, inactive)];
        int i = 0;
        if (regular) {
            result[i++] = RenderPoiType.REGULAR_AREA_OBJECT_LOCATION;
        }
        if (start) {
            result[i++] = RenderPoiType.START_PICK_POINT_AREA_OBJECT_LOCATION;
        }
        if (end) {
            result[i++] = RenderPoiType.END_PICK_POINT_AREA_OBJECT_LOCATION;
        }
        if (inactive) {
            result[i++] = RenderPoiType.INACTIVE_AREA_OBJECT_LOCATION;
        }
        return result;
    }

    @Override
    public AbstractFilterableMarkerNavigatorRenderer.RenderObjectType getRenderObjectType() {
        return AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.POIRENDERER;
    }

    @Override
    protected Iterable<? extends Model> getChangeListeningModels(PoiLocationObject s) {
        return ((PoiModel)s.getModel()).iterablePoiAttributeValues();
    }

    @Override
    public void defaultSelectionChanged(PatterLegendSelectionEvent<PoiFilterModel> event) {
        super.defaultSelectionChanged(event);
        if (this.poiFilterPatternSetupRendererSelektor != null) {
            this.poiFilterPatternSetupRendererSelektor.setShowFilterDefault(event.isSelected());
        }
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    @Override
    public void filterSelectionChanged(PatterLegendSelectionEvent<PoiFilterModel> event) {
        super.filterSelectionChanged(event);
        if (this.poiFilterPatternSetupRendererSelektor != null) {
            this.poiFilterPatternSetupRendererSelektor.turnFilter(event.getObjectFilter(), event.isSelected());
        }
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setMainDelivererLocationActive(boolean mainDelivererLocationActive) {
        this.mainDelivererLocationActive = mainDelivererLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setBranchDelivererLocationActive(boolean branchDelivererLocationActive) {
        this.branchDelivererLocationActive = branchDelivererLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setDelivererDelivererLocationActive(boolean delivererDelivererLocationActive) {
        this.delivererDelivererLocationActive = delivererDelivererLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setAreaDelivererDelivererLocationActive(boolean areaDelivererDelivererLocationActive) {
        this.areaDelivererDelivererLocationActive = areaDelivererDelivererLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setRegularAreaObjectLocationActive(boolean regularAreaObjectLocationActive) {
        this.regularAreaObjectLocationActive = regularAreaObjectLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setStartPickPointAreaObjectLocationActive(boolean startPickPointAreaObjectLocationActive) {
        this.startPickPointAreaObjectLocationActive = startPickPointAreaObjectLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setEndPickPointAreaObjectLocationActive(boolean endPickPointAreaObjectLocationActive) {
        this.endPickPointAreaObjectLocationActive = endPickPointAreaObjectLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setInactiveAreaObjectLocationActive(boolean inactiveAreaObjectLocationActive) {
        this.inactiveAreaObjectLocationActive = inactiveAreaObjectLocationActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setCustomerActive(boolean customerActive) {
        this.customerActive = customerActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setPickPointActive(boolean pickPointActive) {
        this.pickPointActive = pickPointActive;
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    private static class DefaultPoiRenderer
    extends AbstractRenderer<DefaultRendererProperties, ImmutablePoint, PoiLocationObject>
    implements PointRenderer<DefaultRendererProperties, PoiLocationObject> {
        private Image[] images = new Image[RenderPoiType.values().length];
        private AreaLayerModel areaLayerModel;

        public DefaultPoiRenderer(AreaLayerModel areaLayerModel) {
            this.areaLayerModel = areaLayerModel;
        }

        @Override
        public void render(Graphics2D g2d, PoiLocationObject u, ImmutablePoint geom, DefaultRendererProperties rendererProperties) {
            Image image;
            PoiModel poiModel = (PoiModel)u.getModel();
            ImageModel imageModel = poiModel.getImage();
            if (imageModel == null) {
                RenderPoiType[] renderPoiTypes = PoiFilterableMarkerRenderer.getRendererPoiType(u, this.areaLayerModel);
                image = this.getImage(renderPoiTypes);
            } else {
                try {
                    ImageIcon imageIcon = new ImageIcon(imageModel.getData());
                    image = imageIcon.getImage();
                }
                catch (Exception e) {
                    RenderPoiType[] renderPoiTypes = PoiFilterableMarkerRenderer.getRendererPoiType(u, this.areaLayerModel);
                    image = this.getImage(renderPoiTypes);
                }
            }
            if (image != null) {
                AffineTransform transform = g2d.getTransform();
                double scaleX = transform.getScaleX();
                double scaleY = transform.getScaleY();
                g2d.scale(1.0 / scaleX, 1.0 / scaleY);
                int width = image.getWidth(null) / 2;
                int height = image.getHeight(null) / 2;
                double x = geom.getX() * scaleX;
                double y = geom.getY() * scaleY;
                g2d.drawImage(image, (int)Math.round(x - (double)width), (int)Math.round(y - (double)height), null);
                g2d.setTransform(transform);
            }
        }

        private Image getImage(RenderPoiType[] renderPoiTypes) {
            if (renderPoiTypes == null || renderPoiTypes.length == 0) {
                return null;
            }
            Arrays.sort((Object[])renderPoiTypes);
            RenderPoiType renderPoiType = renderPoiTypes[0];
            int ord = renderPoiType.ordinal();
            Image image = this.images[ord];
            if (image == null) {
                try {
                    image = ImageIO.read(DefaultPoiRenderer.class.getResourceAsStream("/images/poi/" + renderPoiType.name() + ".png"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.images[ord] = image;
            }
            return image;
        }

        @Override
        public DefaultRendererProperties createRendererProperties(PoiLocationObject u) {
            return new DefaultRendererProperties();
        }

        @Override
        public Dimension getOptimalPreviewDimension() {
            return new Dimension(10, 10);
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void render(Graphics2D g2d, PoiLocationObject u, Collection<ImmutablePoint> geom, DefaultRendererProperties rendererProperties) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }
    }

    public static enum RenderPoiType {
        MAIN_DELIVERER_LOCATION,
        BRANCH_DELIVERER_LOCATION,
        DELIVERER_DELIVERER_LOCATION,
        AREA_DELIVERER_DELIVERER_LOCATION,
        REGULAR_AREA_OBJECT_LOCATION,
        START_PICK_POINT_AREA_OBJECT_LOCATION,
        END_PICK_POINT_AREA_OBJECT_LOCATION,
        INACTIVE_AREA_OBJECT_LOCATION,
        CUSTOMER,
        PICK_POINT;

    }
}

