/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.poi;

import de.datomino.peppergis.client.gui.poi.area.PoiDialogAreaTableModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.util.comparator.ComparatorBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class PoiDialogAreaObjectPane
extends JPanel {
    private static final long serialVersionUID = 7899615497741424304L;
    private static final AreaObjectComparator AREA_OBJECT_COMPARATOR = new AreaObjectComparator();
    private JTable areaTable;

    public PoiDialogAreaObjectPane(PoiModel poiModel) {
        super(new BorderLayout());
        this.buildLayout();
        this.fillValues(poiModel);
    }

    private void fillValues(PoiModel poiModel) {
        ArrayList<AreaObjectModel> areas = new ArrayList<AreaObjectModel>(poiModel.countAreaObjects());
        for (AreaObjectModel area : poiModel.iterableAreaObjects()) {
            areas.add(area);
        }
        Collections.sort(areas, AREA_OBJECT_COMPARATOR);
        PoiDialogAreaTableModel poiDialogAreaTableModel = (PoiDialogAreaTableModel)this.areaTable.getModel();
        poiDialogAreaTableModel.setAreas(areas);
    }

    private void buildLayout() {
        this.areaTable = new JTable(new PoiDialogAreaTableModel());
        this.areaTable.getTableHeader().setReorderingAllowed(false);
        this.add((Component)new JScrollPane(this.areaTable), "Center");
    }

    private static class AreaObjectComparator
    implements Comparator<AreaObjectModel> {
        private AreaObjectComparator() {
        }

        @Override
        public int compare(AreaObjectModel o1, AreaObjectModel o2) {
            AreaLayerModel layer1 = o1.getAreaLayer();
            AreaLayerModel layer2 = o2.getAreaLayer();
            return new ComparatorBuilder().append(layer1.getDisplayname(), layer2.getDisplayname()).append(layer1.getId(), layer2.getId()).append(o1.getShortcut(), o2.getShortcut()).append(o1.getDisplayname(), o2.getDisplayname()).compare();
        }
    }
}

