/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.pdf;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.PdfModel;
import de.datomino.peppergis.client.model.base.PdfModelImpl;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;

public class PdfListChooserPane
extends JPanel {
    private static final long serialVersionUID = -7070312235506140746L;
    private JList pdfs;
    private JTextField name;
    private AddPdfAction addPdfAction;
    private RemovePdfAction removePdfAction;
    private ShowPdfAction showPdfAction;
    private ModelEnviroment modelEnviroment;
    private boolean editable;

    public PdfListChooserPane(ModelEnviroment modelEnviroment) {
        this(modelEnviroment, true);
    }

    public PdfListChooserPane(ModelEnviroment modelEnviroment, boolean editable) {
        super(new BorderLayout());
        this.editable = editable;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout(editable);
        this.loadPdfs();
    }

    private void loadPdfs() {
        Collection<PdfModel> pdfs = this.modelEnviroment.getAllCaller().getBaseCaller().getAllPdfs();
        DefaultListModel dlm = (DefaultListModel)this.pdfs.getModel();
        for (PdfModel pdfModel : pdfs) {
            dlm.addElement(pdfModel);
        }
    }

    private void buildLayout(boolean editable) {
        this.pdfs = new JList(new DefaultListModel());
        this.pdfs.setSelectionMode(0);
        this.pdfs.addListSelectionListener(new PdfListSelectionListener());
        this.pdfs.setCellRenderer(new AbstractStringListCellRenderer(this.pdfs.getCellRenderer()){

            @Override
            protected String getString(Object value) {
                PdfModel pdfModel = (PdfModel)value;
                return pdfModel.getName();
            }
        });
        this.add((Component)new JScrollPane(this.pdfs), "Center");
        JPanel bottomPanel = new JPanel(new SpringLayout());
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])), "West");
        this.name = new JTextField(10);
        this.name.getDocument().addDocumentListener(new PdfDocumentListener());
        this.name.setEditable(editable);
        namePanel.add((Component)this.name, "Center");
        bottomPanel.add(namePanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        if (editable) {
            this.addPdfAction = new AddPdfAction();
            JButton add = new JButton(this.addPdfAction);
            buttonPanel.add(add);
            this.removePdfAction = new RemovePdfAction();
            JButton remove = new JButton(this.removePdfAction);
            buttonPanel.add(remove);
            this.showPdfAction = new ShowPdfAction();
            JButton showPdf = new JButton(this.showPdfAction);
            buttonPanel.add(showPdf);
        }
        bottomPanel.add(buttonPanel);
        SpringUtilities.makeCompactGrid(bottomPanel, 2, 1, 2, 2, 2, 2);
        this.add((Component)bottomPanel, "South");
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.editable) {
            boolean selected = enabled && !this.pdfs.isSelectionEmpty();
            this.addPdfAction.setEnabled(enabled);
            this.name.setEditable(selected);
            this.removePdfAction.setEnabled(selected);
            this.showPdfAction.setEnabled(selected);
        } else {
            this.name.setEditable(enabled);
            this.showPdfAction.setEnabled(enabled);
        }
    }

    public Long getSelectedPdfModelId() {
        PdfModel pdfModel = (PdfModel)this.pdfs.getSelectedValue();
        return pdfModel == null ? null : pdfModel.getId();
    }

    public PdfModel getSelectedPdf() {
        return (PdfModel)this.pdfs.getSelectedValue();
    }

    private class ShowPdfAction
    extends AbstractAction {
        private static final long serialVersionUID = 1994271550870533460L;

        public ShowPdfAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("buttons.show", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfModel pdfModel = (PdfModel)PdfListChooserPane.this.pdfs.getSelectedValue();
            try {
                PdfUtil.showPdf(new ByteArrayInputStream(pdfModel.getData()));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class AddPdfAction
    extends AbstractAction {
        private static final long serialVersionUID = -2089813091300724011L;

        public AddPdfAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int d;
            File dir;
            JFileChooser fc = new JFileChooser();
            fc.setMultiSelectionEnabled(false);
            for (FileFilter fileFilter : fc.getChoosableFileFilters()) {
                fc.removeChoosableFileFilter(fileFilter);
            }
            fc.setFileSelectionMode(0);
            FileNameExtensionFilter first = new FileNameExtensionFilter("PDF", "pdf");
            fc.addChoosableFileFilter(first);
            fc.setFileFilter(first);
            String directory = ModelEnviroment.getProperties().getProperty("global.file.directory");
            if (directory != null && (dir = new File(directory)).exists()) {
                fc.setCurrentDirectory(dir);
            }
            if ((d = fc.showOpenDialog(PdfListChooserPane.this)) == 0) {
                File dir2 = fc.getCurrentDirectory();
                try {
                    ModelEnviroment.getProperties().setProperty("global.file.directory", dir2.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                File file = fc.getSelectedFile();
                PdfModelImpl pdfModel = new PdfModelImpl();
                pdfModel.setName(ModelEnviroment.getMessageResolver().resolveMessage("messages.pdfs.newPdf", new Serializable[0]));
                try {
                    byte[] data = FileUtils.readFileToByteArray(file);
                    pdfModel.setData(data);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                DefaultListModel dlm = (DefaultListModel)PdfListChooserPane.this.pdfs.getModel();
                dlm.addElement(pdfModel);
                PdfListChooserPane.this.pdfs.setSelectedValue(pdfModel, true);
                PdfListChooserPane.this.name.select(0, PdfListChooserPane.this.name.getText().length());
                PdfListChooserPane.this.name.requestFocusInWindow();
            }
        }
    }

    private class PdfDocumentListener
    implements DocumentListener {
        private PdfDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PdfModel pdfModel = (PdfModel)PdfListChooserPane.this.pdfs.getSelectedValue();
            pdfModel.setName(PdfListChooserPane.this.name.getText());
            PdfListChooserPane.this.pdfs.repaint(1L);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PdfModel pdfModel = (PdfModel)PdfListChooserPane.this.pdfs.getSelectedValue();
            pdfModel.setName(PdfListChooserPane.this.name.getText());
            PdfListChooserPane.this.pdfs.repaint(1L);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PdfModel pdfModel = (PdfModel)PdfListChooserPane.this.pdfs.getSelectedValue();
            pdfModel.setName(PdfListChooserPane.this.name.getText());
            PdfListChooserPane.this.pdfs.repaint(1L);
        }
    }

    private class PdfListSelectionListener
    implements ListSelectionListener {
        private PdfListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PdfListChooserPane.this.setEnabled(PdfListChooserPane.this.isEnabled());
            PdfModel pdfModel = (PdfModel)PdfListChooserPane.this.pdfs.getSelectedValue();
            if (pdfModel != null) {
                PdfListChooserPane.this.name.setText(pdfModel.getName());
            }
        }
    }

    private class RemovePdfAction
    extends AbstractAction {
        private static final long serialVersionUID = 4820863861952262954L;

        private RemovePdfAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfModel pdfModel = (PdfModel)PdfListChooserPane.this.pdfs.getSelectedValue();
            pdfModel.delete();
            DefaultListModel dlm = (DefaultListModel)PdfListChooserPane.this.pdfs.getModel();
            dlm.removeElement(pdfModel);
        }
    }
}

