/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel.arearelation;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class AreaRelationTableModel2
implements TableModel {
    private List<AreaObjectParcelRelModel> rels = new ArrayList<AreaObjectParcelRelModel>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private ParcelModel parcelModel;

    public AreaRelationTableModel2(ParcelModel parcel) {
        this.parcelModel = parcel;
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : this.parcelModel.iterableAreaObjectParcelRel()) {
            this.rels.add(areaObjectParcelRelModel);
        }
        Collections.sort(this.rels, new Comparator<AreaObjectParcelRelModel>(){

            @Override
            public int compare(AreaObjectParcelRelModel o1, AreaObjectParcelRelModel o2) {
                AreaObjectModel area2;
                AreaObjectModel area1 = o1.getAreaObject();
                if (area1 == (area2 = o2.getAreaObject())) {
                    return 0;
                }
                if (area1 == null) {
                    return -1;
                }
                if (area2 == null) {
                    return 1;
                }
                AreaLayerModel layer1 = area1.getAreaLayer();
                AreaLayerModel layer2 = area2.getAreaLayer();
                int d = 0;
                if (layer1 != layer2) {
                    if (layer1 == null) {
                        d = -1;
                    }
                    if (layer2 == null) {
                        d = 1;
                    }
                    if (d == 0) {
                        d = layer1.getDisplayname().compareTo(layer2.getDisplayname());
                    }
                }
                if (d == 0) {
                    d = area1.getShortcut().compareTo(area2.getShortcut());
                }
                return d;
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.rels.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]);
            }
            case 1: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]);
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]);
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AreaObjectParcelRelModel rel = this.rels.get(rowIndex);
        AreaObjectModel areaObject = rel.getAreaObject();
        if (areaObject != null) {
            switch (columnIndex) {
                case 0: {
                    AreaLayerModel areaLayer = areaObject.getAreaLayer();
                    return areaLayer == null ? "" : areaLayer.getDisplayname();
                }
                case 1: {
                    return areaObject.getShortcut();
                }
                case 2: {
                    return areaObject.getDisplayname();
                }
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void addAreaObjectParcelRelModel(AreaObjectParcelRelModel areaObjectParcelRelModel) {
        this.rels.add(areaObjectParcelRelModel);
        this.fireTableChanged();
    }

    private void fireTableChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public AreaObjectParcelRelModel removeAreaObjectParcelObjectAt(int selectedRow) {
        AreaObjectParcelRelModel remove = this.rels.remove(selectedRow);
        this.fireTableChanged();
        return remove;
    }
}

