/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.parcel;

import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import java.util.Comparator;

public class StreetComparator
implements Comparator<StreetModel> {
    public static final StreetComparator INSTANCE = new StreetComparator();

    protected StreetComparator() {
    }

    @Override
    public int compare(StreetModel o1, StreetModel o2) {
        PostcodeDistrictRelationModel pdr1 = o1.getPostcodeDistrictRelation();
        PostcodeDistrictRelationModel pdr2 = o2.getPostcodeDistrictRelation();
        PostcodeModel p1 = pdr1.getPostcode();
        PostcodeModel p2 = pdr2.getPostcode();
        int d = p1.getCountry().name().compareTo(p2.getCountry().name());
        if (d == 0 && (d = p1.getName().compareTo(p2.getName())) == 0) {
            DistrictModel district1 = pdr1.getDistrict();
            DistrictModel district2 = pdr2.getDistrict();
            CityModel city1 = district1.getCity();
            CityModel city2 = district2.getCity();
            d = city1.getName().compareTo(city2.getName());
            if (d == 0 && (d = district1.getName().compareTo(district2.getName())) == 0) {
                d = o1.getName().compareTo(o2.getName());
            }
        }
        return d;
    }
}

